/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.SinglePoolElementAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructurePoolAccessor;
import com.telepathicgrunt.the_bumblezone.utils.BoxOctree;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class OptimizedJigsawManager {
    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext context, Holder<StructureTemplatePool> startPoolHolder, int size, ResourceLocation structureID, BlockPos startPos, boolean doBoundaryAdjustments, Optional<Heightmap.Types> heightmapType, int maxDistanceFromCenter, BiConsumer<StructurePiecesBuilder, List<PoolElementStructurePiece>> structureBoundsAdjuster, boolean ignoreBounds, LiquidSettings liquidSettings) {
        return OptimizedJigsawManager.assembleJigsawStructure(context, startPoolHolder, size, structureID, startPos, doBoundaryAdjustments, heightmapType, maxDistanceFromCenter, Optional.empty(), structureBoundsAdjuster, ignoreBounds, liquidSettings);
    }

    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext context, Holder<StructureTemplatePool> startPoolHolder, int size, ResourceLocation structureID, BlockPos startPos, boolean doBoundaryAdjustments, Optional<Heightmap.Types> heightmapType, int maxDistanceFromCenter, Optional<Integer> minYLimit, BiConsumer<StructurePiecesBuilder, List<PoolElementStructurePiece>> structureBoundsAdjuster, boolean ignoreBounds, LiquidSettings liquidSettings) {
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        StructureTemplatePool startPool = (StructureTemplatePool)startPoolHolder.value();
        if (startPool.size() == 0) {
            Bumblezone.LOGGER.warn("Bumblezone: Empty or nonexistent start pool in structure: {}  Crash is imminent", (Object)structureID);
            throw new RuntimeException("Bumblezone: Empty or nonexistent start pool in structure: " + String.valueOf(structureID) + " Crash is imminent");
        }
        StructurePoolElement startPieceBlueprint = startPool.getRandomTemplate((RandomSource)random);
        if (startPieceBlueprint == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (!context.validBiome().test(context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)startPos.getX()), QuartPos.fromBlock((int)startPos.getY()), QuartPos.fromBlock((int)startPos.getZ()), context.randomState().sampler()))) {
            return Optional.empty();
        }
        Rotation rotation = Rotation.getRandom((RandomSource)random);
        PoolElementStructurePiece startPiece = new PoolElementStructurePiece(context.structureTemplateManager(), startPieceBlueprint, startPos, startPieceBlueprint.getGroundLevelDelta(), rotation, startPieceBlueprint.getBoundingBox(context.structureTemplateManager(), startPos, rotation), liquidSettings);
        BoundingBox pieceBoundingBox = startPiece.getBoundingBox();
        int pieceCenterX = (pieceBoundingBox.maxX() + pieceBoundingBox.minX()) / 2;
        int pieceCenterZ = (pieceBoundingBox.maxZ() + pieceBoundingBox.minZ()) / 2;
        int pieceCenterY = startPos.getY();
        if (heightmapType.isPresent()) {
            if ((pieceCenterY += GeneralUtils.getLowestLand(context.chunkGenerator(), context.randomState(), startPos, context.heightAccessor(), true, heightmapType.get() == Heightmap.Types.OCEAN_FLOOR_WG).getY()) >= GeneralUtils.getMaxTerrainLimit(context.chunkGenerator()) - pieceBoundingBox.maxY()) {
                return Optional.empty();
            }
            if (pieceCenterY <= context.chunkGenerator().getMinY()) {
                return Optional.empty();
            }
        }
        int yAdjustment = pieceBoundingBox.minY() + startPiece.getGroundLevelDelta();
        startPiece.move(0, pieceCenterY - yAdjustment, 0);
        int finalPieceCenterY = pieceCenterY;
        Registry jigsawPoolRegistry = context.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        return Optional.of(new Structure.GenerationStub(new BlockPos(pieceCenterX, pieceCenterY, pieceCenterZ), structurePiecesBuilder -> {
            ArrayList<PoolElementStructurePiece> components = new ArrayList<PoolElementStructurePiece>();
            components.add(startPiece);
            components.clear();
            components.add(startPiece);
            if (size > 0) {
                AABB axisAlignedBB = new AABB((double)(pieceCenterX - maxDistanceFromCenter), (double)(finalPieceCenterY - (maxDistanceFromCenter + 40)), (double)(pieceCenterZ - maxDistanceFromCenter), (double)(pieceCenterX + maxDistanceFromCenter + 1), (double)(finalPieceCenterY + (maxDistanceFromCenter + 120)), (double)(pieceCenterZ + maxDistanceFromCenter + 1));
                BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                boxOctree.addBox(AABB.of((BoundingBox)pieceBoundingBox));
                Entry startPieceEntry = new Entry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), finalPieceCenterY + 80, 0);
                Assembler assembler = new Assembler((Registry<StructureTemplatePool>)jigsawPoolRegistry, size, context, components, (RandomSource)random, minYLimit, ignoreBounds);
                assembler.availablePieces.addLast(startPieceEntry);
                while (!assembler.availablePieces.isEmpty()) {
                    Entry entry = assembler.availablePieces.removeFirst();
                    assembler.generatePiece(entry.piece, entry.boxOctreeMutableObject, entry.topYLimit, entry.depth, doBoundaryAdjustments, context.heightAccessor(), liquidSettings);
                }
            }
            components.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).addPiece(arg_0));
            structureBoundsAdjuster.accept((StructurePiecesBuilder)structurePiecesBuilder, (List<PoolElementStructurePiece>)components);
            if (structurePiecesBuilder.getBoundingBox().maxY() > context.heightAccessor().getMaxBuildHeight()) {
                structurePiecesBuilder.clear();
                return;
            }
            if (components.isEmpty()) {
                return;
            }
            BlockPos structureCenter = ((PoolElementStructurePiece)components.get(0)).getBoundingBox().getCenter();
            int xOffset = startPos.getX() - structureCenter.getX();
            int zOffset = startPos.getZ() - structureCenter.getZ();
            for (StructurePiece structurePiece : components) {
                structurePiece.move(xOffset, 0, zOffset);
            }
        }));
    }

    public record Entry(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctreeMutableObject, int topYLimit, int depth) {
    }

    public static final class Assembler {
        private final Registry<StructureTemplatePool> poolRegistry;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final RandomState randomState;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> structurePieces;
        private final RandomSource random;
        private final Optional<Integer> minYLimit;
        private final boolean ignoreBounds;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();

        public Assembler(Registry<StructureTemplatePool> poolRegistry, int maxDepth, Structure.GenerationContext context, List<? super PoolElementStructurePiece> structurePieces, RandomSource random, Optional<Integer> minYLimit, boolean ignoreBounds) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = context.chunkGenerator();
            this.randomState = context.randomState();
            this.structureTemplateManager = context.structureTemplateManager();
            this.structurePieces = structurePieces;
            this.random = random;
            this.minYLimit = minYLimit;
            this.ignoreBounds = ignoreBounds;
        }

        public void generatePiece(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments, LevelHeightAccessor heightLimitView, LiquidSettings liquidSettings) {
            StructurePoolElement pieceBlueprint = piece.getElement();
            BlockPos piecePos = piece.getPosition();
            Rotation pieceRotation = piece.getRotation();
            BoundingBox pieceBoundingBox = piece.getBoundingBox();
            int pieceMinY = pieceBoundingBox.minY();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.getShuffledJigsawBlocks(this.structureTemplateManager, piecePos, pieceRotation, this.random);
            for (StructureTemplate.StructureBlockInfo jigsawBlock : pieceJigsawBlocks) {
                StructurePoolElement generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<BoxOctree> octreeToUse;
                Direction direction = JigsawBlock.getFrontFacing((BlockState)jigsawBlock.state());
                BlockPos jigsawBlockPos = jigsawBlock.pos();
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.relative(direction);
                ResourceLocation jigsawBlockPool = ResourceLocation.tryParse((String)jigsawBlock.nbt().getString("pool"));
                Optional poolOptional = this.poolRegistry.getOptional(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((StructureTemplatePool)poolOptional.get()).size() == 0 && !Objects.equals(jigsawBlockPool, Pools.EMPTY.location())) {
                    Bumblezone.LOGGER.warn("Bumblezone: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof SinglePoolElement ? ((SinglePoolElementAccessor)pieceBlueprint).getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                Holder fallbackOptional = ((StructureTemplatePool)poolOptional.get()).getFallback();
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.isInside((Vec3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    targetPieceBoundsTop = pieceMinY;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(AABB.of((BoundingBox)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)poolOptional.get()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, liquidSettings)) != null) continue;
                this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)fallbackOptional.value()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, liquidSettings);
            }
        }

        private StructurePoolElement processList(List<Pair<StructurePoolElement, Integer>> candidatePieces, boolean doBoundaryAdjustments, StructureTemplate.StructureBlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<BoxOctree> boxOctreeMutableObject, PoolElementStructurePiece piece, int depth, int targetPieceBoundsTop, LevelHeightAccessor heightLimitView, LiquidSettings liquidSettings) {
            StructureTemplatePool.Projection piecePlacementBehavior = piece.getElement().getProjection();
            boolean isPieceRigid = piecePlacementBehavior == StructureTemplatePool.Projection.RIGID;
            int jigsawBlockRelativeY = jigsawBlockPos.getY() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                StructurePoolElement candidatePiece;
                Pair<StructurePoolElement, Integer> chosenPiecePair = candidatePieces.get(0);
                int chosenWeight = this.random.nextInt(totalCount) + 1;
                for (Pair<StructurePoolElement, Integer> candidate : candidatePieces) {
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPiecePair = candidate;
                    break;
                }
                if ((candidatePiece = (StructurePoolElement)chosenPiecePair.getFirst()) == EmptyPoolElement.INSTANCE) {
                    return null;
                }
                for (Rotation rotation : Rotation.getShuffled((RandomSource)this.random)) {
                    List candidateJigsawBlocks = candidatePiece.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, rotation, this.random);
                    BoundingBox tempCandidateBoundingBox = candidatePiece.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.getYSpan() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.isInside((Vec3i)pieceCandidateJigsawBlock.pos().relative(JigsawBlock.getFrontFacing((BlockState)pieceCandidateJigsawBlock.state())))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = ResourceLocation.tryParse((String)pieceCandidateJigsawBlock.nbt().getString("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.getOptional(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(structureTemplatePool -> Optional.of((StructureTemplatePool)structureTemplatePool.getFallback().value()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.getMaxSize(this.structureTemplateManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.getMaxSize(this.structureTemplateManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!GeneralUtils.canJigsawsAttach(jigsawBlock, candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.pos();
                        BlockPos candidateJigsawBlockRelativePos = new BlockPos(jigsawBlockTargetPos.getX() - candidateJigsawBlockPos.getX(), jigsawBlockTargetPos.getY() - candidateJigsawBlockPos.getY(), jigsawBlockTargetPos.getZ() - candidateJigsawBlockPos.getZ());
                        BoundingBox candidateBoundingBox = candidatePiece.getBoundingBox(this.structureTemplateManager, candidateJigsawBlockRelativePos, rotation);
                        StructureTemplatePool.Projection candidatePlacementBehavior = candidatePiece.getProjection();
                        boolean isCandidateRigid = candidatePlacementBehavior == StructureTemplatePool.Projection.RIGID;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.getY();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.getFrontFacing((BlockState)jigsawBlock.state()).getStepY();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.getFirstFreeHeight(jigsawBlockPos.getX(), jigsawBlockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.randomState);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.minY();
                        BoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.moved(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.offset(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.maxY() - adjustedCandidateBoundingBox.minY());
                            adjustedCandidateBoundingBox.encapsulate(new BlockPos(adjustedCandidateBoundingBox.minX(), adjustedCandidateBoundingBox.minY() + k2, adjustedCandidateBoundingBox.minZ()));
                        }
                        if (adjustedCandidateJigsawBlockRelativePos.getY() < this.minYLimit.orElse(Integer.MIN_VALUE)) continue;
                        AABB axisAlignedBB = AABB.of((BoundingBox)adjustedCandidateBoundingBox);
                        AABB axisAlignedBBDeflated = axisAlignedBB.deflate(0.25);
                        boolean validBounds = false;
                        if (!this.ignoreBounds && ((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(axisAlignedBBDeflated) && !((BoxOctree)boxOctreeMutableObject.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) {
                            ((BoxOctree)boxOctreeMutableObject.getValue()).addBox(axisAlignedBB);
                            validBounds = true;
                        }
                        if (!this.ignoreBounds && !validBounds) continue;
                        int newPieceGroundLevelDelta = piece.getGroundLevelDelta();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.getGroundLevelDelta();
                        PoolElementStructurePiece newPiece = new PoolElementStructurePiece(this.structureTemplateManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox, liquidSettings);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.getFirstFreeHeight(jigsawBlockPos.getX(), jigsawBlockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.randomState);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.addJunction(new JigsawJunction(jigsawBlockTargetPos.getX(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.getZ(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.addJunction(new JigsawJunction(jigsawBlockPos.getX(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.getZ(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((PoolElementStructurePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, boxOctreeMutableObject, targetPieceBoundsTop, depth + 1));
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

