/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TickFluidProcessor
extends StructureProcessor {
    public static final MapCodec<TickFluidProcessor> CODEC = MapCodec.unit(TickFluidProcessor::new);

    private TickFluidProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        if (!infoIn2.state().getFluidState().isEmpty()) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(infoIn2.pos()))) {
                return infoIn2;
            }
            ChunkAccess chunk = levelReader.getChunk(infoIn2.pos());
            int minY = chunk.getMinBuildHeight();
            int maxY = chunk.getMaxBuildHeight();
            int currentY = infoIn2.pos().getY();
            if (currentY >= minY && currentY <= maxY) {
                ((LevelAccessor)levelReader).scheduleTick(infoIn2.pos(), infoIn2.state().getBlock(), 0);
            }
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.TICK_FLUID_PROCESSOR.get();
    }
}

