/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RandomReplaceWithPropertiesProcessor
extends StructureProcessor {
    public static final MapCodec<RandomReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("output_block").forGetter(config -> config.outputBlock), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().optionalFieldOf("output_blocks", (Object)ImmutableList.of()).forGetter(config -> config.outputBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability))).apply((Applicative)instance, instance.stable(RandomReplaceWithPropertiesProcessor::new)));
    private final Block inputBlock;
    private final Optional<Block> outputBlock;
    private final List<Block> outputBlocks;
    private final float probability;

    public RandomReplaceWithPropertiesProcessor(Block inputBlock, Optional<Block> outputBlock, List<Block> outputBlocks, float probability) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.outputBlocks = outputBlocks;
        this.probability = probability;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (structureBlockInfoWorld.state().getBlock() == this.inputBlock) {
            BlockPos worldPos = structureBlockInfoWorld.pos();
            RandomSource random = RandomSource.create();
            int offSet = settings.getProcessors().indexOf((Object)this) + 1;
            random.setSeed(worldPos.asLong() * worldPos.asLong() * (long)offSet);
            if (random.nextFloat() < this.probability) {
                if (this.outputBlock.isPresent()) {
                    BlockState newBlockState = this.outputBlock.get().defaultBlockState();
                    for (Property property : structureBlockInfoWorld.state().getProperties()) {
                        if (!newBlockState.hasProperty(property)) continue;
                        newBlockState = GeneralUtils.getStateWithProperty(newBlockState, structureBlockInfoWorld.state(), property);
                    }
                    return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), newBlockState, structureBlockInfoWorld.nbt());
                }
                if (!this.outputBlocks.isEmpty()) {
                    BlockState newBlockState = this.outputBlocks.get(random.nextInt(this.outputBlocks.size())).defaultBlockState();
                    for (Property property : structureBlockInfoWorld.state().getProperties()) {
                        if (!newBlockState.hasProperty(property)) continue;
                        newBlockState = GeneralUtils.getStateWithProperty(newBlockState, structureBlockInfoWorld.state(), property);
                    }
                    return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), newBlockState, structureBlockInfoWorld.nbt());
                }
                Bumblezone.LOGGER.warn("The Bumblezone: the_bumblezone:random_replace_with_properties_processor in a processor file has no replacement block of any kind.");
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.RANDOM_REPLACE_WITH_PROPERTIES_PROCESSOR.get();
    }
}

