/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PollenPilingProcessor
extends StructureProcessor {
    public static final MapCodec<PollenPilingProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("xz_scale").forGetter(config -> Float.valueOf(config.xzScale)), (App)Codec.FLOAT.fieldOf("y_scale").forGetter(config -> Float.valueOf(config.yScale)), (App)Codec.BOOL.fieldOf("pollen_replace_solids").forGetter(config -> config.pollenReplaceSolids)).apply((Applicative)instance, instance.stable(PollenPilingProcessor::new)));
    private final float xzScale;
    private final float yScale;
    private final boolean pollenReplaceSolids;
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public PollenPilingProcessor(float xzScale, float yScale, boolean pollenReplaceSolids) {
        this.xzScale = xzScale;
        this.yScale = yScale;
        this.pollenReplaceSolids = pollenReplaceSolids;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockPos abovePos;
        BlockState aboveState;
        ChunkAccess chunk;
        this.setSeed(worldView instanceof WorldGenRegion ? ((WorldGenRegion)worldView).getSeed() : 0L);
        StructureTemplate.StructureBlockInfo structureBlockInfoToReturn = structureBlockInfoWorld;
        BlockState structureState = structureBlockInfoToReturn.state();
        BlockPos worldPos = structureBlockInfoToReturn.pos();
        if (structureState.is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            if (!this.pollenReplaceSolids && !worldView.getBlockState(worldPos).isAir()) {
                return null;
            }
            BlockPos belowPos = worldPos.below();
            if (belowPos.getY() <= worldView.getMinBuildHeight() || belowPos.getY() >= worldView.getMaxBuildHeight()) {
                return null;
            }
            chunk = worldView.getChunk(belowPos);
            BlockState belowState = chunk.getBlockState(belowPos);
            if (!belowState.canOcclude()) {
                ((LevelAccessor)worldView).scheduleTick(belowPos, structureState.getBlock(), 0);
            }
            BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                sidePos.set((Vec3i)worldPos).move(direction);
                if (!worldView.getBlockState((BlockPos)sidePos).getFluidState().isSource()) continue;
                return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), null);
            }
            double noiseVal = this.noiseGenerator.noise3_Classic((float)worldPos.getX() * this.xzScale, (float)worldPos.getY() * this.yScale, (float)worldPos.getZ() * this.xzScale);
            int layerHeight = Math.max(0, (int)((noiseVal / 2.0 + 0.5) * 2.5));
            layerHeight = Math.min(8, layerHeight + (Integer)structureState.getValue((Property)PileOfPollen.LAYERS));
            structureBlockInfoToReturn = new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)structureState.setValue((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(layerHeight)), structureBlockInfoToReturn.nbt());
        }
        if (!structureState.canOcclude() && (aboveState = (chunk = worldView.getChunk(abovePos = worldPos.above())).getBlockState(abovePos)).is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            ((LevelAccessor)worldView).scheduleTick(abovePos, aboveState.getBlock(), 0);
        }
        return structureBlockInfoToReturn;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.POLLEN_PILING_PROCESSOR.get();
    }
}

