/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BeeDungeonProcessor
extends StructureProcessor {
    public static final MapCodec<BeeDungeonProcessor> CODEC = MapCodec.unit(BeeDungeonProcessor::new);

    private BeeDungeonProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.state();
        BlockPos worldPos = structureBlockInfoWorld.pos();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setSeed(worldPos.asLong() * (long)worldPos.getY());
        CompoundTag nbt = structureBlockInfoWorld.nbt();
        if (blockState.is(Blocks.STRUCTURE_BLOCK)) {
            CompoundTag compoundTag = structureBlockInfoWorld.nbt();
            if (compoundTag == null) {
                return structureBlockInfoWorld;
            }
            String metadata = compoundTag.getString("metadata");
            BlockState belowBlock = worldView.getChunk(worldPos).getBlockState(worldPos);
            if (belowBlock.isAir()) {
                blockState = Blocks.CAVE_AIR.defaultBlockState();
            } else {
                switch (metadata) {
                    case "center": {
                        if (random.nextFloat() < 0.1f) {
                            blockState = ((Block)BzBlocks.HONEY_COCOON.get()).defaultBlockState();
                            nbt = new CompoundTag();
                            nbt.putString("LootTable", "the_bumblezone:structures/bee_dungeon");
                            break;
                        }
                        if (random.nextFloat() < 0.6f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState();
                            break;
                        }
                        if (random.nextFloat() < 0.6f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.nextInt(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(random.nextInt(4) + 1));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.CAVE_AIR.defaultBlockState();
                        break;
                    }
                    case "inner_ring": {
                        if (random.nextFloat() < 0.35f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState();
                            break;
                        }
                        if (random.nextFloat() < 0.35f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.nextInt(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(random.nextInt(random.nextInt(4) + 1) + 1));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.CAVE_AIR.defaultBlockState();
                        break;
                    }
                    case "outer_ring": {
                        if (random.nextFloat() < 0.45f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState();
                            break;
                        }
                        if (random.nextFloat() < 0.2f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.nextInt(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(random.nextInt(random.nextInt(4) + 1) + 1));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.CAVE_AIR.defaultBlockState();
                        break;
                    }
                }
            }
        } else if (blockState.is(Blocks.HONEYCOMB_BLOCK) || blockState.is((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            boolean compatSuccess = false;
            for (ModCompat compat : ModChecker.DUNGEON_COMB_COMPATS) {
                if (!compat.checkCombSpawn(worldPos, (RandomSource)random, worldView, false)) continue;
                StructureTemplate.StructureBlockInfo info = compat.getHoneycomb(worldPos, (RandomSource)random, worldView, false);
                if (info != null) {
                    return info;
                }
                compatSuccess = true;
                break;
            }
            if (!compatSuccess) {
                blockState = random.nextFloat() < 0.4f ? Blocks.HONEYCOMB_BLOCK.defaultBlockState() : ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState();
            }
        } else if (blockState.is((Block)BzBlocks.HONEYCOMB_BROOD.get())) {
            blockState = random.nextFloat() < 0.6f ? (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).setValue((Property)HoneycombBrood.FACING, (Comparable)((Direction)blockState.getValue((Property)HoneycombBrood.FACING))) : (random.nextFloat() < 0.2f ? Blocks.HONEY_BLOCK.defaultBlockState() : ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState());
        } else if (blockState.is((Block)BzFluids.SUGAR_WATER_BLOCK.get()) && random.nextFloat() < 0.1f) {
            blockState = (BlockState)((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState().setValue((Property)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.BEE_DUNGEON_PROCESSOR.get();
    }
}

