/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ArenaSpecialBlockHandlerProcessor
extends StructureProcessor {
    public static final MapCodec<ArenaSpecialBlockHandlerProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("clear_containers_only").forGetter(config -> config.clearContainersOnly)).apply((Applicative)instance, instance.stable(ArenaSpecialBlockHandlerProcessor::new)));
    private final boolean clearContainersOnly;

    public ArenaSpecialBlockHandlerProcessor(boolean clearContainersOnly) {
        this.clearContainersOnly = clearContainersOnly;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (worldView instanceof Level) {
            BlockEntity blockEntity;
            Level level = (Level)worldView;
            BlockState inWorldBlockState = level.getBlockState(structureBlockInfoWorld.pos());
            if (inWorldBlockState.is(BzTags.ESSENCE_ARENA_DOES_NOT_REPLACE) && !this.clearContainersOnly) {
                EntityBlock entityBlock;
                BlockState structureBlockState = structureBlockInfoWorld.state();
                BlockEntity blockEntity2 = null;
                Block block = structureBlockState.getBlock();
                if (block instanceof EntityBlock && (blockEntity2 = (entityBlock = (EntityBlock)block).newBlockEntity(structureBlockInfoWorld.pos(), structureBlockState)) != null) {
                    blockEntity2.loadWithComponents(structureBlockInfoWorld.nbt(), (HolderLookup.Provider)worldView.registryAccess());
                }
                ItemStack itemStack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
                itemStack.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, level), 1);
                Block.dropResources((BlockState)structureBlockState, (Level)level, (BlockPos)structureBlockInfoWorld.pos(), (BlockEntity)blockEntity2, null, (ItemStack)itemStack);
                return null;
            }
            if (inWorldBlockState.hasBlockEntity() && (blockEntity = level.getBlockEntity(structureBlockInfoWorld.pos())) instanceof Container) {
                Container container = (Container)blockEntity;
                if (this.clearContainersOnly) {
                    container.clearContent();
                    container.setChanged();
                    level.setBlockEntity(blockEntity);
                } else {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
                    itemStack.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, level), 1);
                    Block.dropResources((BlockState)inWorldBlockState, (Level)level, (BlockPos)structureBlockInfoWorld.pos(), (BlockEntity)blockEntity, null, (ItemStack)itemStack);
                    level.destroyBlock(structureBlockInfoWorld.pos(), false);
                }
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.ARENA_SPECIAL_BLOCK_HANDLER_PROCESSOR.get();
    }
}

