/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features.decorators;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class HoneycombHolePlacer
extends PlacementModifier {
    private static final HoneycombHolePlacer INSTANCE = new HoneycombHolePlacer();
    public static final MapCodec<HoneycombHolePlacer> CODEC = MapCodec.unit(() -> INSTANCE);

    public static HoneycombHolePlacer honeycombHolePlacer() {
        return INSTANCE;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)BzPlacements.HONEYCOMB_HOLE_PLACER.get();
    }

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(blockPos.getX() - 4, 236, blockPos.getZ() + 4);
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        boolean alternate = false;
        List structureStarts = new ArrayList();
        List structureStartsPiecewiseCheck = new ArrayList();
        WorldGenLevel worldGenLevel = placementContext.getLevel();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            Registry structureRegistry = (Registry)worldGenRegion.registryAccess().registry(Registries.STRUCTURE).get();
            StructureManager structureManager = placementContext.getLevel().getLevel().structureManager();
            ChunkPos chunkPos = new ChunkPos(blockPos);
            structureStarts = structureManager.startsForStructure(chunkPos, struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(BzTags.NO_HONEYCOMB_HOLES));
            structureStartsPiecewiseCheck = structureManager.startsForStructure(chunkPos, struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(BzTags.NO_HONEYCOMB_HOLES_PIECEWISE));
        }
        for (int repeat = 0; repeat < 2; ++repeat) {
            for (int count = 0; count < 23; ++count) {
                if (alternate) {
                    mutableBlockPos.move(0, -8, -8);
                } else {
                    mutableBlockPos.move(0, -8, 8);
                }
                alternate = !alternate;
                boolean validSpot = true;
                for (StructureStart structureStart : structureStarts) {
                    if (!structureStart.isValid() || !structureStart.getBoundingBox().inflatedBy(8).isInside((Vec3i)mutableBlockPos)) continue;
                    validSpot = false;
                    break;
                }
                block3: for (StructureStart structureStart : structureStartsPiecewiseCheck) {
                    for (StructurePiece structurePiece : structureStart.getPieces()) {
                        if (!structurePiece.getBoundingBox().inflatedBy(8).isInside((Vec3i)mutableBlockPos)) continue;
                        validSpot = false;
                        continue block3;
                    }
                }
                if (!validSpot || !this.isPlaceValid(placementContext, (BlockPos)mutableBlockPos)) continue;
                blockPosList.add(mutableBlockPos.immutable());
            }
            mutableBlockPos.set(blockPos.getX() + 4, 236, blockPos.getZ() + 12);
        }
        return blockPosList.stream();
    }

    private boolean isPlaceValid(PlacementContext world, BlockPos pos) {
        boolean completelySolidSlice = false;
        boolean airInSlice = false;
        for (int x = -3; x <= 3; ++x) {
            SliceState state = this.StateOfThisSlice(world, pos.west(x));
            if (state == SliceState.SOLID) {
                completelySolidSlice = true;
                continue;
            }
            if (state != SliceState.AIR) continue;
            airInSlice = true;
        }
        return completelySolidSlice && airInSlice;
    }

    private SliceState StateOfThisSlice(PlacementContext world, BlockPos pos) {
        for (double z = -4.5; z <= 4.5; z += 1.0) {
            for (double y = -3.5; y <= 3.5; y += 1.0) {
                BlockState blockState;
                double distanceSq = z * z + y * y;
                if (!(distanceSq > 5.0) || !(distanceSq < 18.0) || (blockState = world.getBlockState(pos.offset(0, (int)y + 1, (int)z))).canOcclude()) continue;
                if (blockState.getBlock() == Blocks.AIR) {
                    return SliceState.AIR;
                }
                return SliceState.NEITHER;
            }
        }
        return SliceState.SOLID;
    }

    private static enum SliceState {
        NEITHER,
        AIR,
        SOLID;

    }
}

