/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class PollinatedCaves
extends Feature<NoneFeatureConfiguration> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;
    protected static OpenSimplex2F noiseGen2;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            noiseGen2 = new OpenSimplex2F(seed + 3451L);
            this.seed = seed;
        }
    }

    public PollinatedCaves(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        this.setSeed(level.getSeed());
        BlockPos.MutableBlockPos mutableBlockPos = context.origin().mutable();
        int disallowedBottomRange = Integer.MAX_VALUE;
        int disallowedTopRange = Integer.MIN_VALUE;
        WorldGenLevel worldGenLevel = context.level();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            Registry structureRegistry = (Registry)worldGenRegion.registryAccess().registry(Registries.STRUCTURE).get();
            StructureManager structureManager = context.level().getLevel().structureManager();
            ChunkPos chunkPos = new ChunkPos((BlockPos)mutableBlockPos);
            List structureStarts = structureManager.startsForStructure(chunkPos, struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(BzTags.NO_CAVES));
            for (StructureStart structureStart : structureStarts) {
                disallowedBottomRange = Math.min(disallowedBottomRange, structureStart.getBoundingBox().minY());
                disallowedTopRange = Math.max(disallowedTopRange, structureStart.getBoundingBox().maxY());
            }
        }
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.level());
        for (int y = 15; y < context.chunkGenerator().getGenDepth() - 14; ++y) {
            if (y > disallowedBottomRange && y < disallowedTopRange) continue;
            block2: for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    double heightPressure;
                    mutableBlockPos.set((Vec3i)context.origin()).move(x, y, z);
                    if (bulkSectionAccess.getSection((BlockPos)mutableBlockPos).hasOnlyAir()) {
                        x = 16;
                        y += 16 - y % 16;
                        continue block2;
                    }
                    double noise1 = noiseGen.noise3_Classic((double)mutableBlockPos.getX() * 0.019, (double)mutableBlockPos.getZ() * 0.019, (double)mutableBlockPos.getY() * 0.038);
                    if (noise1 >= 0.0360555127546399) {
                        if (noise1 >= 0.6) {
                            z += 6;
                            continue;
                        }
                        if (noise1 >= 0.4) {
                            z += 4;
                            continue;
                        }
                        if (!(noise1 >= 0.2)) continue;
                        z += 2;
                        continue;
                    }
                    double noise2 = noiseGen2.noise3_Classic((double)mutableBlockPos.getX() * 0.019, (double)mutableBlockPos.getZ() * 0.019, (double)mutableBlockPos.getY() * 0.038);
                    double finalNoise = noise1 * noise1 + noise2 * noise2 + (heightPressure = (double)Math.max((30.0f - (float)y) / 90.0f, 0.0f));
                    if (finalNoise < (double)0.01305f) {
                        PollinatedCaves.carve(level, bulkSectionAccess, mutableBlockPos, finalNoise, noise1);
                        continue;
                    }
                    if (finalNoise >= 0.6) {
                        z += 6;
                        continue;
                    }
                    if (finalNoise >= 0.4) {
                        z += 4;
                        continue;
                    }
                    if (!(finalNoise >= 0.2)) continue;
                    z += 2;
                }
            }
        }
        return true;
    }

    private static void carve(WorldGenLevel world, UnsafeBulkSectionAccess bulkSectionAccess, BlockPos.MutableBlockPos position, double finalNoise, double noise) {
        BlockState currentState = bulkSectionAccess.getBlockState((BlockPos)position);
        if (!currentState.isAir() && currentState.getFluidState().isEmpty() && !currentState.is((Block)BzBlocks.PILE_OF_POLLEN.get()) && !currentState.is(BzTags.FORCE_CAVE_TO_NOT_CARVE)) {
            if (finalNoise > (double)0.0105f) {
                if (noise * 3.0 % 2.0 < 0.35) {
                    bulkSectionAccess.setBlockState((BlockPos)position, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), false);
                    if (currentState.hasBlockEntity()) {
                        world.getChunk((BlockPos)position).removeBlockEntity((BlockPos)position);
                    }
                }
                return;
            }
            BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                sidePos.set((Vec3i)position).move(direction);
                if (bulkSectionAccess.getBlockState((BlockPos)sidePos).getFluidState().isEmpty()) continue;
                return;
            }
            position.move(Direction.DOWN);
            BlockState belowState = bulkSectionAccess.getBlockState((BlockPos)position);
            position.move(Direction.UP);
            if (currentState.hasBlockEntity()) {
                world.getChunk((BlockPos)position).removeBlockEntity((BlockPos)position);
            }
            if (!belowState.isAir() && belowState.getFluidState().isEmpty() && belowState.blocksMotion()) {
                bulkSectionAccess.setBlockState((BlockPos)position, (BlockState)((Block)BzBlocks.PILE_OF_POLLEN.get()).defaultBlockState().setValue((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf((int)Math.max(Math.min((noise + 1.0) * 3.0, 8.0), 1.0))), false);
                world.scheduleTick((BlockPos)position, (Block)BzBlocks.PILE_OF_POLLEN.get(), 0);
                int carveHeight = Math.abs((int)(noise * 1000.0 % 0.8)) * 2 + 1;
                for (int i = 0; i < carveHeight; ++i) {
                    position.move(Direction.UP);
                    for (Direction direction : Direction.values()) {
                        sidePos.set((Vec3i)position).move(direction);
                        if (bulkSectionAccess.getBlockState((BlockPos)sidePos).getFluidState().isEmpty()) continue;
                        return;
                    }
                    bulkSectionAccess.setBlockState((BlockPos)position, Blocks.CAVE_AIR.defaultBlockState(), false);
                }
                position.move(Direction.DOWN, carveHeight);
            } else {
                bulkSectionAccess.setBlockState((BlockPos)position, Blocks.CAVE_AIR.defaultBlockState(), false);
            }
        }
    }
}

