/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructureTemplateAccessor;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.NbtFeatureConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NbtFeature<T extends NbtFeatureConfig>
extends Feature<T> {
    private static final ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty");

    public NbtFeature(Codec<T> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        ResourceLocation nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(((NbtFeatureConfig)context.config()).nbtResourcelocationsAndWeights, context.random());
        StructureTemplateManager structureManager = context.level().getLevel().getStructureManager();
        Optional template = structureManager.get(nbtRL);
        if (template.isEmpty()) {
            Bumblezone.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)nbtRL);
            return false;
        }
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).getSize().getX() / 2, ((StructureTemplate)template.get()).getSize().getY() / 2, ((StructureTemplate)template.get()).getSize().getZ() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)context.origin());
        BlockPos position = context.origin().above(((NbtFeatureConfig)context.config()).structureYOffset);
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setRotation(rotation).setRotationPivot(halfLengths).setIgnoreEntities(false).setFinalizeEntities(true);
        Registry processorListRegistry = context.level().getLevel().getServer().registryAccess().registryOrThrow(Registries.PROCESSOR_LIST);
        StructureProcessorList emptyProcessor = (StructureProcessorList)processorListRegistry.get(EMPTY);
        Optional processor = processorListRegistry.getOptional(((NbtFeatureConfig)context.config()).processor);
        processor.orElse(emptyProcessor).list().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).addProcessor(arg_0));
        mutable.set((Vec3i)position).move(-halfLengths.getX(), 0, -halfLengths.getZ());
        ((StructureTemplate)template.get()).placeInWorld((ServerLevelAccessor)context.level(), (BlockPos)mutable, (BlockPos)mutable, placementsettings, context.random(), 4);
        placementsettings.clearProcessors();
        Optional postProcessor = processorListRegistry.getOptional(((NbtFeatureConfig)context.config()).postProcessor);
        postProcessor.orElse(emptyProcessor).list().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).addProcessor(arg_0));
        List list = placementsettings.getRandomPalette(((StructureTemplateAccessor)template.get()).getBlocks(), (BlockPos)mutable).blocks();
        StructureTemplate.processBlockInfos((ServerLevelAccessor)context.level(), (BlockPos)mutable, (BlockPos)mutable, (StructurePlaceSettings)placementsettings, (List)list);
        return true;
    }
}

