/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructureTemplateAccessor;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.NbtFeatureConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class HoneycombHole
extends Feature<NbtFeatureConfig> {
    private static final ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty");

    public HoneycombHole(Codec<NbtFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NbtFeatureConfig> context) {
        ResourceLocation nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(((NbtFeatureConfig)context.config()).nbtResourcelocationsAndWeights, context.random());
        StructureTemplateManager structureManager = context.level().getLevel().getStructureManager();
        StructureTemplate template = (StructureTemplate)structureManager.get(nbtRL).orElseThrow(() -> {
            String errorMsg = "Honeycomb cave NBT not found!";
            Bumblezone.LOGGER.error(errorMsg);
            return new RuntimeException(errorMsg);
        });
        BlockPos halfLengths = new BlockPos(template.getSize().getX() / 2, template.getSize().getY() / 2, template.getSize().getZ() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)context.origin());
        BlockPos position = context.origin().above(((NbtFeatureConfig)context.config()).structureYOffset);
        StructurePlaceSettings structurePlacementData = new StructurePlaceSettings().setRotation(Rotation.NONE).setRotationPivot(halfLengths).setIgnoreEntities(false);
        Registry processorListRegistry = context.level().getLevel().getServer().registryAccess().registryOrThrow(Registries.PROCESSOR_LIST);
        StructureProcessorList emptyProcessor = (StructureProcessorList)processorListRegistry.get(EMPTY);
        Optional processor = processorListRegistry.getOptional(((NbtFeatureConfig)context.config()).processor);
        processor.orElse(emptyProcessor).list().forEach(arg_0 -> ((StructurePlaceSettings)structurePlacementData).addProcessor(arg_0));
        mutable.set((Vec3i)position).move(-halfLengths.getX(), 0, -halfLengths.getZ());
        template.placeInWorld((ServerLevelAccessor)context.level(), (BlockPos)mutable, (BlockPos)mutable, structurePlacementData, context.random(), 4);
        structurePlacementData.clearProcessors();
        Optional postProcessor = processorListRegistry.getOptional(((NbtFeatureConfig)context.config()).postProcessor);
        postProcessor.orElse(emptyProcessor).list().forEach(arg_0 -> ((StructurePlaceSettings)structurePlacementData).addProcessor(arg_0));
        List list = structurePlacementData.getRandomPalette(((StructureTemplateAccessor)template).getBlocks(), (BlockPos)mutable).blocks();
        StructureTemplate.processBlockInfos((ServerLevelAccessor)context.level(), (BlockPos)mutable, (BlockPos)mutable, (StructurePlaceSettings)structurePlacementData, (List)list);
        return true;
    }
}

