/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class HangingGardenMob
extends Feature<NoneFeatureConfiguration> {
    public HangingGardenMob(Codec<NoneFeatureConfiguration> code) {
        super(code);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        EntityType entityToSpawn;
        Object object = entityToSpawn = context.random().nextFloat() < 0.3f ? EntityType.BEE : null;
        if (entityToSpawn == null) {
            ArrayList spawnableExtraEntities = new ArrayList();
            Iterable holderIterable = BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(BzTags.HANGING_GARDENS_INITIAL_SPAWN_ENTITIES);
            holderIterable.forEach(h -> spawnableExtraEntities.add((EntityType)h.value()));
            if (!spawnableExtraEntities.isEmpty()) {
                entityToSpawn = (EntityType)spawnableExtraEntities.get(context.random().nextInt(spawnableExtraEntities.size()));
            }
        }
        if (entityToSpawn == null) {
            return false;
        }
        Entity spawningEntity = entityToSpawn.create((Level)context.level().getLevel());
        if (spawningEntity instanceof Mob) {
            Mob mob = (Mob)spawningEntity;
            mob.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(context.origin()), MobSpawnType.STRUCTURE, null);
            mob.setPersistenceRequired();
        }
        spawningEntity.moveTo((double)context.origin().getX() + 0.5, (double)context.origin().getY(), (double)context.origin().getZ() + 0.5, 0.0f, 0.0f);
        context.level().addFreshEntityWithPassengers(spawningEntity);
        return true;
    }
}

