/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.configs.BzWorldgenConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.worldgen.features.NbtFeature;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.NbtFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class BeeDungeon
extends NbtFeature<NbtFeatureConfig> {
    public BeeDungeon(Codec<NbtFeatureConfig> configFactory) {
        super(configFactory);
    }

    @Override
    public boolean place(FeaturePlaceContext<NbtFeatureConfig> context) {
        if (BzWorldgenConfigs.beeDungeonRarity >= 1000 || context.random().nextInt(BzWorldgenConfigs.beeDungeonRarity) != 0) {
            return false;
        }
        if (BeeDungeon.isValidDungeonSpot(context)) {
            super.place(context);
        }
        return true;
    }

    protected static boolean isValidDungeonSpot(FeaturePlaceContext<?> context) {
        Registry configuredStructureFeatureRegistry = (Registry)context.level().registryAccess().registry(Registries.STRUCTURE).get();
        if (context.level() instanceof WorldGenRegion) {
            StructureManager structureManager = context.level().getLevel().structureManager();
            for (Object structure : configuredStructureFeatureRegistry.getTagOrEmpty(BzTags.NO_DUNGEONS)) {
                StructureStart startForFeature = GeneralUtils.getStructureAt((LevelReader)context.level(), structureManager, context.origin(), (Structure)structure.value());
                if (!startForFeature.isValid()) continue;
                return false;
            }
        }
        if (!context.level().getBlockState(context.origin()).canOcclude()) {
            return false;
        }
        boolean validSpot = false;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set((Vec3i)context.origin());
        for (Direction face : Direction.Plane.HORIZONTAL) {
            mutable.set((Vec3i)context.origin()).move(face, 3);
            BlockState state = context.level().getBlockState((BlockPos)mutable);
            if (!state.is(Blocks.CAVE_AIR) && !state.is((Block)BzBlocks.PILE_OF_POLLEN.get())) continue;
            validSpot = true;
            break;
        }
        for (int xOffset = -6; xOffset <= 6; xOffset += 6) {
            for (int zOffset = -6; zOffset <= 6; zOffset += 6) {
                for (int yOffset = -3; yOffset <= 9; yOffset += 3) {
                    mutable.set((Vec3i)context.origin()).move(xOffset, yOffset, zOffset);
                    if (!context.level().getBlockState((BlockPos)mutable).is(Blocks.AIR)) continue;
                    validSpot = false;
                }
            }
        }
        return validSpot;
    }
}

