/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FallingBlockEntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public record UpdateFallingBlockPacket(int fallingBlockId, short layer) implements Packet<UpdateFallingBlockPacket>
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"update_falling_block");
    public static final ClientboundPacketType<UpdateFallingBlockPacket> TYPE = new Handler();

    public static void sendToClient(Entity entity, int fallingBlockId, short layer) {
        MessageHandler.DEFAULT_CHANNEL.sendToAllLoaded((Packet)new UpdateFallingBlockPacket(fallingBlockId, layer), entity.level(), entity.blockPosition());
    }

    public PacketType<UpdateFallingBlockPacket> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<UpdateFallingBlockPacket> {
        private Handler() {
        }

        public void encode(UpdateFallingBlockPacket message, RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(message.fallingBlockId);
            buffer.writeShort((int)message.layer);
        }

        public UpdateFallingBlockPacket decode(RegistryFriendlyByteBuf buffer) {
            return new UpdateFallingBlockPacket(buffer.readVarInt(), buffer.readShort());
        }

        public Runnable handle(UpdateFallingBlockPacket message) {
            return () -> {
                FallingBlockEntity fallingBlockEntity;
                Entity entity = GeneralUtilsClient.getClientLevel().getEntity(message.fallingBlockId);
                if (entity instanceof FallingBlockEntity && (fallingBlockEntity = (FallingBlockEntity)entity).getBlockState().is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
                    ((FallingBlockEntityAccessor)fallingBlockEntity).setBlockState((BlockState)((Block)BzBlocks.PILE_OF_POLLEN.get()).defaultBlockState().setValue((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(message.layer)));
                }
            };
        }

        public Class<UpdateFallingBlockPacket> type() {
            return UpdateFallingBlockPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

