/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public record SyncHorseOwnerUUIDPacketFromServer(int horseId, UUID ownerUUID) implements Packet<SyncHorseOwnerUUIDPacketFromServer>
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"sync_horse_owner_uuid_from_server");
    public static final ClientboundPacketType<SyncHorseOwnerUUIDPacketFromServer> TYPE = new Handler();

    public static void sendToClient(Entity entity, int horseId, UUID ownerUUID) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayersInLevel((Packet)new SyncHorseOwnerUUIDPacketFromServer(horseId, ownerUUID), entity.level());
    }

    public PacketType<SyncHorseOwnerUUIDPacketFromServer> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<SyncHorseOwnerUUIDPacketFromServer> {
        private Handler() {
        }

        public void encode(SyncHorseOwnerUUIDPacketFromServer message, RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(message.horseId());
            buffer.writeUUID(message.ownerUUID());
        }

        public SyncHorseOwnerUUIDPacketFromServer decode(RegistryFriendlyByteBuf buffer) {
            return new SyncHorseOwnerUUIDPacketFromServer(buffer.readVarInt(), buffer.readUUID());
        }

        public Runnable handle(SyncHorseOwnerUUIDPacketFromServer message) {
            return () -> {
                Entity entity = GeneralUtilsClient.getClientLevel().getEntity(message.horseId());
                if (entity instanceof AbstractHorse) {
                    AbstractHorse abstractHorse = (AbstractHorse)entity;
                    abstractHorse.setOwnerUUID(message.ownerUUID());
                }
            };
        }

        public Class<SyncHorseOwnerUUIDPacketFromServer> type() {
            return SyncHorseOwnerUUIDPacketFromServer.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

