/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.DatapackSyncEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;

public record QueenMainTradesSyncPacket(List<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> recipeViewerMainTrades) implements Packet<QueenMainTradesSyncPacket>
{
    public static Gson gson = new GsonBuilder().create();
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"queen_main_trades_sync_packet");
    public static final ClientboundPacketType<QueenMainTradesSyncPacket> TYPE = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer((Packet)new QueenMainTradesSyncPacket(QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades), event.player());
    }

    public PacketType<QueenMainTradesSyncPacket> type() {
        return TYPE;
    }

    public static class Handler
    implements ClientboundPacketType<QueenMainTradesSyncPacket> {
        public QueenMainTradesSyncPacket decode(RegistryFriendlyByteBuf buf) {
            ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> parsedData = new ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>>();
            CompoundTag data = buf.readNbt();
            if (data == null) {
                Bumblezone.LOGGER.error("Queen Main Trade packet is empty??? Wtf???");
                return new QueenMainTradesSyncPacket(parsedData);
            }
            ListTag tagList = data.getList("main_trades", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tradeCompound = tagList.getCompound(i);
                CompoundTag firstHalf = tradeCompound.getCompound("input");
                ListTag secondHalf = tradeCompound.getList("output", 10);
                DataResult dataResult1 = MainTradeRowInput.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)firstHalf);
                dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet tag (first half): {}", e));
                DataResult dataResult2 = WeightedRandomList.codec(WeightedTradeResult.CODEC).parse((DynamicOps)NbtOps.INSTANCE, (Object)secondHalf);
                dataResult2.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet tag (second half): {}", e));
                dataResult1.result().ifPresent(input -> dataResult2.result().ifPresent(output -> parsedData.add(Pair.of((Object)input, (Object)output))));
            }
            return new QueenMainTradesSyncPacket(parsedData);
        }

        public void encode(QueenMainTradesSyncPacket pkt, RegistryFriendlyByteBuf buf) {
            CompoundTag data = new CompoundTag();
            ListTag listTag = new ListTag();
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> tradeRow : pkt.recipeViewerMainTrades()) {
                CompoundTag pairData = new CompoundTag();
                DataResult dataResult1 = MainTradeRowInput.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((MainTradeRowInput)tradeRow.getFirst()));
                dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet tag (first half): {}", e));
                dataResult1.result().ifPresent(r -> pairData.put("input", r));
                DataResult dataResult = WeightedRandomList.codec(WeightedTradeResult.CODEC).encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((WeightedRandomList)tradeRow.getSecond()));
                dataResult.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet tag (second half): {}", e));
                dataResult.result().ifPresent(r -> pairData.put("output", r));
                listTag.add((Object)pairData);
            }
            data.put("main_trades", (Tag)listTag);
            buf.writeNbt((Tag)data);
        }

        public Runnable handle(QueenMainTradesSyncPacket pkt) {
            return () -> {
                QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades = pkt.recipeViewerMainTrades();
            };
        }

        public Class<QueenMainTradesSyncPacket> type() {
            return QueenMainTradesSyncPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

