/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.client.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.menus.CrystallineFlowerMenu;
import com.telepathicgrunt.the_bumblezone.menus.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.locale.Language;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record CrystallineFlowerEnchantmentPacket(int containerId, List<EnchantmentSkeleton> enchantmentSkeletons, ResourceLocation selectedResourceLocation) implements Packet<CrystallineFlowerEnchantmentPacket>
{
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"crystalline_flower_enchantment");
    public static final ClientboundPacketType<CrystallineFlowerEnchantmentPacket> TYPE = new Handler();

    public static void sendToClient(ServerPlayer player, int containerId, List<EnchantmentSkeleton> enchantmentSkeletons, ResourceLocation selectedResourceLocation) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer((Packet)new CrystallineFlowerEnchantmentPacket(containerId, enchantmentSkeletons, selectedResourceLocation), player);
    }

    public PacketType<CrystallineFlowerEnchantmentPacket> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<CrystallineFlowerEnchantmentPacket> {
        private Handler() {
        }

        public void encode(CrystallineFlowerEnchantmentPacket message, RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(message.containerId());
            buffer.writeCollection(message.enchantmentSkeletons(), (buf, enchantmentSkeleton) -> buf.writeUtf(GSON.toJson(enchantmentSkeleton)));
            buffer.writeResourceLocation(message.selectedResourceLocation);
        }

        public CrystallineFlowerEnchantmentPacket decode(RegistryFriendlyByteBuf buffer) {
            return new CrystallineFlowerEnchantmentPacket(buffer.readInt(), buffer.readList(buf -> (EnchantmentSkeleton)GSON.fromJson(buf.readUtf(), EnchantmentSkeleton.class)), buffer.readResourceLocation());
        }

        public Runnable handle(CrystallineFlowerEnchantmentPacket message) {
            return () -> {
                if (GeneralUtilsClient.getClientPlayer() != null && GeneralUtilsClient.getClientPlayer().containerMenu.containerId == message.containerId) {
                    HashMap<ResourceLocation, EnchantmentSkeleton> map = new HashMap<ResourceLocation, EnchantmentSkeleton>();
                    for (EnchantmentSkeleton enchantmentSkeleton : message.enchantmentSkeletons()) {
                        map.put(ResourceLocation.fromNamespaceAndPath((String)enchantmentSkeleton.namespace, (String)enchantmentSkeleton.path), enchantmentSkeleton);
                    }
                    CrystallineFlowerScreen.enchantmentsAvailable = map;
                    Language language = Language.getInstance();
                    CrystallineFlowerScreen.enchantmentsAvailableSortedList = map.keySet().stream().sorted((r1, r2) -> {
                        String s1 = language.getOrDefault("enchantment." + r1.getNamespace() + "." + r1.getPath(), r1.getPath());
                        String s2 = language.getOrDefault("enchantment." + r2.getNamespace() + "." + r2.getPath(), r2.getPath());
                        return s1.compareTo(s2);
                    }).collect(Collectors.toList());
                    AbstractContainerMenu patt0$temp = GeneralUtilsClient.getClientPlayer().containerMenu;
                    if (patt0$temp instanceof CrystallineFlowerMenu) {
                        CrystallineFlowerMenu crystallineFlowerMenu = (CrystallineFlowerMenu)patt0$temp;
                        crystallineFlowerMenu.selectedEnchantment = message.selectedResourceLocation().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty")) ? null : message.selectedResourceLocation();
                    }
                }
            };
        }

        public Class<CrystallineFlowerEnchantmentPacket> type() {
            return CrystallineFlowerEnchantmentPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

