/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modules;

import com.telepathicgrunt.the_bumblezone.advancements.CounterTrigger;
import com.telepathicgrunt.the_bumblezone.advancements.KilledCounterTrigger;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import com.telepathicgrunt.the_bumblezone.events.entity.BabySpawnEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.FinishUseItemEvent;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataModule;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerDataHandler {
    public static void initEvents() {
        BabySpawnEvent.EVENT.addListener(PlayerDataHandler::onBeeBreed);
        BabySpawnEvent.EVENT.addListener(PlayerDataHandler::onHoneySlimeBred);
        EntityDeathEvent.EVENT_LOWEST.addListener(PlayerDataHandler::onEntityKilled);
        FinishUseItemEvent.EVENT.addListener(PlayerDataHandler::onHoneyBottleDrank);
    }

    public static void onBeeBreed(boolean cancelled, BabySpawnEvent event) {
        ServerPlayer player;
        if (cancelled) {
            return;
        }
        if (!(event.child() instanceof Bee)) {
            return;
        }
        Player player2 = event.player();
        if (player2 instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(player = (ServerPlayer)player2)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.beesBred;
                ((CounterTrigger)((Object)((Object)BzCriterias.BEE_BREEDING_TRIGGER.get()))).trigger(player, module.beesBred);
            });
        }
    }

    public static void onFlowerSpawned(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.flowersSpawned;
                ((CounterTrigger)((Object)((Object)BzCriterias.POLLEN_PUFF_SPAWN_FLOWERS_TRIGGER.get()))).trigger(serverPlayer, module.flowersSpawned);
            });
        }
    }

    public static void onEntityKilled(boolean cancelled, EntityDeathEvent event) {
        ServerPlayer player;
        if (cancelled) {
            return;
        }
        if (event.entity() == null) {
            return;
        }
        if (event.source() == null) {
            return;
        }
        Entity entity = event.source().getEntity();
        if (entity instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(player = (ServerPlayer)entity)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ResourceLocation id = EntityType.getKey((EntityType)event.entity().getType());
                if (id != null) {
                    ((KilledCounterTrigger)((Object)((Object)BzCriterias.KILLED_COUNTER_TRIGGER.get()))).trigger(player, (Entity)event.entity(), (PlayerDataModule)module);
                }
            });
        }
    }

    public static void onHoneyBottleDrank(ItemStack result, FinishUseItemEvent event) {
        ServerPlayer player;
        if (!event.item().is(BzTags.HONEY_DRUNK_TRIGGER_ITEMS)) {
            return;
        }
        LivingEntity livingEntity = event.user();
        if (livingEntity instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(player = (ServerPlayer)livingEntity)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.honeyBottleDrank;
                ((CounterTrigger)((Object)((Object)BzCriterias.HONEY_BOTTLE_DRANK_TRIGGER.get()))).trigger(player, module.honeyBottleDrank);
            });
        }
    }

    public static void onBeeStingerFired(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.beeStingersFired;
                ((CounterTrigger)((Object)((Object)BzCriterias.BEE_STINGER_SHOOTER_TRIGGER.get()))).trigger(serverPlayer, module.beeStingersFired);
            });
        }
    }

    public static void onBeesSaved(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.beeSaved;
                ((CounterTrigger)((Object)((Object)BzCriterias.BEE_SAVED_BY_STINGER_TRIGGER.get()))).trigger(serverPlayer, module.beeSaved);
            });
        }
    }

    public static void onPollenHit(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.pollenPuffHits;
                ((CounterTrigger)((Object)((Object)BzCriterias.POLLEN_PUFF_HIT_TRIGGER.get()))).trigger(serverPlayer, module.pollenPuffHits);
            });
        }
    }

    public static void onHoneySlimeBred(boolean cancelled, BabySpawnEvent event) {
        ServerPlayer serverPlayer;
        if (cancelled) {
            return;
        }
        if (!(event.child() instanceof HoneySlimeEntity)) {
            return;
        }
        Player player = event.player();
        if (player instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.honeySlimeBred;
                ((CounterTrigger)((Object)((Object)BzCriterias.HONEY_SLIME_BRED_TRIGGER.get()))).trigger(serverPlayer, module.honeySlimeBred);
            });
        }
    }

    public static void onBeesFed(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                ++module.beesFed;
                ((CounterTrigger)((Object)((Object)BzCriterias.BEE_FED_TRIGGER.get()))).trigger(serverPlayer, module.beesFed);
            });
        }
    }

    public static void onQueenBeeTrade(Player player, int tradedItems) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && PlayerDataHandler.rootAdvancementDone(serverPlayer = (ServerPlayer)player)) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> {
                module.queenBeeTrade += tradedItems;
                ((CounterTrigger)((Object)((Object)BzCriterias.BEE_QUEEN_TRADING_TRIGGER.get()))).trigger(serverPlayer, module.queenBeeTrade);
            });
        }
    }

    public static void onQueenBeeTrade(Player player) {
        PlayerDataHandler.onQueenBeeTrade(player, 1);
    }

    public static boolean rootAdvancementDone(ServerPlayer serverPlayer) {
        AdvancementHolder advancementHolder = serverPlayer.server.getAdvancements().get(BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
        if (advancementHolder == null) {
            return false;
        }
        Map<AdvancementHolder, AdvancementProgress> progress = ((PlayerAdvancementsAccessor)serverPlayer.getAdvancements()).getProgress();
        return progress.containsKey(advancementHolder) && progress.get(advancementHolder).isDone();
    }
}

