/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.modules.base.Module;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class EntityPosAndDimModule
implements Module<EntityPosAndDimModule> {
    public static final Codec<EntityPosAndDimModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("nonBZDimension").orElse((Object)ResourceLocation.tryParse((String)BzDimensionConfigs.defaultDimension)).forGetter(module -> module.nonBZDimension), (App)Vec3.CODEC.optionalFieldOf("nonBZPosition").forGetter(module -> module.nonBZPosition)).apply((Applicative)instance, EntityPosAndDimModule::new));
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"entity_pos_and_dim");
    private ResourceLocation nonBZDimension;
    private Optional<Vec3> nonBZPosition;

    public EntityPosAndDimModule(ResourceLocation nonBZDimension, Optional<Vec3> nonBZPosition) {
        this.nonBZDimension = nonBZDimension;
        this.nonBZPosition = nonBZPosition;
    }

    public EntityPosAndDimModule() {
        this.nonBZDimension = ResourceLocation.tryParse((String)BzDimensionConfigs.defaultDimension);
        this.nonBZPosition = Optional.empty();
    }

    public void setNonBZDim(ResourceLocation incomingDim) {
        if (incomingDim.equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            this.nonBZDimension = ResourceLocation.tryParse((String)BzDimensionConfigs.defaultDimension);
            Bumblezone.LOGGER.error("Error: The non-bz dimension passed in to be stored was bz dimension. Please contact mod creator to let them know of this issue.");
        } else {
            this.nonBZDimension = incomingDim;
        }
    }

    public ResourceLocation getNonBZDim() {
        return this.nonBZDimension;
    }

    public void setNonBZPos(Optional<Vec3> incomingPos) {
        this.nonBZPosition = incomingPos;
    }

    public Optional<Vec3> getNonBZPos() {
        return this.nonBZPosition;
    }

    public boolean hasPos() {
        return this.nonBZPosition != null;
    }

    @Override
    public Codec<EntityPosAndDimModule> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

