/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modinit;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.util.Supplier;

public final class BzBiomeHeightRegistry {
    public static final ResourceKey<Registry<BiomeTerrain>> BIOME_HEIGHT_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"biome_height"));
    public static final TemporaryFakeBiomeRegistry BIOME_HEIGHT = new TemporaryFakeBiomeRegistry();
    public static final Supplier<BiomeTerrain> HIVE_PILLAR = BIOME_HEIGHT.register("hive_pillar", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(22.0f, 0.35f)));
    public static final Supplier<BiomeTerrain> HIVE_WALL = BIOME_HEIGHT.register("hive_wall", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(19.0f, 0.25f)));
    public static final Supplier<BiomeTerrain> POLLINATED_FIELDS = BIOME_HEIGHT.register("pollinated_fields", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(5.4f, 0.9f)));
    public static final Supplier<BiomeTerrain> POLLINATED_PILLAR = BIOME_HEIGHT.register("pollinated_pillar", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(22.5f, 0.05f)));
    public static final Supplier<BiomeTerrain> SUGAR_WATER_FLOOR = BIOME_HEIGHT.register("sugar_water_floor", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(-3.7f, 0.75f)));
    public static final Supplier<BiomeTerrain> CRYSTAL_CANYON = BIOME_HEIGHT.register("crystal_canyon", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(0.0f, 0.75f)));
    public static final Supplier<BiomeTerrain> FLORAL_MEADOW = BIOME_HEIGHT.register("floral_meadow", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(0.2f, 0.75f)));
    public static final Supplier<BiomeTerrain> HOWLING_CONSTRUCTS = BIOME_HEIGHT.register("howling_constructs", (Supplier<BiomeTerrain>)((Supplier)() -> new BiomeTerrain(0.18f, 0.78f)));

    private BzBiomeHeightRegistry() {
    }

    public static class BiomeTerrain {
        public final float depth;
        public final float weightModifier;

        public BiomeTerrain(float depth, float weightModifier) {
            this.depth = depth;
            this.weightModifier = weightModifier;
        }
    }

    public static class TemporaryFakeBiomeRegistry {
        private Map<ResourceLocation, BiomeTerrain> map = new HashMap<ResourceLocation, BiomeTerrain>();

        public Supplier<BiomeTerrain> register(String id, Supplier<BiomeTerrain> supplier) {
            this.map.put(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)id), (BiomeTerrain)supplier.get());
            return supplier;
        }

        public BiomeTerrain get(ResourceLocation location) {
            return this.map.get(location);
        }
    }
}

