/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.telepathicgrunt.the_bumblezone.blocks.HeavyAir;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class BloodMagicCompat
implements ModCompat {
    public static Item AIR_SIGIL;

    public BloodMagicCompat() {
        AIR_SIGIL = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"bloodmagic", (String)"airsigil"));
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(BloodMagicCompat::onAirSigilItemUse);
        ModChecker.bloodMagicPresent = true;
    }

    public static void onAirSigilItemUse(PlayerInteractEvent.RightClickItem event) {
        Player entity;
        if (AIR_SIGIL != null && event.getItemStack().is(AIR_SIGIL) && (entity = event.getEntity()) != null && HeavyAir.isInHeavyAir(entity.level(), entity.getBoundingBox())) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.denied_magic").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED), true);
                serverPlayer.swing(event.getHand());
            }
            event.getEntity().swing(event.getHand());
            event.setCanceled(true);
        }
    }
}

