/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.AddBuiltinDataPacks;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ResourcefulBeesCompat
implements ModCompat {
    public static final TagKey<Block> SPAWNS_IN_BEE_DUNGEONS_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"resourcefulbees/spawns_in_bee_dungeons"));
    public static final TagKey<Block> SPAWNS_IN_SPIDER_INFESTED_BEE_DUNGEONS_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"resourcefulbees/spawns_in_spider_infested_bee_dungeons"));
    public static final TagKey<EntityType<?>> SPAWNABLE_FROM_BROOD_BLOCK_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"resourcefulbees/spawnable_from_brood_block"));
    public static final TagKey<EntityType<?>> SPAWNABLE_FROM_CHUNK_CREATION_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"resourcefulbees/spawnable_from_chunk_creation"));
    private static Optional<Item> BEE_JAR;

    public ResourcefulBeesCompat() {
        BEE_JAR = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"resourcefulbees", (String)"bee_jar"));
        if (BEE_JAR.isPresent() && BzModCompatibilityConfigs.allowResourcefulBeesBeeJarRevivingEmptyBroodBlock) {
            ResourcefulBeesCompat.setupDispenserCompat(BEE_JAR.get());
        }
        Bumblezone.MOD_COMPAT_DATAPACKS.add(addBuiltinDataPacks -> addBuiltinDataPacks.add(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"resourcefulbees_compat"), (Component)Component.literal((String)"Bumblezone - Resourceful Bees Compat"), AddBuiltinDataPacks.PackMode.FORCE_ENABLED));
        ModChecker.resourcefulBeesPresent = true;
    }

    private static void setupDispenserCompat(Item containerItem) {
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS, ModCompat.Type.COMBS, ModCompat.Type.EMPTY_BROOD);
    }

    @Override
    public boolean onBeeSpawn(EntitySpawnEvent event, boolean isBaby) {
        double spawnRate;
        if (!BzModCompatibilityConfigs.spawnResourcefulBeesBeesMob || event.spawnType() == MobSpawnType.DISPENSER && !BzModCompatibilityConfigs.allowResourcefulBeesSpawnFromDispenserFedBroodBlock) {
            return false;
        }
        double d = spawnRate = event.spawnType() == MobSpawnType.SPAWNER ? BzModCompatibilityConfigs.spawnrateOfResourcefulBeesMobsBrood : BzModCompatibilityConfigs.spawnrateOfResourcefulBeesMobsOther;
        if ((double)event.entity().getRandom().nextFloat() >= spawnRate) {
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        Registry entityTypes = world.registryAccess().registryOrThrow(Registries.ENTITY_TYPE);
        Optional optionalNamed = entityTypes.getTag(event.spawnType() == MobSpawnType.CHUNK_GENERATION ? SPAWNABLE_FROM_CHUNK_CREATION_TAG : SPAWNABLE_FROM_BROOD_BLOCK_TAG);
        if (optionalNamed.isEmpty()) {
            return false;
        }
        HolderSet.Named holders = (HolderSet.Named)optionalNamed.get();
        if (holders.size() == 0) {
            return false;
        }
        EntityType rbBeeType = (EntityType)holders.get(entity.getRandom().nextInt(holders.size())).value();
        Entity rbBeeUnchecked = rbBeeType.create(entity.level());
        if (rbBeeUnchecked instanceof Bee) {
            Bee rbBee = (Bee)rbBeeUnchecked;
            rbBee.moveTo(entity.getX(), entity.getY(), entity.getZ(), rbBee.getRandom().nextFloat() * 360.0f, 0.0f);
            rbBee.setBaby(isBaby);
            rbBee.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(rbBee.blockPosition()), event.spawnType(), null);
            world.addFreshEntity((Entity)rbBee);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkCombSpawn(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return (double)random.nextFloat() < BzModCompatibilityConfigs.RBOreHoneycombSpawnRateSpiderBeeDungeon;
        }
        return (double)random.nextFloat() < BzModCompatibilityConfigs.RBOreHoneycombSpawnRateBeeDungeon;
    }

    @Override
    public StructureTemplate.StructureBlockInfo getHoneycomb(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return ResourcefulBeesCompat.getRandomCombFromTag(pos, random, level, SPAWNS_IN_SPIDER_INFESTED_BEE_DUNGEONS_TAG);
        }
        return ResourcefulBeesCompat.getRandomCombFromTag(pos, random, level, SPAWNS_IN_BEE_DUNGEONS_TAG);
    }

    private static StructureTemplate.StructureBlockInfo getRandomCombFromTag(BlockPos worldPos, RandomSource random, LevelReader worldView, TagKey<Block> spawnsInBeeDungeonsTag) {
        if (worldView instanceof CommonLevelAccessor) {
            CommonLevelAccessor world = (CommonLevelAccessor)worldView;
            Registry blockRegistry = world.registryAccess().registryOrThrow(Registries.BLOCK);
            Optional optionalNamed = blockRegistry.getTag(spawnsInBeeDungeonsTag);
            if (optionalNamed.isEmpty()) {
                return null;
            }
            List holders = GeneralUtils.convertHoldersetToList(optionalNamed);
            if (holders.isEmpty()) {
                return null;
            }
            Block rbComb = (Block)holders.get(random.nextInt(random.nextInt(holders.size()) + 1));
            return new StructureTemplate.StructureBlockInfo(worldPos, rbComb.defaultBlockState(), null);
        }
        return null;
    }
}

