/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCompassBaseData;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCompassStateData;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCompassTargetData;
import com.telepathicgrunt.the_bumblezone.items.HoneyCompass;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzLootFunctionTypes;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class HoneyCompassLocateStructure
extends LootItemConditionalFunction {
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    final TagKey<Structure> destination;
    final int searchRadius;
    final boolean skipKnownStructures;
    public static final MapCodec<HoneyCompassLocateStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> HoneyCompassLocateStructure.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)TagKey.codec((ResourceKey)Registries.STRUCTURE).fieldOf("destination").forGetter(honeyCompassLocateStructure -> honeyCompassLocateStructure.destination), (App)Codec.intRange((int)0, (int)1000000).orElse((Object)50).fieldOf("search_radius").forGetter(honeyCompassLocateStructure -> honeyCompassLocateStructure.searchRadius), (App)Codec.BOOL.orElse((Object)true).fieldOf("skip_existing_chunks").forGetter(honeyCompassLocateStructure -> honeyCompassLocateStructure.skipKnownStructures))).apply((Applicative)instance, HoneyCompassLocateStructure::new));

    public HoneyCompassLocateStructure(List<LootItemCondition> lootItemConditions, TagKey<Structure> destination, int searchRadius, boolean skipKnownStructrues) {
        super(lootItemConditions);
        this.destination = destination;
        this.searchRadius = searchRadius;
        this.skipKnownStructures = skipKnownStructrues;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)BzLootFunctionTypes.HONEY_COMPASS_LOCATE_STRUCTURE.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ORIGIN);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        Vec3 vec3;
        if (itemStack.is((Item)BzItems.HONEY_COMPASS.get()) && (vec3 = (Vec3)lootContext.getParamOrNull(LootContextParams.ORIGIN)) != null) {
            UUID searchId = UUID.randomUUID();
            BlockPos blockPos = BlockPos.containing((Position)vec3);
            HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get(), (Object)new HoneyCompassStateData(honeyCompassStateData.locked(), Optional.of(searchId), true, honeyCompassStateData.isFailed(), honeyCompassStateData.locatedSpecialStructure()));
            HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get(), (Object)new HoneyCompassTargetData(honeyCompassTargetData.targetBlock(), Optional.of(this.destination.location().toString()), honeyCompassTargetData.targetPos(), honeyCompassTargetData.targetDimension()));
            ResourceKey structure = null;
            Registry structureRegistry = (Registry)lootContext.getLevel().registryAccess().registry(Registries.STRUCTURE).get();
            List structuresList = structureRegistry.getTag(this.destination).map(holders -> holders.stream().map(Holder::value).toList()).orElseGet(ArrayList::new);
            if (!structuresList.isEmpty()) {
                structure = (ResourceKey)structureRegistry.getResourceKey((Object)((Structure)structuresList.get(lootContext.getRandom().nextInt(structuresList.size())))).get();
            }
            WeakReference<ItemStack> weakRefItemStack = new WeakReference<ItemStack>(itemStack);
            if (structure != null) {
                ThreadExecutor.locate(lootContext.getLevel(), searchId, (ResourceKey<Structure>)structure, blockPos, 100, false).thenOnServerThread(foundPos -> this.setCompassFoundLocationData(weakRefItemStack, lootContext, (BlockPos)foundPos));
            }
        }
        return itemStack;
    }

    private void setCompassFoundLocationData(WeakReference<ItemStack> itemStackWeakReference, LootContext lootContext, BlockPos blockPos) {
        ItemStack itemStack = (ItemStack)itemStackWeakReference.get();
        if (itemStack != null && blockPos != null) {
            HoneyCompassStateData oldHoneyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
            HoneyCompassBaseData oldHoneyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
            HoneyCompassTargetData oldHoneyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
            HoneyCompass.setCompassStateData(oldHoneyCompassStateData, oldHoneyCompassStateData.locked(), Optional.empty(), false, false, oldHoneyCompassStateData.locatedSpecialStructure(), itemStack);
            HoneyCompass.setCompassBaseData(oldHoneyCompassBaseData, "structure", itemStack);
            HoneyCompass.setCompassTargetData(oldHoneyCompassTargetData, Optional.empty(), Optional.empty(), Optional.of(blockPos), Optional.of(lootContext.getLevel().dimension()), itemStack);
        }
    }
}

