/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class RadianceEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.radianceEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.radianceEssenceAbilityUse;

    public RadianceEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 15384615;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_radiance_description_1").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_radiance_description_2").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void applyAbilityEffects(ItemStack itemStack, Level level, ServerPlayer serverPlayer) {
        AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        if (abilityEssenceActivityData.isActive() && level.getBrightness(LightLayer.SKY, serverPlayer.blockPosition()) >= 13 && level.isDay()) {
            if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % (serverPlayer.isSprinting() ? 2L : 12L) == 0L) {
                RadianceEssence.spawnParticles(serverPlayer.serverLevel(), serverPlayer.position(), serverPlayer.getRandom());
            }
            if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 25L == 0L) {
                List<Holder> radianceEffects = BuiltInRegistries.MOB_EFFECT.getTag(BzTags.RADIANCE_SUN_EFFECTS).stream().flatMap(HolderSet.ListBacked::stream).filter(Holder::isBound).toList();
                for (Holder effectHolder : radianceEffects) {
                    if (effectHolder.value() == MobEffects.MOVEMENT_SPEED) {
                        serverPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, 0, false, false));
                        if (!this.decrementAbilityUseRemaining(itemStack, serverPlayer, serverPlayer.isSprinting() ? 3 : 1)) continue;
                        return;
                    }
                    if (effectHolder.value() == MobEffects.DAMAGE_RESISTANCE) {
                        serverPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 120, 1, false, false));
                        if (!this.decrementAbilityUseRemaining(itemStack, serverPlayer, 1)) continue;
                        return;
                    }
                    if (effectHolder.value() == MobEffects.REGENERATION) {
                        serverPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 120, 0, false, false));
                        if (!this.decrementAbilityUseRemaining(itemStack, serverPlayer, serverPlayer.getHealth() < serverPlayer.getMaxHealth() ? 5 : 1)) continue;
                        return;
                    }
                    if (effectHolder.value() == MobEffects.DIG_SPEED) {
                        serverPlayer.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 120, 1, false, false));
                        if (!this.decrementAbilityUseRemaining(itemStack, serverPlayer, 1)) continue;
                        return;
                    }
                    if (effectHolder.value() == MobEffects.SATURATION) {
                        serverPlayer.addEffect(new MobEffectInstance(MobEffects.SATURATION, 120, 0, false, false));
                        if (!this.decrementAbilityUseRemaining(itemStack, serverPlayer, serverPlayer.getFoodData().needsFood() ? 3 : 1)) continue;
                        return;
                    }
                    serverPlayer.addEffect(new MobEffectInstance(effectHolder, 120, 0, false, false));
                    if (!this.decrementAbilityUseRemaining(itemStack, serverPlayer, 1)) continue;
                    return;
                }
                for (ItemStack armorItem : serverPlayer.getArmorSlots()) {
                    if (!armorItem.isDamageableItem() || !armorItem.isDamaged() || armorItem.is(BzTags.RADIANCE_CANNOT_REPAIR)) continue;
                    armorItem.setDamageValue(armorItem.getDamageValue() - 1);
                    if (!this.decrementAbilityUseRemaining(itemStack, serverPlayer, 10)) continue;
                    return;
                }
            }
        }
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.sendParticles((ParticleOptions)ParticleTypes.CHERRY_LEAVES, location.x(), location.y() + 1.0, location.z(), 1, random.nextGaussian() * 0.15, random.nextGaussian() * 0.2 + 0.1, random.nextGaussian() * 0.15, 0.0);
    }

    public static boolean IsRadianceEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.getOffhandItem();
            return offHandItem.is((Item)BzItems.ESSENCE_RADIANCE.get()) && ((AbilityEssenceActivityData)offHandItem.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive();
        }
        return false;
    }
}

