/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.datacomponents.StinglessBeeHelmetData;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeeQueenEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.mixin.effects.MobEffectInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.StinglessBeeHelmetSightPacket;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class StinglessBeeHelmet
extends BeeArmor {
    public static final Set<Entity> BEE_HIGHLIGHTED_COUNTER_CLIENTSIDE = new ObjectArraySet();
    public static int HELMET_EFFECT_COUNTER_CLIENTSIDE = 0;
    public static int BEE_WEARABLES_COUNT = 0;
    public static int PACKET_SEND_COOLDOWN_CLIENTSIDE = 20;

    public StinglessBeeHelmet(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties, int variant) {
        super(material, armorType, properties.component((DataComponentType)BzDataComponents.STINGLESS_BEE_HELMET_DATA.get(), (Object)new StinglessBeeHelmetData()), variant, false);
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.STINGLESS_BEE_HELMET_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.STINGLESS_BEE_HELMET_DATA.get(), (Object)new StinglessBeeHelmetData());
        }
    }

    @Override
    public void bz$onArmorTick(ItemStack itemStack, Level level, Player player) {
        MobEffectInstance poison;
        int i;
        StinglessBeeHelmetData beeHelmetData = (StinglessBeeHelmetData)itemStack.get((DataComponentType)BzDataComponents.STINGLESS_BEE_HELMET_DATA.get());
        boolean hasBeeRider = beeHelmetData.hasBeeRider();
        long beeRiderStartTime = beeHelmetData.beeRiderStartTime();
        if (player.getCooldowns().isOnCooldown(itemStack.getItem())) {
            if (hasBeeRider) {
                this.ejectAllBeeRiders(player);
                if (!level.isClientSide() && beeHelmetData.isDifferent(hasBeeRider = false, beeRiderStartTime = -1L)) {
                    itemStack.set((DataComponentType)BzDataComponents.STINGLESS_BEE_HELMET_DATA.get(), (Object)new StinglessBeeHelmetData(hasBeeRider, beeRiderStartTime));
                }
            }
            return;
        }
        int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)player);
        MobEffectInstance nausea = player.getEffect(MobEffects.CONFUSION);
        if (nausea != null) {
            int decreaseSpeed = (int)((double)beeWearablesCount * 3.0 - 2.0);
            for (i = 0; i < decreaseSpeed; ++i) {
                ((MobEffectInstanceAccessor)nausea).callTickDownDuration();
                if (level.isClientSide() || !(player.getRandom().nextFloat() < 0.001f) || itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1) continue;
                itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
            }
        }
        if ((poison = player.getEffect(MobEffects.POISON)) != null && (beeWearablesCount >= 4 || level.getGameTime() % (long)(beeWearablesCount == 3 ? 2 : 3) == 0L)) {
            for (i = 0; i <= Math.max(beeWearablesCount - 3, 1); ++i) {
                if (poison.getDuration() <= 0) continue;
                ((MobEffectInstanceAccessor)poison).callTickDownDuration();
            }
            if (!level.isClientSide() && player.getRandom().nextFloat() < 0.004f && itemStack.getMaxDamage() - itemStack.getDamageValue() > 1) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
            }
        }
        if (level.isClientSide()) {
            if (--PACKET_SEND_COOLDOWN_CLIENTSIDE == 0) {
                PACKET_SEND_COOLDOWN_CLIENTSIDE = 20;
                if (BEE_HIGHLIGHTED_COUNTER_CLIENTSIDE.size() >= 50) {
                    StinglessBeeHelmetSightPacket.sendToServer(true);
                }
            }
            BEE_HIGHLIGHTED_COUNTER_CLIENTSIDE.clear();
            BEE_WEARABLES_COUNT = beeWearablesCount;
            if (player.isShiftKeyDown() && player.onGround()) {
                HELMET_EFFECT_COUNTER_CLIENTSIDE = (beeWearablesCount - 1) * 65 + 6;
            }
        }
        boolean hasWrath = player.hasEffect(BzEffects.WRATH_OF_THE_HIVE.holder());
        if (hasBeeRider || hasWrath) {
            if (hasWrath || player.isUnderWater() || player.isShiftKeyDown() || beeWearablesCount < 4 && (long)beeWearablesCount * 600L + beeRiderStartTime < level.getGameTime()) {
                this.ejectAllBeeRiders(player);
                if (!level.isClientSide()) {
                    hasBeeRider = false;
                    beeRiderStartTime = -1L;
                }
            } else if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.awardStat((ResourceLocation)BzStats.STINGLESS_BEE_HELMET_BEE_RIDER_RL.get());
            }
        }
        if (beeHelmetData.isDifferent(hasBeeRider, beeRiderStartTime)) {
            itemStack.set((DataComponentType)BzDataComponents.STINGLESS_BEE_HELMET_DATA.get(), (Object)new StinglessBeeHelmetData(hasBeeRider, beeRiderStartTime));
        }
    }

    private void ejectAllBeeRiders(Player player) {
        for (Entity passenger : player.getPassengers()) {
            if ((!(passenger instanceof Bee) || passenger.getType().is(BzTags.STINGLESS_BEE_HELMET_DISALLOWED_PASSENGERS)) && !passenger.getType().is(BzTags.STINGLESS_BEE_HELMET_FORCED_ALLOWED_PASSENGERS)) continue;
            passenger.stopRiding();
            if (!(passenger instanceof Mob)) continue;
            Mob mob = (Mob)passenger;
            mob.setNoAi(false);
        }
    }

    public static boolean shouldEntityGlow(Player player, Entity entity) {
        if (entity instanceof Bee || entity instanceof BeehemothEntity || entity instanceof BeeQueenEntity) {
            if (player.getCooldowns().isOnCooldown((Item)BzItems.STINGLESS_BEE_HELMET_1.get()) || player.getCooldowns().isOnCooldown((Item)BzItems.STINGLESS_BEE_HELMET_2.get())) {
                return false;
            }
            return entity.blockPosition().closerThan((Vec3i)player.blockPosition(), (double)BEE_WEARABLES_COUNT * 16.5 + 14.0);
        }
        return false;
    }

    public static InteractionResult addBeePassenger(Level level, Player playerEntity, InteractionHand hand, Entity entity) {
        ItemStack itemStack = StinglessBeeHelmet.getEntityBeeHelmet((LivingEntity)playerEntity);
        if (!itemStack.isEmpty() && !playerEntity.isShiftKeyDown() && playerEntity.getItemInHand(playerEntity.getUsedItemHand()).isEmpty() && playerEntity.getPassengers().isEmpty() && !playerEntity.getCooldowns().isOnCooldown(itemStack.getItem()) && (entity instanceof Bee && !entity.getType().is(BzTags.STINGLESS_BEE_HELMET_DISALLOWED_PASSENGERS) || entity.getType().is(BzTags.STINGLESS_BEE_HELMET_FORCED_ALLOWED_PASSENGERS))) {
            entity.startRiding((Entity)playerEntity);
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                serverPlayer.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)serverPlayer));
            }
            if (!level.isClientSide()) {
                itemStack.set((DataComponentType)BzDataComponents.STINGLESS_BEE_HELMET_DATA.get(), (Object)new StinglessBeeHelmetData(true, level.getGameTime()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Vec3 beeRidingOffset(Vec3 offset, Entity vehicle, Entity rider) {
        if (vehicle instanceof Player && rider instanceof Bee) {
            return offset.add(0.0, 0.0, 0.0);
        }
        return offset;
    }

    public static void decrementHighlightingCounter(Player player) {
        if (player != null && HELMET_EFFECT_COUNTER_CLIENTSIDE > 0) {
            --HELMET_EFFECT_COUNTER_CLIENTSIDE;
            if (StinglessBeeHelmet.getEntityBeeHelmet((LivingEntity)player).isEmpty()) {
                HELMET_EFFECT_COUNTER_CLIENTSIDE = 0;
            }
        }
    }

    public static ItemStack getEntityBeeHelmet(LivingEntity entity) {
        for (ItemStack armor : entity.getArmorSlots()) {
            if (!(armor.getItem() instanceof StinglessBeeHelmet)) continue;
            return armor;
        }
        return ItemStack.EMPTY;
    }
}

