/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.enchantments.NeurotoxinsEnchantmentApplication;
import com.telepathicgrunt.the_bumblezone.enchantments.PotentPoisonEnchantmentApplication;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ThrownStingerSpearEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StingerSpearItem
extends TridentItem
implements ItemExtension {
    public static final float BASE_DAMAGE = 1.0f;
    public static final float BASE_THROWN_DAMAGE = 1.5f;

    public StingerSpearItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 50000;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(BzTags.STINGER_SPEAR_REPAIR_ITEMS);
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int currentDuration) {
        Player player;
        int remainingDuration;
        if (livingEntity instanceof Player && (remainingDuration = this.getUseDuration(itemStack, (LivingEntity)(player = (Player)livingEntity)) - currentDuration) >= 10) {
            if (!level.isClientSide) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, livingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                ThrownStingerSpearEntity thrownStingerSpear = new ThrownStingerSpearEntity(level, (LivingEntity)player, itemStack, itemStack);
                thrownStingerSpear.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 1.0f);
                if (player.getAbilities().instabuild) {
                    thrownStingerSpear.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.addFreshEntity((Entity)thrownStingerSpear);
                level.playSound(null, (Entity)thrownStingerSpear, (SoundEvent)BzSounds.STINGER_SPEAR_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    player.getInventory().removeItem(itemStack);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public boolean hurtEnemy(ItemStack itemStack, LivingEntity victim, LivingEntity user) {
        ServerPlayer serverPlayer;
        int durabilityDecrease = 1;
        if (!victim.getType().is(EntityTypeTags.UNDEAD)) {
            int neuroToxinLevel;
            PotentPoisonEnchantmentApplication.doPostAttackBoostedPoison(itemStack, (Entity)victim);
            if (user instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)user;
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_POISONING_TRIGGER.get())).trigger(serverPlayer);
            }
            if (!victim.getType().is(BzTags.PARALYZED_IMMUNE) && (neuroToxinLevel = NeurotoxinsEnchantmentApplication.getNeurotoxinEnchantLevel(itemStack, victim.level())) > 0) {
                durabilityDecrease = 4;
            }
        }
        itemStack.hurtAndBreak(durabilityDecrease, user, EquipmentSlot.MAINHAND);
        if (user instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)user;
            if (victim.getType() == EntityType.WITHER && victim.isDeadOrDying() && PlayerDataHandler.rootAdvancementDone(serverPlayer)) {
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_KILLED_WITH_WITHER_TRIGGER.get())).trigger(serverPlayer);
            }
        }
        return true;
    }
}

