/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCrystalShieldCurrentLevelData;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCrystalShieldDefinedLevelsData;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.items.BzShieldItem;
import com.telepathicgrunt.the_bumblezone.mixin.items.PlayerDamageShieldInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.TriState;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class HoneyCrystalShield
extends BzShieldItem
implements ItemExtension {
    public HoneyCrystalShield(Item.Properties properties, int initialDurability) {
        super(properties.component((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_CURRENT_LEVEL_DATA.get(), (Object)new HoneyCrystalShieldCurrentLevelData()).component((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_DEFINED_LEVELS_DATA.get(), (Object)new HoneyCrystalShieldDefinedLevelsData(initialDurability)).durability(initialDurability));
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_CURRENT_LEVEL_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_CURRENT_LEVEL_DATA.get(), (Object)new HoneyCrystalShieldCurrentLevelData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_DEFINED_LEVELS_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_DEFINED_LEVELS_DATA.get(), (Object)new HoneyCrystalShieldDefinedLevelsData(itemStack.getMaxDamage()));
        }
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(BzTags.HONEY_CRYSTAL_SHIELD_REPAIR_ITEMS);
    }

    @Override
    public EquipmentSlot bz$getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.OFFHAND;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.bz$getEquipmentSlot(stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (itemStack.is((Item)BzItems.HONEY_CRYSTAL_SHIELD.get())) {
            int shieldLevel = ((HoneyCrystalShieldCurrentLevelData)itemStack.get((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_CURRENT_LEVEL_DATA.get())).currentLevel();
            int maxLevel = ((HoneyCrystalShieldDefinedLevelsData)itemStack.get((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_DEFINED_LEVELS_DATA.get())).maxLevel();
            shieldLevel = Math.max(Math.min(shieldLevel, maxLevel), 1);
            tooltip.add((Component)Component.translatable((String)"item.the_bumblezone.honey_crystal_shield.level_tooltip").append(": " + shieldLevel));
        }
    }

    @Override
    public void bz$setDamage(ItemStack itemStack, int damage) {
        int newDamage = damage;
        int oldDamage = itemStack.getDamageValue();
        int damageCaused = oldDamage - damage;
        int shieldLevel = ((HoneyCrystalShieldCurrentLevelData)itemStack.get((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_CURRENT_LEVEL_DATA.get())).currentLevel();
        HoneyCrystalShieldDefinedLevelsData honeyCrystalShieldDefinedLevelsData = (HoneyCrystalShieldDefinedLevelsData)itemStack.get((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_DEFINED_LEVELS_DATA.get());
        if (damageCaused < 0) {
            int reducedDamage = -1 * Math.min(-1, damageCaused + shieldLevel / 4);
            newDamage = Math.max(0, itemStack.getDamageValue() + reducedDamage);
        } else if (damageCaused > itemStack.getMaxDamage() / 5) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_CRYSTAL_SHIELD_CURRENT_LEVEL_DATA.get(), (Object)new HoneyCrystalShieldCurrentLevelData(Math.min(honeyCrystalShieldDefinedLevelsData.maxLevel(), shieldLevel + 1)));
            itemStack.set(DataComponents.MAX_DAMAGE, (Object)(itemStack.getMaxDamage() + honeyCrystalShieldDefinedLevelsData.getDurabilityForLevel(shieldLevel)));
        }
        itemStack.set(DataComponents.DAMAGE, (Object)Mth.clamp((int)newDamage, (int)0, (int)itemStack.getMaxDamage()));
    }

    public void setDamage(ItemStack stack, int damage) {
        this.bz$setDamage(stack, damage);
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean bz$canPerformAction(ItemStack stack, String toolAction) {
        return toolAction.equals("shield_block") && stack.is((Item)this);
    }

    public static boolean handledPlayerHurtBehavior(EntityAttackedEvent event) {
        LivingEntity livingEntity = event.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HoneyCrystalShield.slowPhysicalAttackers(event.source(), player);
            return HoneyCrystalShield.damageShieldFromExplosionAndFire(event.source(), player);
        }
        return false;
    }

    public static boolean damageShieldFromExplosionAndFire(DamageSource source, Player player) {
        DamageSources damageSources = player.level().damageSources();
        if (player.getUseItem().getItem() instanceof HoneyCrystalShield && player.isBlocking() && (source.is(DamageTypeTags.IS_EXPLOSION) || source.is(DamageTypeTags.IS_FIRE))) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((GenericTrigger)((Object)BzCriterias.HONEY_CRYSTAL_SHIELD_BLOCK_INEFFECTIVELY_TRIGGER.get())).trigger(serverPlayer);
            }
            if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                player.indicateDamage(0.0, 0.0);
                ((PlayerDamageShieldInvoker)player).callHurtCurrentlyUsedShield(Math.max(player.getUseItem().getMaxDamage() / 3, 18));
            } else if (source.is(DamageTypeTags.IS_FIRE) && !player.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                if (source.is(DamageTypeTags.IS_PROJECTILE)) {
                    ((PlayerDamageShieldInvoker)player).callHurtCurrentlyUsedShield(Math.max(player.getUseItem().getMaxDamage() / 6, 3));
                } else {
                    ((PlayerDamageShieldInvoker)player).callHurtCurrentlyUsedShield(Math.max(player.getUseItem().getMaxDamage() / 100, 3));
                    return false;
                }
            }
            if (player instanceof ServerPlayer) {
                player.awardStat(Stats.ITEM_USED.get((Object)player.getUseItem().getItem()));
            }
            return true;
        }
        return false;
    }

    public static void slowPhysicalAttackers(DamageSource source, Player player) {
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if ((!source.is(DamageTypeTags.IS_EXPLOSION) || !source.is(DamageTypeTags.BYPASSES_SHIELD)) && player.getUseItem().getItem() instanceof HoneyCrystalShield && player.isBlocking()) {
                attacker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 165, 1, true, true, false));
            }
        }
    }

    @Override
    public TriState bz$canEnchant(ItemStack itemstack, Holder<Enchantment> enchantment) {
        return enchantment.is(BzTags.ENCHANTABLES_HONEY_CRYSTAL_SHIELD_FORCED_DISALLOWED) ? TriState.DENY : TriState.PASS;
    }
}

