/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCompassBaseData;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCompassStateData;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCompassTargetData;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;

public class HoneyCompass
extends Item {
    public HoneyCompass(Item.Properties properties) {
        super(properties.component((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get(), (Object)new HoneyCompassBaseData()).component((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get(), (Object)new HoneyCompassStateData()).component((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get(), (Object)new HoneyCompassTargetData()));
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get(), (Object)new HoneyCompassBaseData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get(), (Object)new HoneyCompassStateData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get(), (Object)new HoneyCompassTargetData());
        }
    }

    public boolean isFoil(ItemStack itemStack) {
        HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
        return honeyCompassStateData.locked() || super.isFoil(itemStack);
    }

    public String getDescriptionId(ItemStack itemStack) {
        HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
        if (honeyCompassStateData.isLoading()) {
            return "item.the_bumblezone.honey_compass_structure_loading";
        }
        if (honeyCompassStateData.isFailed()) {
            return "item.the_bumblezone.honey_compass_structure_failed";
        }
        HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
        if (honeyCompassBaseData.customName().isPresent()) {
            return honeyCompassBaseData.customName().get();
        }
        if (honeyCompassBaseData.isStructureCompass()) {
            return "item.the_bumblezone.honey_compass_structure";
        }
        if (honeyCompassBaseData.isBlockCompass()) {
            return "item.the_bumblezone.honey_compass_block";
        }
        return super.getDescriptionId(itemStack);
    }

    public Component getName(ItemStack itemStack) {
        HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
        if (honeyCompassBaseData.isBlockCompass()) {
            HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
            Optional<Block> block = honeyCompassTargetData.getStoredBlock();
            if (block.isPresent() && block.get() != Blocks.AIR) {
                return Component.translatable((String)this.getDescriptionId(itemStack), (Object[])new Object[]{block.get().getName()});
            }
            return Component.translatable((String)this.getDescriptionId(itemStack), (Object[])new Object[]{Component.translatable((String)"item.the_bumblezone.honey_compass_unknown_block")});
        }
        return Component.translatable((String)this.getDescriptionId(itemStack));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag tooltipFlag) {
        HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
        if (honeyCompassStateData.isFailed()) {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_failed_description"));
            return;
        }
        HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
        if (honeyCompassBaseData.customDescription().isPresent()) {
            components.add((Component)Component.translatable((String)honeyCompassBaseData.customDescription().get()));
            HoneyCompass.appendAdvancedTooltipInfo(itemStack, tooltipContext, components, tooltipFlag);
            return;
        }
        if (honeyCompassBaseData.isBlockCompass()) {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_block_description1"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_block_description2"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_block_description3"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_block_description4"));
        } else if (honeyCompassBaseData.isStructureCompass()) {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_description1"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_description2"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_description3"));
        } else {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_description1"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_description2"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_description3"));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_description4"));
        }
        HoneyCompass.appendAdvancedTooltipInfo(itemStack, tooltipContext, components, tooltipFlag);
    }

    private static void appendAdvancedTooltipInfo(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag tooltipFlag) {
        if (tooltipContext != null && PlatformHooks.isClientEnvironment()) {
            Player player = GeneralUtilsClient.getClientPlayer();
            HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
            if (player != null && tooltipFlag.isAdvanced() && (honeyCompassBaseData.isBlockCompass() || honeyCompassBaseData.isStructureCompass())) {
                HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
                Optional<BlockPos> targetPos = honeyCompassTargetData.targetPos();
                Optional<ResourceKey<Level>> storedDimension = honeyCompassTargetData.targetDimension();
                if (targetPos.isPresent() && storedDimension.isPresent() && player.level().dimension().equals(storedDimension.get())) {
                    int distance;
                    if (honeyCompassBaseData.isStructureCompass()) {
                        float xDist = Math.abs(player.blockPosition().getX() - targetPos.get().getX());
                        float zDist = Math.abs(player.blockPosition().getZ() - targetPos.get().getZ());
                        distance = (int)(xDist + zDist);
                    } else {
                        distance = player.blockPosition().distManhattan((Vec3i)targetPos.get());
                    }
                    components.add((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_distance", (Object[])new Object[]{distance}).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        if (!level.isClientSide) {
            HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
            boolean locked = honeyCompassStateData.locked();
            Optional<UUID> searchId = honeyCompassStateData.searchId();
            boolean isLoading = honeyCompassStateData.isLoading();
            boolean isFailed = honeyCompassStateData.isFailed();
            boolean locatedSpecialStructure = honeyCompassStateData.locatedSpecialStructure();
            HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
            String compassType = honeyCompassBaseData.compassType();
            HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
            Optional<Object> targetPos = honeyCompassTargetData.targetPos();
            Optional<Object> targetDimension = honeyCompassTargetData.targetDimension();
            Optional<String> targetBlock = honeyCompassTargetData.targetBlock();
            Optional<String> targetStructureTag = honeyCompassTargetData.targetStructureTag();
            if (level.getGameTime() % 20L == 0L && searchId.isPresent()) {
                if (targetPos.isPresent()) {
                    ThreadExecutor.removeSearchResult(searchId.get());
                    searchId = Optional.empty();
                } else {
                    Optional<BlockPos> searchResult = ThreadExecutor.getSearchResult(searchId.get());
                    if (searchResult == null) {
                        isFailed = true;
                    } else if (searchResult.isPresent()) {
                        BlockPos newPos = searchResult.get();
                        compassType = "structure";
                        targetPos = Optional.of(newPos);
                        targetDimension = Optional.of(level.dimension());
                        targetBlock = Optional.empty();
                        targetStructureTag = Optional.empty();
                        isLoading = false;
                        isFailed = false;
                    }
                }
            }
            if (!isFailed && !isLoading && targetStructureTag.isPresent() && targetPos.isEmpty()) {
                isFailed = true;
            }
            if (isLoading && !ThreadExecutor.isRunningASearch() && !ThreadExecutor.hasQueuedSearch()) {
                isLoading = false;
                isFailed = true;
            }
            if (honeyCompassBaseData.isBlockCompass()) {
                if (targetBlock.isPresent() && targetPos.isPresent() && targetDimension.isPresent()) {
                    if (((ResourceKey)targetDimension.get()).equals(level.dimension())) {
                        if (!level.isInWorldBounds((BlockPos)targetPos.get())) {
                            targetPos = Optional.empty();
                            targetDimension = Optional.empty();
                            targetBlock = Optional.empty();
                            compassType = "";
                            HoneyCompass.setCompassBaseData(honeyCompassBaseData, compassType, itemStack);
                            HoneyCompass.setCompassTargetData(honeyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, itemStack);
                            return;
                        }
                        ChunkAccess chunk = level.getChunk(((BlockPos)targetPos.get()).getX() >> 4, ((BlockPos)targetPos.get()).getZ() >> 4, ChunkStatus.FULL, false);
                        if (chunk != null && !BuiltInRegistries.BLOCK.getKey((Object)chunk.getBlockState((BlockPos)targetPos.get()).getBlock()).toString().equals(targetBlock.get())) {
                            targetPos = Optional.empty();
                            targetDimension = Optional.empty();
                            targetBlock = Optional.empty();
                            compassType = "";
                        }
                    }
                } else {
                    targetPos = Optional.empty();
                    targetDimension = Optional.empty();
                    targetBlock = Optional.empty();
                    compassType = "";
                }
            }
            HoneyCompass.setCompassStateData(honeyCompassStateData, locked, searchId, isLoading, isFailed, locatedSpecialStructure, itemStack);
            HoneyCompass.setCompassBaseData(honeyCompassBaseData, compassType, itemStack);
            HoneyCompass.setCompassTargetData(honeyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, itemStack);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ServerLevel serverLevel;
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockPos playerPos = player.blockPosition();
        HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
        boolean locked = honeyCompassStateData.locked();
        Optional<UUID> searchId = honeyCompassStateData.searchId();
        boolean isLoading = honeyCompassStateData.isLoading();
        boolean isFailed = honeyCompassStateData.isFailed();
        boolean locatedSpecialStructure = honeyCompassStateData.locatedSpecialStructure();
        HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
        String compassType = honeyCompassBaseData.compassType();
        HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
        Optional<BlockPos> targetPos = honeyCompassTargetData.targetPos();
        Optional<ResourceKey<Level>> targetDimension = honeyCompassTargetData.targetDimension();
        Optional<String> targetBlock = honeyCompassTargetData.targetBlock();
        Optional<String> targetStructureTag = honeyCompassTargetData.targetStructureTag();
        InteractionResultHolder interactionResult = null;
        if (isFailed && targetStructureTag.isPresent() && level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getServer().getWorldData().worldGenOptions().generateStructures()) {
            boolean structureExists;
            TagKey structureTagKey = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.tryParse((String)targetStructureTag.get()));
            Optional optional = serverLevel.registryAccess().registry(Registries.STRUCTURE).flatMap(registry -> registry.getTag(structureTagKey));
            boolean bl = structureExists = optional.isPresent() && ((HolderSet.Named)optional.get()).stream().anyMatch(structureHolder -> !serverLevel.getChunkSource().getGeneratorState().getPlacementsForStructure(structureHolder).isEmpty());
            if (structureExists) {
                isLoading = true;
                isFailed = false;
                ThreadExecutor.locate((ServerLevel)level, (TagKey<Structure>)structureTagKey, playerPos, 100, false).thenOnServerThread(foundPos -> this.setCompassData((ServerLevel)level, (ServerPlayer)player, interactionHand, itemStack, (BlockPos)foundPos));
                interactionResult = InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_wrong_dimension"), true);
                interactionResult = InteractionResultHolder.pass((Object)itemStack);
            }
        }
        if (interactionResult != null) {
            HoneyCompass.setCompassStateData(honeyCompassStateData, locked, searchId, isLoading, isFailed, locatedSpecialStructure, itemStack);
            HoneyCompass.setCompassBaseData(honeyCompassBaseData, compassType, itemStack);
            HoneyCompass.setCompassTargetData(honeyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, itemStack);
            return interactionResult;
        }
        if (isLoading) {
            if (ThreadExecutor.isRunningASearch() || ThreadExecutor.hasQueuedSearch()) {
                HoneyCompass.setCompassStateData(honeyCompassStateData, locked, searchId, isLoading, isFailed, locatedSpecialStructure, itemStack);
                HoneyCompass.setCompassBaseData(honeyCompassBaseData, compassType, itemStack);
                HoneyCompass.setCompassTargetData(honeyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, itemStack);
                return InteractionResultHolder.fail((Object)itemStack);
            }
            isLoading = false;
        }
        if (locked) {
            return super.use(level, player, interactionHand);
        }
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (!honeyCompassBaseData.isStructureCompass()) {
                boolean structureExists;
                Optional optional = serverLevel.registryAccess().registry(Registries.STRUCTURE).flatMap(registry -> registry.getTag(BzTags.HONEY_COMPASS_DEFAULT_LOCATING));
                boolean bl = structureExists = optional.isPresent() && ((HolderSet.Named)optional.get()).stream().anyMatch(structureHolder -> !serverLevel.getChunkSource().getGeneratorState().getPlacementsForStructure(structureHolder).isEmpty());
                if (structureExists) {
                    isLoading = true;
                    ThreadExecutor.locate((ServerLevel)level, BzTags.HONEY_COMPASS_DEFAULT_LOCATING, playerPos, 100, false).thenOnServerThread(foundPos -> this.setCompassData((ServerLevel)level, (ServerPlayer)player, interactionHand, itemStack, (BlockPos)foundPos));
                    interactionResult = InteractionResultHolder.success((Object)itemStack);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_wrong_dimension"), true);
                    interactionResult = InteractionResultHolder.pass((Object)itemStack);
                }
            }
        }
        HoneyCompass.setCompassStateData(honeyCompassStateData, locked, searchId, isLoading, isFailed, locatedSpecialStructure, itemStack);
        HoneyCompass.setCompassBaseData(honeyCompassBaseData, compassType, itemStack);
        HoneyCompass.setCompassTargetData(honeyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, itemStack);
        if (interactionResult != null) {
            return interactionResult;
        }
        return super.use(level, player, interactionHand);
    }

    private void setCompassData(ServerLevel serverLevel, ServerPlayer serverPlayer, InteractionHand interactionHand, ItemStack itemStack, BlockPos structurePos) {
        boolean singleCompass;
        HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
        boolean locked = honeyCompassStateData.locked();
        Optional<UUID> searchId = honeyCompassStateData.searchId();
        boolean isLoading = false;
        boolean isFailed = honeyCompassStateData.isFailed();
        boolean locatedSpecialStructure = honeyCompassStateData.locatedSpecialStructure();
        HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
        String compassType = honeyCompassBaseData.compassType();
        HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
        Optional<BlockPos> targetPos = honeyCompassTargetData.targetPos();
        Optional<ResourceKey<Level>> targetDimension = honeyCompassTargetData.targetDimension();
        Optional<String> targetBlock = honeyCompassTargetData.targetBlock();
        Optional<String> targetStructureTag = honeyCompassTargetData.targetStructureTag();
        serverLevel.playSound(null, serverPlayer.blockPosition(), (SoundEvent)BzSounds.HONEY_COMPASS_STRUCTURE_LOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        serverPlayer.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
        if (structurePos == null) {
            serverPlayer.swing(interactionHand);
            serverPlayer.displayClientMessage((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_failed"), false);
            return;
        }
        ((GenericTrigger)((Object)BzCriterias.HONEY_COMPASS_USE_TRIGGER.get())).trigger(serverPlayer);
        boolean bl = singleCompass = !serverPlayer.getAbilities().instabuild && itemStack.getCount() == 1;
        if (singleCompass) {
            compassType = "structure";
            targetPos = Optional.of(structurePos);
            targetDimension = Optional.of(serverLevel.dimension());
            targetBlock = Optional.empty();
            targetStructureTag = Optional.empty();
            isFailed = false;
        } else {
            ItemStack newCompass = itemStack.copyWithCount(1);
            if (!serverPlayer.getAbilities().instabuild) {
                itemStack.shrink(1);
            } else {
                isFailed = false;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"item.the_bumblezone.honey_compass_structure_creative").withStyle(ChatFormatting.YELLOW), true);
            }
            HoneyCompassStateData newHoneyCompassStateData = (HoneyCompassStateData)newCompass.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
            HoneyCompassBaseData newHoneyCompassBaseData = (HoneyCompassBaseData)newCompass.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
            HoneyCompassTargetData newHoneyCompassTargetData = (HoneyCompassTargetData)newCompass.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
            HoneyCompass.setCompassStateData(newHoneyCompassStateData, newHoneyCompassStateData.locked(), Optional.empty(), false, false, newHoneyCompassStateData.locatedSpecialStructure(), newCompass);
            HoneyCompass.setCompassBaseData(newHoneyCompassBaseData, "structure", newCompass);
            HoneyCompass.setCompassTargetData(newHoneyCompassTargetData, Optional.empty(), Optional.empty(), Optional.of(structurePos), Optional.of(serverLevel.dimension()), newCompass);
            if (!serverPlayer.getInventory().add(newCompass)) {
                serverPlayer.drop(newCompass, false);
            }
        }
        HoneyCompass.setCompassStateData(honeyCompassStateData, locked, searchId, isLoading, isFailed, locatedSpecialStructure, itemStack);
        HoneyCompass.setCompassBaseData(honeyCompassBaseData, compassType, itemStack);
        HoneyCompass.setCompassTargetData(honeyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, itemStack);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockPos blockPos = useOnContext.getClickedPos();
        Level level = useOnContext.getLevel();
        Player player = useOnContext.getPlayer();
        ItemStack itemStack = useOnContext.getItemInHand();
        BlockState blockState = level.getBlockState(blockPos);
        HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
        boolean locked = honeyCompassStateData.locked();
        Optional<UUID> searchId = honeyCompassStateData.searchId();
        boolean isLoading = honeyCompassStateData.isLoading();
        boolean isFailed = honeyCompassStateData.isFailed();
        boolean locatedSpecialStructure = honeyCompassStateData.locatedSpecialStructure();
        if (isLoading) {
            if (ThreadExecutor.isRunningASearch() || ThreadExecutor.hasQueuedSearch()) {
                return InteractionResult.FAIL;
            }
            isLoading = false;
        }
        if (locked) {
            HoneyCompass.setCompassStateData(honeyCompassStateData, locked, searchId, isLoading, isFailed, locatedSpecialStructure, itemStack);
            return super.useOn(useOnContext);
        }
        if (player != null && HoneyCompass.isValidBeeHive(blockState)) {
            level.playSound(null, blockPos, (SoundEvent)BzSounds.HONEY_COMPASS_BLOCK_LOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((GenericTrigger)((Object)BzCriterias.HONEY_COMPASS_USE_TRIGGER.get())).trigger(serverPlayer);
            }
            if (!level.isClientSide()) {
                boolean singleCompass;
                boolean bl = singleCompass = !player.getAbilities().instabuild && itemStack.getCount() == 1;
                if (singleCompass) {
                    HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
                    HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
                    String compassType = "block";
                    Optional<BlockPos> targetPos = Optional.of(blockPos);
                    Optional<ResourceKey<Level>> targetDimension = Optional.of(level.dimension());
                    Optional<String> targetBlock = Optional.of(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString());
                    Optional<String> targetStructureTag = Optional.empty();
                    isFailed = false;
                    HoneyCompass.setCompassStateData(honeyCompassStateData, locked, searchId, isLoading, isFailed, locatedSpecialStructure, itemStack);
                    HoneyCompass.setCompassBaseData(honeyCompassBaseData, compassType, itemStack);
                    HoneyCompass.setCompassTargetData(honeyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, itemStack);
                } else {
                    ItemStack newCompass = itemStack.copyWithCount(1);
                    if (!player.getAbilities().instabuild) {
                        itemStack.shrink(1);
                    }
                    HoneyCompassStateData newHoneyCompassStateData = (HoneyCompassStateData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
                    HoneyCompassBaseData newHoneyCompassBaseData = (HoneyCompassBaseData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
                    HoneyCompassTargetData newHoneyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
                    String compassType = "block";
                    Optional<BlockPos> targetPos = Optional.of(blockPos);
                    Optional<ResourceKey<Level>> targetDimension = Optional.of(level.dimension());
                    Optional<String> targetBlock = Optional.of(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString());
                    Optional<String> targetStructureTag = Optional.empty();
                    HoneyCompass.setCompassStateData(newHoneyCompassStateData, locked, searchId, false, false, locatedSpecialStructure, newCompass);
                    HoneyCompass.setCompassBaseData(newHoneyCompassBaseData, compassType, newCompass);
                    HoneyCompass.setCompassTargetData(newHoneyCompassTargetData, targetBlock, targetStructureTag, targetPos, targetDimension, newCompass);
                    if (!player.getInventory().add(newCompass)) {
                        player.drop(newCompass, false);
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(useOnContext);
    }

    public static boolean isValidBeeHive(BlockState block) {
        if (block.is(BzTags.FORCED_ALLOWED_POSITION_TRACKING_BLOCKS)) {
            return true;
        }
        if (block.is(BzTags.DISALLOWED_POSITION_TRACKING_BLOCKS)) {
            return false;
        }
        return block.is(BlockTags.BEEHIVES) || block.getBlock() instanceof BeehiveBlock;
    }

    public static void setCompassTargetData(HoneyCompassTargetData honeyCompassTargetData, Optional<String> targetBlock, Optional<String> targetStructureTag, Optional<BlockPos> targetPos, Optional<ResourceKey<Level>> targetDimension, ItemStack itemStack) {
        if (honeyCompassTargetData.isDifferent(targetBlock, targetStructureTag, targetPos, targetDimension)) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get(), (Object)new HoneyCompassTargetData(targetBlock, targetStructureTag, targetPos, targetDimension));
        }
    }

    public static void setCompassBaseData(HoneyCompassBaseData honeyCompassBaseData, String compassType, ItemStack itemStack) {
        if (!honeyCompassBaseData.compassType().equals(compassType)) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get(), (Object)new HoneyCompassBaseData(compassType, honeyCompassBaseData.customName(), honeyCompassBaseData.customDescription()));
        }
    }

    public static void setCompassStateData(HoneyCompassStateData honeyCompassStateData, boolean locked, Optional<UUID> searchId, boolean isLoading, boolean isFailed, boolean locatedSpecialStructure, ItemStack itemStack) {
        if (honeyCompassStateData.isDifferent(locked, searchId, isLoading, isFailed, locatedSpecialStructure)) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get(), (Object)new HoneyCompassStateData(locked, searchId, isLoading, isFailed, locatedSpecialStructure));
        }
    }
}

