/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyBeeLeggingsData;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityTickEvent;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.PollenPuff;
import com.telepathicgrunt.the_bumblezone.mixin.effects.MobEffectInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HoneyBeeLeggings
extends BeeArmor {
    public HoneyBeeLeggings(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties, int variant) {
        super(material, armorType, properties.component((DataComponentType)BzDataComponents.HONEY_BEE_LEGGINGS_DATA.get(), (Object)new HoneyBeeLeggingsData()), variant, false);
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.HONEY_BEE_LEGGINGS_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_BEE_LEGGINGS_DATA.get(), (Object)new HoneyBeeLeggingsData());
        }
    }

    @Override
    public void bz$onArmorTick(ItemStack itemstack, Level level, Player player) {
        if (player.isSpectator()) {
            return;
        }
        if (player.getCooldowns().isOnCooldown(itemstack.getItem())) {
            return;
        }
        RandomSource random = player.getRandom();
        boolean isPollinated = HoneyBeeLeggings.isPollinated(itemstack);
        boolean isSprinting = player.isSprinting();
        int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)player);
        HoneyBeeLeggings.pollenBehavior(itemstack, level, (LivingEntity)player, random, isPollinated, isSprinting, beeWearablesCount);
        HoneyBeeLeggings.effectBehavior(itemstack, level, (LivingEntity)player, random, beeWearablesCount);
        HoneyBeeLeggings.spawnParticles(level, (LivingEntity)player, random, isPollinated, isSprinting, beeWearablesCount);
    }

    private static void pollenBehavior(ItemStack itemstack, Level level, LivingEntity livingEntity, RandomSource random, boolean isPollinated, boolean isSprinting, int beeWearablesCount) {
        if (!level.isClientSide()) {
            ServerPlayer serverPlayer;
            boolean ejectPollen;
            boolean bl = ejectPollen = livingEntity.isShiftKeyDown() && isPollinated;
            if (!ejectPollen && isPollinated && level.getGameTime() % 3L == 0L) {
                BlockState state;
                if (livingEntity.getBlockStateOn().is(BzTags.HONEY_BEE_BOOTS_REMOVES_POLLEN_BLOCKS)) {
                    ejectPollen = true;
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer2 = (ServerPlayer)livingEntity;
                        ((GenericTrigger)((Object)BzCriterias.HONEY_BEE_LEGGINGS_POLLEN_REMOVAL_TRIGGER.get())).trigger(serverPlayer2);
                    }
                }
                if (!ejectPollen && (state = level.getBlockState(livingEntity.blockPosition())).getFluidState().is(BzTags.HONEY_BEE_BOOTS_REMOVES_POLLEN_FLUIDS)) {
                    ejectPollen = true;
                    if (livingEntity instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)livingEntity;
                        ((GenericTrigger)((Object)BzCriterias.HONEY_BEE_LEGGINGS_POLLEN_REMOVAL_TRIGGER.get())).trigger(serverPlayer);
                    }
                }
            }
            if (ejectPollen) {
                HoneyBeeLeggings.removeAndSpawnPollen(level, livingEntity.position(), itemstack);
                if (!level.isClientSide() && random.nextFloat() < 0.1f) {
                    itemstack.hurtAndBreak(1, livingEntity, EquipmentSlot.LEGS);
                }
            } else if (!livingEntity.isShiftKeyDown() && !isPollinated) {
                BlockState withinBlock = level.getBlockState(livingEntity.blockPosition());
                if (withinBlock.is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
                    HoneyBeeLeggings.setPollinated(itemstack);
                    int newLevel = (Integer)withinBlock.getValue((Property)PileOfPollen.LAYERS) - 1;
                    if (newLevel == 0) {
                        level.setBlock(livingEntity.blockPosition(), Blocks.AIR.defaultBlockState(), 3);
                    } else {
                        level.setBlock(livingEntity.blockPosition(), (BlockState)withinBlock.setValue((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(newLevel)), 3);
                    }
                } else {
                    float f = random.nextFloat();
                    float f2 = (float)(beeWearablesCount - 1) * 0.015f;
                    float f3 = isSprinting ? 0.015f : 0.00333f;
                    if (f < f2 + f3 && withinBlock.is(BlockTags.FLOWERS)) {
                        HoneyBeeLeggings.setPollinated(itemstack);
                        if (livingEntity instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)livingEntity;
                            ((GenericTrigger)((Object)BzCriterias.HONEY_BEE_LEGGINGS_FLOWER_POLLEN_TRIGGER.get())).trigger(serverPlayer);
                            serverPlayer.awardStat((ResourceLocation)BzStats.HONEY_BEE_LEGGINGS_FLOWER_POLLEN_RL.get());
                        }
                    }
                }
            }
        }
    }

    private static void effectBehavior(ItemStack itemstack, Level level, LivingEntity livingEntity, RandomSource random, int beeWearablesCount) {
        MobEffectInstance slowness = livingEntity.getEffect(MobEffects.MOVEMENT_SLOWDOWN);
        if (slowness != null && (beeWearablesCount >= 3 || level.getGameTime() % 2L == 0L)) {
            for (int i = 0; i <= Math.max(beeWearablesCount - 2, 1); ++i) {
                if (slowness.getDuration() <= 0) continue;
                ((MobEffectInstanceAccessor)slowness).callTickDownDuration();
            }
            if (!level.isClientSide() && random.nextFloat() < 0.004f && itemstack.getMaxDamage() - itemstack.getDamageValue() > 1) {
                itemstack.hurtAndBreak(1, livingEntity, EquipmentSlot.LEGS);
            }
        }
    }

    private static void spawnParticles(Level world, LivingEntity livingEntity, RandomSource random, boolean isPollinated, boolean isSprinting, int beeWearablesCount) {
        block3: {
            block4: {
                if (!world.isClientSide() || !isPollinated) break block3;
                if (isSprinting) break block4;
                float f = random.nextFloat();
                float f2 = beeWearablesCount >= 3 ? 0.03f : 0.025f;
                if (!(f < f2)) break block3;
            }
            int particles = beeWearablesCount >= 3 ? 2 : 1;
            for (int i = 0; i < particles; ++i) {
                double speedYModifier = isSprinting ? 0.05 : 0.02;
                double speedXZModifier = isSprinting ? 0.03 : 0.02;
                double xOffset = (double)random.nextFloat() * 0.1 - 0.05;
                double yOffset = (double)random.nextFloat() * 0.1 + 0.25;
                double zOffset = (double)random.nextFloat() * 0.1 - 0.05;
                Vec3 pos = livingEntity.position();
                world.addParticle((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), true, pos.x() + xOffset, pos.y() + yOffset, pos.z() + zOffset, random.nextGaussian() * speedXZModifier, (random.nextGaussian() + 0.25) * speedYModifier, random.nextGaussian() * speedXZModifier);
            }
        }
    }

    public static void armorStandTick(EntityTickEvent event) {
        ArmorStand armorStand;
        ItemStack leggings;
        LivingEntity livingEntity = event.entity();
        if (livingEntity instanceof ArmorStand && (leggings = (armorStand = (ArmorStand)livingEntity).getItemBySlot(EquipmentSlot.LEGS)).getItem() instanceof HoneyBeeLeggings) {
            Level level = armorStand.level();
            RandomSource random = armorStand.getRandom();
            boolean isPollinated = HoneyBeeLeggings.isPollinated(leggings);
            boolean isSprinting = armorStand.isSprinting();
            int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)armorStand);
            HoneyBeeLeggings.pollenBehavior(leggings, level, (LivingEntity)armorStand, random, isPollinated, isSprinting, beeWearablesCount);
        }
    }

    public static ItemStack getEntityBeeLegging(LivingEntity entity) {
        for (ItemStack armor : entity.getArmorSlots()) {
            if (!(armor.getItem() instanceof HoneyBeeLeggings)) continue;
            return armor;
        }
        return ItemStack.EMPTY;
    }

    public static void setPollinated(ItemStack itemStack) {
        if (itemStack.getItem() instanceof HoneyBeeLeggings) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_BEE_LEGGINGS_DATA.get(), (Object)new HoneyBeeLeggingsData(true));
        }
    }

    public static void clearPollinated(ItemStack itemStack) {
        if (itemStack.getItem() instanceof HoneyBeeLeggings) {
            itemStack.set((DataComponentType)BzDataComponents.HONEY_BEE_LEGGINGS_DATA.get(), (Object)new HoneyBeeLeggingsData(false));
        }
    }

    public static boolean isPollinated(ItemStack itemStack) {
        return itemStack.getItem() instanceof HoneyBeeLeggings && ((HoneyBeeLeggingsData)itemStack.get((DataComponentType)BzDataComponents.HONEY_BEE_LEGGINGS_DATA.get())).pollinated();
    }

    public static void removeAndSpawnPollen(Level world, Vec3 position, ItemStack itemStack) {
        if (itemStack.getItem() instanceof HoneyBeeLeggings) {
            PollenPuff.spawnItemstackEntity(world, position.add(new Vec3(0.0, 0.25, 0.0)), new ItemStack((ItemLike)BzItems.POLLEN_PUFF.get(), 1));
            HoneyBeeLeggings.clearPollinated(itemStack);
        }
    }
}

