/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.BzArmor;
import com.telepathicgrunt.the_bumblezone.mixin.effects.MobEffectInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FlowerHeadwearHelmet
extends BzArmor
implements ItemExtension {
    public FlowerHeadwearHelmet(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties) {
        super(material, armorType, properties);
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(BzTags.FLOWER_HEADWEAR_REPAIR_ITEMS);
    }

    @Override
    public void bz$onArmorTick(ItemStack itemstack, Level world, Player player) {
        if (player.getCooldowns().isOnCooldown(itemstack.getItem())) {
            return;
        }
        int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)player);
        MobEffectInstance wrath = player.getEffect(BzEffects.WRATH_OF_THE_HIVE.holder());
        if (wrath != null) {
            if (wrath.getDuration() > 0) {
                ((MobEffectInstanceAccessor)wrath).callTickDownDuration();
                if (beeWearablesCount > 3) {
                    ((MobEffectInstanceAccessor)wrath).callTickDownDuration();
                }
            }
            if (!world.isClientSide() && player.getRandom().nextFloat() < 0.002f && itemstack.getMaxDamage() - itemstack.getDamageValue() > 1) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
            }
        }
    }

    public static ItemStack getFlowerHeadwear(LivingEntity entity) {
        for (ItemStack armor : entity.getArmorSlots()) {
            Player player;
            Item item = armor.getItem();
            if (!(item instanceof FlowerHeadwearHelmet)) continue;
            FlowerHeadwearHelmet flowerHeadwearHelmet = (FlowerHeadwearHelmet)item;
            if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown((Item)flowerHeadwearHelmet)) continue;
            return armor;
        }
        AtomicReference<ItemStack> flowerStack = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        for (ModCompat compat : ModChecker.CUSTOM_EQUIPMENT_SLOTS_COMPATS) {
            compat.getNumberOfMatchingEquippedItemsInCustomSlots((Entity)entity, itemStack -> {
                if (itemStack.is((Item)BzItems.FLOWER_HEADWEAR.get())) {
                    Player player;
                    if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(itemStack.getItem())) {
                        return false;
                    }
                    flowerStack.set((ItemStack)itemStack);
                    return true;
                }
                return false;
            });
        }
        return flowerStack.get();
    }
}

