/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.datacomponents.CrystallineFlowerData;
import com.telepathicgrunt.the_bumblezone.items.BzBlockItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CrystallineFlowerBlockItem
extends BzBlockItem {
    public CrystallineFlowerBlockItem(Block block, Item.Properties properties, boolean fitInContainers, boolean useBlockName) {
        super(block, properties.component((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get(), (Object)new CrystallineFlowerData()), fitInContainers, useBlockName);
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get(), (Object)new CrystallineFlowerData());
        }
    }

    @Override
    protected BlockState getPlacementState(BlockPlaceContext blockPlaceContext) {
        BlockState resultantState;
        BlockState blockState = this.getBlock().getStateForPlacement(blockPlaceContext);
        BlockState blockState2 = resultantState = blockState != null && this.canPlace(blockPlaceContext, blockState) ? blockState : null;
        if (blockPlaceContext.getItemInHand().has((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get())) {
            int tiers;
            List<Boolean> obstructions;
            CrystallineFlowerData crystallineFlowerData = (CrystallineFlowerData)blockPlaceContext.getItemInHand().get((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get());
            if (resultantState != null && crystallineFlowerData != null && (obstructions = CrystallineFlower.getObstructions(tiers = crystallineFlowerData.tier(), blockPlaceContext.getLevel(), blockPlaceContext.getClickedPos())).stream().anyMatch(b -> b)) {
                Player player = blockPlaceContext.getPlayer();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MutableComponent message = Component.translatable((String)"item.the_bumblezone.crystalline_flower_cannot_place").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED);
                    serverPlayer.displayClientMessage((Component)message, true);
                }
                return null;
            }
        }
        return resultantState;
    }
}

