/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.datacomponents.CrystalCannonData;
import com.telepathicgrunt.the_bumblezone.items.HoneyCrystalShards;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.TriState;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CrystalCannon
extends ProjectileWeaponItem
implements ItemExtension {
    public CrystalCannon(Item.Properties properties) {
        super(properties.component((DataComponentType)BzDataComponents.CRYSTAL_CANNON_DATA.get(), (Object)new CrystalCannonData()));
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.CRYSTAL_CANNON_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.CRYSTAL_CANNON_DATA.get(), (Object)new CrystalCannonData());
        }
    }

    protected void shootProjectile(LivingEntity livingEntity, Projectile projectile, int projectileIndex, float shootingPower, float difficulty, float someMagicNumber, @Nullable LivingEntity livingEntity2) {
        float offset = 0.0f;
        if (projectileIndex == 1) {
            offset = livingEntity.getRandom().nextFloat() * 5.0f + 3.5f;
        } else if (projectileIndex == 2) {
            offset = livingEntity.getRandom().nextFloat() * 5.0f - 11.5f;
        } else if (projectileIndex != 0) {
            offset = livingEntity.getRandom().nextFloat() * 10.0f - 5.0f;
        }
        Vec3 entityEyePos = new Vec3(livingEntity.getX(), livingEntity.getEyeY() - 0.25, livingEntity.getZ());
        projectile.moveTo(entityEyePos.x(), entityEyePos.y(), entityEyePos.z(), livingEntity.getYRot(), livingEntity.getXRot());
        Vec3 upVector = livingEntity.getUpVector(1.0f);
        Vec3 viewVector = livingEntity.getViewVector(1.0f);
        Vector3f shootVector = viewVector.toVector3f();
        if (projectileIndex != 0) {
            Quaternionf quaternion1 = new Quaternionf(upVector.x(), upVector.y(), upVector.z(), (double)offset);
            shootVector.rotate((Quaternionfc)quaternion1);
        }
        float weaponProjectileSpeed = 1.9f * shootingPower;
        projectile.shoot((double)shootVector.x(), (double)(shootVector.y() + (livingEntity.getRandom().nextFloat() * 0.2f + 0.01f)), (double)shootVector.z(), weaponProjectileSpeed, 1.0f);
    }

    public void releaseUsing(ItemStack crystalCannon, Level level, LivingEntity livingEntity, int currentDuration) {
        if (!level.isClientSide()) {
            ItemStack mutableCrystalCannon = livingEntity.getItemInHand(InteractionHand.MAIN_HAND);
            int numberOfCrystals = CrystalCannon.getNumberOfCrystals(mutableCrystalCannon);
            int remainingDuration = this.getUseDuration(mutableCrystalCannon, livingEntity) - currentDuration;
            if ((float)remainingDuration / (float)this.getChargeDuration(mutableCrystalCannon, livingEntity) > 0.99f && numberOfCrystals > 0) {
                int crystalsToSpawn = CrystalCannon.getAndClearStoredCrystals(mutableCrystalCannon);
                for (int crystalIndex = 0; crystalIndex < crystalsToSpawn; ++crystalIndex) {
                    AbstractArrow newCrystal = ((HoneyCrystalShards)((Object)BzItems.HONEY_CRYSTAL_SHARDS.get())).createArrow(level, crystalCannon, livingEntity, mutableCrystalCannon);
                    newCrystal.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    this.shootProjectile(livingEntity, (Projectile)newCrystal, crystalIndex, 1.0f, 1.0f, 0.0f, null);
                    level.addFreshEntity((Entity)newCrystal);
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.awardStat(Stats.ITEM_USED.get((Object)mutableCrystalCannon.getItem()));
                    }
                    level.playSound(null, livingEntity.blockPosition(), (SoundEvent)BzSounds.CRYSTAL_CANNON_FIRES.get(), SoundSource.PLAYERS, 1.0f, livingEntity.getRandom().nextFloat() * 0.2f + 0.6f);
                    mutableCrystalCannon.hurtAndBreak(1, livingEntity, EquipmentSlot.MAINHAND);
                    if (numberOfCrystals < 3 || !(livingEntity instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    ((GenericTrigger)((Object)BzCriterias.CRYSTAL_CANNON_FULL_TRIGGER.get())).trigger(serverPlayer);
                }
                mutableCrystalCannon.hurtAndBreak(1, livingEntity, EquipmentSlot.MAINHAND);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack crystalCannon = player.getItemInHand(interactionHand);
        if (!level.isClientSide()) {
            this.loadProjectiles(player, crystalCannon);
        }
        if (CrystalCannon.getNumberOfCrystals(crystalCannon) == 0) {
            return InteractionResultHolder.fail((Object)crystalCannon);
        }
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)crystalCannon);
    }

    private void loadProjectiles(Player player, ItemStack crystalCannon) {
        ItemStack projectItem1 = player.getProjectile(crystalCannon);
        if (projectItem1.isEmpty()) {
            return;
        }
        if (CrystalCannon.tryAddCrystal(crystalCannon)) {
            boolean infinite;
            boolean bl = infinite = player.getAbilities().instabuild || projectItem1.getItem() instanceof HoneyCrystalShards && ((HoneyCrystalShards)projectItem1.getItem()).bz$isInfinite(projectItem1, crystalCannon, (LivingEntity)player).orElseGet(() -> false);
            if (!infinite) {
                projectItem1.shrink(1);
                if (projectItem1.isEmpty()) {
                    player.getInventory().removeItem(projectItem1);
                }
            }
        }
    }

    public static int getAndClearStoredCrystals(ItemStack crystalCannonItem) {
        int numberOfCrystals = CrystalCannon.getNumberOfCrystals(crystalCannonItem);
        if (numberOfCrystals > 0) {
            crystalCannonItem.set((DataComponentType)BzDataComponents.CRYSTAL_CANNON_DATA.get(), (Object)new CrystalCannonData(0));
        }
        return numberOfCrystals;
    }

    public static boolean tryAddCrystal(ItemStack crystalCannonItem) {
        if (CrystalCannon.getNumberOfCrystals(crystalCannonItem) < 3) {
            CrystalCannonData crystalCannonData = (CrystalCannonData)crystalCannonItem.get((DataComponentType)BzDataComponents.CRYSTAL_CANNON_DATA.get());
            crystalCannonItem.set((DataComponentType)BzDataComponents.CRYSTAL_CANNON_DATA.get(), (Object)new CrystalCannonData(crystalCannonData.crystalStored() + 1));
            return true;
        }
        return false;
    }

    public static int getNumberOfCrystals(ItemStack crystalCannonItem) {
        CrystalCannonData crystalCannonData = (CrystalCannonData)crystalCannonItem.get((DataComponentType)BzDataComponents.CRYSTAL_CANNON_DATA.get());
        return crystalCannonData.crystalStored();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(BzTags.CRYSTAL_CANNON_REPAIR_ITEMS);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return itemStack -> itemStack.is((Item)BzItems.HONEY_CRYSTAL_SHARDS.get());
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return itemStack -> itemStack.is((Item)BzItems.HONEY_CRYSTAL_SHARDS.get());
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public int getDefaultProjectileRange() {
        return 0;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public int getChargeDuration(ItemStack itemStack, LivingEntity livingEntity) {
        float chargeTime = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)itemStack, (LivingEntity)livingEntity, (float)1.25f);
        return Mth.floor((float)(chargeTime * 20.0f));
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    @Override
    public TriState bz$canEnchant(ItemStack itemstack, Holder<Enchantment> enchantment) {
        return enchantment.is(BzTags.ENCHANTABLES_CRYSTAL_CANNON_FORCED_ALLOWED) ? TriState.ALLOW : TriState.PASS;
    }

    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return ((HoneyCrystalShards)((Object)BzItems.HONEY_CRYSTAL_SHARDS.get())).getDefaultInstance();
    }
}

