/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;

public class BzMusicDiscs
extends Item {
    private final boolean hasDownload;

    public BzMusicDiscs(Item.Properties settings, boolean hasDownload) {
        super(settings);
        this.hasDownload = hasDownload;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        if (this.hasDownload) {
            Optional<Integer> songDescLength = ((JukeboxPlayable)itemStack.get(DataComponents.JUKEBOX_PLAYABLE)).song().unwrap(tooltipContext.registries()).map(holder -> ((JukeboxSong)holder.value()).description().getString().length());
            int length = songDescLength.orElse(20);
            List<MutableComponent> componentList = GeneralUtilsClient.autoWrappedTooltip(length, this.getDescriptionId() + ".download");
            componentList.forEach(component -> list.add((Component)component.withStyle(tooltipFlag.isAdvanced() ? ChatFormatting.DARK_PURPLE : ChatFormatting.DARK_GRAY)));
        }
    }
}

