/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.CounterTrigger;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.mobs.VariantBeeEntity;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerItemAttackBlockEvent;
import com.telepathicgrunt.the_bumblezone.menus.BuzzingBriefcaseMenuProvider;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BuzzingBriefcase
extends Item {
    public static final String TAG_BEES = "BeesStored";
    public static final String TAG_VARANT_BEES = "VariantBeesStored";
    public static final int MAX_NUMBER_OF_BEES = 14;

    public BuzzingBriefcase(Item.Properties properties) {
        super(properties.component((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get(), (Object)CustomData.EMPTY));
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get(), (Object)CustomData.EMPTY);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)new BuzzingBriefcaseMenuProvider(stack));
            player.awardStat((ResourceLocation)BzStats.INTERACT_WITH_BUZZING_BRIEFCASE_RL.get());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public static InteractionResult onLeftClickBlock(PlayerItemAttackBlockEvent event) {
        Player player = event.user();
        ItemStack briefcaseItem = player.getItemInHand(event.hand());
        if (event.hand() != InteractionHand.MAIN_HAND || !briefcaseItem.is((Item)BzItems.BUZZING_BRIEFCASE.get()) || player.getCooldowns().isOnCooldown(briefcaseItem.getItem())) {
            return null;
        }
        if (player.level().isClientSide()) {
            int numberOfBees = BuzzingBriefcase.getNumberOfBees(briefcaseItem);
            return numberOfBees > 0 ? InteractionResult.SUCCESS : null;
        }
        List<Entity> releasedBees = BuzzingBriefcase.dumpBees(player, player.isCrouching() ? -1 : 0, false);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!releasedBees.isEmpty()) {
                ((GenericTrigger)((Object)BzCriterias.BUZZING_BRIEFCASE_RELEASE_TRIGGER.get())).trigger(serverPlayer);
                player.awardStat(Stats.ITEM_USED.get((Object)briefcaseItem.getItem()));
                serverPlayer.getCooldowns().addCooldown(briefcaseItem.getItem(), 10);
                return InteractionResult.SUCCESS;
            }
        }
        return null;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity victim, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (player.getCooldowns().isOnCooldown(stack.getItem())) {
                return false;
            }
            boolean isVictimBeelike = BeeAggression.isBeelikeEntity((Entity)victim);
            List<Entity> releasedBees = BuzzingBriefcase.dumpBees(player, player.isCrouching() ? -1 : 0, false);
            for (Entity entity : releasedBees) {
                if (!(entity instanceof NeutralMob)) continue;
                NeutralMob neutralMob = (NeutralMob)entity;
                if (isVictimBeelike) continue;
                neutralMob.setTarget(victim);
                neutralMob.setRemainingPersistentAngerTime(400);
                neutralMob.setPersistentAngerTarget(victim.getUUID());
            }
            if (!isVictimBeelike && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!releasedBees.isEmpty()) {
                    ((GenericTrigger)((Object)BzCriterias.BUZZING_BRIEFCASE_RELEASE_TRIGGER.get())).trigger(serverPlayer);
                    serverPlayer.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    serverPlayer.getCooldowns().addCooldown(stack.getItem(), 10);
                }
            }
        }
        return true;
    }

    public InteractionResult interactLivingEntity(ItemStack beeCannon, Player player, LivingEntity entity, InteractionHand playerHand) {
        Bee bee;
        if (!(entity instanceof Bee) || (bee = (Bee)entity).getType().is(BzTags.BUZZING_BRIEFCASE_DISALLOWED_BEE) || entity.isDeadOrDying()) {
            return InteractionResult.PASS;
        }
        if (player.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack briefcaseItem = player.getItemInHand(playerHand);
        if (player.getCooldowns().isOnCooldown(briefcaseItem.getItem())) {
            return InteractionResult.PASS;
        }
        boolean addedBee = BuzzingBriefcase.tryAddBee(briefcaseItem, (Entity)entity);
        if (addedBee) {
            ServerPlayer serverPlayer;
            player.awardStat((ResourceLocation)BzStats.BUZZING_BRIEFCASE_BEE_CAPTURE_RL.get());
            player.awardStat(Stats.ITEM_USED.get((Object)briefcaseItem.getItem()));
            player.swing(playerHand, true);
            if (player instanceof ServerPlayer && BuzzingBriefcase.getBeesStored((serverPlayer = (ServerPlayer)player).level(), briefcaseItem, false).size() == 14) {
                ((GenericTrigger)((Object)BzCriterias.BUZZING_BRIEFCASE_FULL_TRIGGER.get())).trigger(serverPlayer);
            }
            CompoundTag cannonTag = ((CustomData)briefcaseItem.get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get())).getUnsafe();
            int variantBeesCaught = cannonTag.getInt(TAG_VARANT_BEES);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer2 = (ServerPlayer)player;
                if (variantBeesCaught > 0) {
                    ((CounterTrigger)((Object)BzCriterias.VARIANT_BEE_BRIEFCASE_CAPTURE_TRIGGER.get())).trigger(serverPlayer2, variantBeesCaught);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static List<Entity> dumpBees(Player player, int beeIndex, boolean releaseAtPlayer) {
        Level level = player.level();
        ItemStack briefcaseItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        int numberOfBees = BuzzingBriefcase.getNumberOfBees(briefcaseItem);
        if (numberOfBees > 0) {
            List<Object> bees = new ArrayList<Entity>();
            if (beeIndex == -1) {
                bees = BuzzingBriefcase.getBeesStored(level, briefcaseItem, true);
            } else {
                bees.add(BuzzingBriefcase.getSpecificBeesStored(level, briefcaseItem, beeIndex, true));
            }
            if (!bees.isEmpty()) {
                player.awardStat(Stats.ITEM_USED.get((Object)briefcaseItem.getItem()));
                float maxDistance = 15.0f;
                Vec3 playerEyePos = new Vec3(player.getX(), player.getEyeY() - 0.25, player.getZ());
                Vec3 maxDistanceDirection = player.getLookAngle().multiply((double)maxDistance, (double)maxDistance, (double)maxDistance);
                Vec3 finalPos = playerEyePos.add(maxDistanceDirection.normalize());
                if (!releaseAtPlayer) {
                    finalPos = playerEyePos.add(maxDistanceDirection);
                    EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)playerEyePos, (Vec3)finalPos, (AABB)player.getBoundingBox().expandTowards(maxDistanceDirection), entity -> !entity.isInvisibleTo(player) && !BeeAggression.isBeelikeEntity(entity), (float)0.25f);
                    if (entityHitResult != null && entityHitResult.getType() != HitResult.Type.MISS) {
                        finalPos = entityHitResult.getLocation();
                    } else {
                        BlockHitResult hitResult = level.clip(new ClipContext(playerEyePos, finalPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                        if (hitResult instanceof BlockHitResult) {
                            BlockHitResult blockHitResult = hitResult;
                            Vec3 locationClicked = hitResult.getLocation();
                            Vec3 offset = Vec3.atLowerCornerOf((Vec3i)blockHitResult.getDirection().getNormal());
                            if (blockHitResult.getDirection() == Direction.UP) {
                                offset = offset.scale(0.35);
                            } else if (blockHitResult.getDirection() != Direction.DOWN) {
                                offset = offset.scale(0.5);
                            }
                            finalPos = locationClicked.add(offset);
                        }
                    }
                }
                Vec3 finalPos1 = finalPos;
                bees.forEach(bee -> {
                    bee.moveTo(finalPos1.x(), finalPos1.y(), finalPos1.z(), player.getYRot(), player.getXRot());
                    level.addFreshEntity(bee);
                });
                level.playSound(null, player.blockPosition(), (SoundEvent)BzSounds.BUZZING_BRIEFCASE_RELEASES.get(), SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() * 0.2f + 0.6f);
                return new ArrayList<Object>(bees);
            }
        }
        return new ArrayList<Entity>();
    }

    public static List<Entity> getBeesStored(Level level, ItemStack briefcaseItem, boolean removeFromList) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) > 0) {
            CompoundTag briefcaseTag = ((CustomData)briefcaseItem.get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get())).copyTag();
            ListTag beeList = briefcaseTag.getList(TAG_BEES, 10);
            ObjectArrayList beesStored = new ObjectArrayList();
            if (removeFromList) {
                for (int i = beeList.size() - 1; i >= 0; --i) {
                    CompoundTag beeTag = beeList.getCompound(0);
                    beeList.removeFirst();
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)beeTag, (Level)level, entityx -> entityx);
                    if (entity == null) continue;
                    if (entity instanceof VariantBeeEntity) {
                        briefcaseTag.putInt(TAG_VARANT_BEES, Math.max(0, briefcaseTag.getInt(TAG_VARANT_BEES) - 1));
                    }
                    if (!BuzzingBriefcase.addBeeToList((List<Entity>)beesStored, beeTag, entity)) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < beeList.size(); ++i) {
                    CompoundTag beeTag = beeList.getCompound(i);
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)beeTag, (Level)level, entityx -> entityx);
                    if (entity != null) {
                        if (!BuzzingBriefcase.addBeeToList((List<Entity>)beesStored, beeTag, entity)) continue;
                        break;
                    }
                    beeList.remove(i);
                    --i;
                    removeFromList = true;
                }
            }
            if (removeFromList) {
                briefcaseItem.set((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get(), (Object)CustomData.of((CompoundTag)briefcaseTag));
            }
            return beesStored;
        }
        return new ObjectArrayList();
    }

    private static boolean addBeeToList(List<Entity> beesStored, CompoundTag beeTag, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (beeTag.contains("Attributes", 9)) {
                livingEntity.getAttributes().load(beeTag.getList("Attributes", 10));
            }
            if (beeTag.contains("Health", 99)) {
                livingEntity.setHealth(beeTag.getFloat("Health"));
            }
        }
        beesStored.add(entity);
        return beesStored.size() == 14;
    }

    public static Entity getSpecificBeesStored(Level level, ItemStack briefcaseItem, int beeIndex, boolean removeFromList) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) > 0) {
            CompoundTag briefcaseTag = ((CustomData)briefcaseItem.get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get())).copyTag();
            ListTag beeList = briefcaseTag.getList(TAG_BEES, 10);
            if (beeIndex < beeList.size()) {
                Entity entity;
                CompoundTag beeTag = beeList.getCompound(beeIndex);
                if (removeFromList) {
                    beeList.remove(beeIndex);
                }
                if ((entity = EntityType.loadEntityRecursive((CompoundTag)beeTag, (Level)level, entityx -> entityx)) instanceof VariantBeeEntity && removeFromList) {
                    briefcaseTag.putInt(TAG_VARANT_BEES, Math.max(0, briefcaseTag.getInt(TAG_VARANT_BEES) - 1));
                }
                if (removeFromList) {
                    briefcaseItem.set((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get(), (Object)CustomData.of((CompoundTag)briefcaseTag));
                }
                return entity;
            }
            return null;
        }
        return null;
    }

    public static void overrwriteBees(ItemStack briefcaseItem, List<Entity> bees) {
        briefcaseItem.set((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get(), (Object)CustomData.of((CompoundTag)new CompoundTag()));
        bees.forEach(bee -> BuzzingBriefcase.tryAddBee(briefcaseItem, bee));
    }

    public static boolean tryAddBee(ItemStack briefcaseItem, Entity bee) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) < 14) {
            String beeTypeRL = bee.getEncodeId();
            if (beeTypeRL == null) {
                return false;
            }
            CompoundTag briefcaseTag = ((CustomData)briefcaseItem.get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get())).copyTag();
            ListTag beeList = briefcaseTag.getList(TAG_BEES, 10);
            CompoundTag beeTag = new CompoundTag();
            bee.stopRiding();
            bee.ejectPassengers();
            beeTag.putString("id", beeTypeRL);
            bee.saveWithoutId(beeTag);
            UUID uUID = bee.getUUID();
            bee.load(beeTag);
            bee.setUUID(uUID);
            beeTag.remove("UUID");
            beeList.add((Object)beeTag);
            briefcaseTag.put(TAG_BEES, (Tag)beeList);
            bee.discard();
            if (bee instanceof VariantBeeEntity) {
                briefcaseTag.putInt(TAG_VARANT_BEES, briefcaseTag.getInt(TAG_VARANT_BEES) + 1);
            }
            CustomData customData1 = CustomData.of((CompoundTag)briefcaseTag);
            briefcaseItem.set((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get(), (Object)customData1);
            CustomData customData2 = (CustomData)briefcaseItem.get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get());
            return true;
        }
        return false;
    }

    public static int getNumberOfBees(ItemStack briefcaseItem) {
        CompoundTag briefcaseTag = ((CustomData)briefcaseItem.get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get())).copyTag();
        if (briefcaseTag.contains(TAG_BEES)) {
            ListTag beeList = briefcaseTag.getList(TAG_BEES, 10);
            return beeList.size();
        }
        ListTag listTag = new ListTag();
        briefcaseTag.put(TAG_BEES, (Tag)listTag);
        briefcaseItem.set((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get(), (Object)CustomData.of((CompoundTag)briefcaseTag));
        return 0;
    }

    public int getBurnTime(ItemStack briefcaseItem, RecipeType recipeType) {
        return 150 + BuzzingBriefcase.getNumberOfBees(briefcaseItem) * 1500;
    }
}

