/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import com.telepathicgrunt.the_bumblezone.fluids.base.BzFluid;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class SugarWaterFluid
extends BzFluid {
    protected SugarWaterFluid(FluidData properties, boolean source) {
        super(properties, source);
    }

    @Override
    public Fluid getFlowing() {
        return (Fluid)BzFluids.SUGAR_WATER_FLUID_FLOWING.get();
    }

    @Override
    public Fluid getSource() {
        return (Fluid)BzFluids.SUGAR_WATER_FLUID.get();
    }

    @Override
    public Item getBucket() {
        return (Item)BzItems.SUGAR_WATER_BUCKET.get();
    }

    public void randomTick(Level world, BlockPos position, FluidState state, RandomSource random) {
        int startIndex;
        if (random.nextBoolean() || !world.hasChunksAt(position, position)) {
            return;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int currentIndex = startIndex = random.nextInt(4); currentIndex < startIndex + 4; ++currentIndex) {
            int sugarCaneAge;
            int height;
            Direction direction = Direction.from2DDataValue((int)currentIndex);
            blockPos.set((Vec3i)position.above());
            blockPos.move(direction);
            BlockState blockstate = world.getBlockState((BlockPos)blockPos);
            if (blockstate.getBlock() != Blocks.SUGAR_CANE) continue;
            blockstate = world.getBlockState((BlockPos)blockPos.move(Direction.UP));
            for (height = 1; blockstate.getBlock() == Blocks.SUGAR_CANE && height < 5; ++height) {
                blockstate = world.getBlockState((BlockPos)blockPos.move(Direction.UP));
            }
            if (height >= 5) continue;
            BlockState topSugarCane = world.getBlockState(blockPos.below());
            int n = sugarCaneAge = topSugarCane.hasProperty((Property)SugarCaneBlock.AGE) ? (Integer)topSugarCane.getValue((Property)SugarCaneBlock.AGE) : 0;
            if (sugarCaneAge < 15) {
                world.setBlock(blockPos.below(), (BlockState)Blocks.SUGAR_CANE.defaultBlockState().setValue((Property)SugarCaneBlock.AGE, (Comparable)Integer.valueOf(sugarCaneAge + 1)), 3);
                continue;
            }
            if (!blockstate.isAir()) continue;
            world.setBlock((BlockPos)blockPos, Blocks.SUGAR_CANE.defaultBlockState(), 3);
        }
    }

    public void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)pos.getX() + (double)random.nextFloat(), (double)pos.getY() + (double)random.nextFloat(), (double)pos.getZ() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    @Override
    public int getTickDelay(LevelReader world) {
        return 5;
    }

    @Override
    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Override
    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    @Override
    public int getSlopeFindDistance(LevelReader world) {
        return 4;
    }

    @Override
    public int getDropOff(LevelReader world) {
        return 1;
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid.is(BzTags.VISUAL_WATER_FLUID);
    }

    @Override
    public boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.is(FluidTags.WATER);
    }

    @Override
    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(SugarWaterFluid.getLegacyLevel((FluidState)state)));
    }

    public final boolean canHoldFluid(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer = (LiquidBlockContainer)block;
            return liquidBlockContainer.canPlaceLiquid(null, blockGetter, blockPos, blockState, fluid) || ((LiquidBlockContainer)block).canPlaceLiquid(null, blockGetter, blockPos, blockState, (Fluid)(fluid == BzFluids.SUGAR_WATER_FLUID.get() ? Fluids.WATER : Fluids.FLOWING_WATER));
        }
        if (block instanceof DoorBlock || blockState.is(BlockTags.SIGNS) || blockState.is(Blocks.LADDER) || blockState.is(Blocks.SUGAR_CANE) || blockState.is(Blocks.BUBBLE_COLUMN)) {
            return false;
        }
        if (blockState.is(BlockTags.PORTALS) || blockState.is(Blocks.STRUCTURE_VOID) || blockState.is(BlockTags.UNDERWATER_BONEMEALS) || blockState.is(Blocks.KELP) || blockState.is(Blocks.KELP_PLANT)) {
            return false;
        }
        return !blockState.blocksMotion();
    }

    protected void spreadTo(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, Direction direction, FluidState fluidState) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer;
            boolean canPlaceLiquid = (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)levelAccessor, blockPos, blockState, fluidState.getType());
            liquidBlockContainer.placeLiquid(levelAccessor, blockPos, blockState, canPlaceLiquid ? fluidState : Fluids.WATER.defaultFluidState());
        } else {
            if (!blockState.isAir()) {
                this.beforeDestroyingBlock(levelAccessor, blockPos, blockState);
            }
            levelAccessor.setBlock(blockPos, fluidState.createLegacyBlock(), 3);
        }
    }

    public static class Source
    extends SugarWaterFluid {
        public Source(FluidData properties) {
            super(properties, true);
        }

        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }

        @Override
        protected boolean canConvertToSource(Level level) {
            return level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
        }
    }

    public static class Flowing
    extends SugarWaterFluid {
        public Flowing(FluidData properties) {
            super(properties, false);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{BlockStateProperties.LEVEL_FLOWING});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)BlockStateProperties.LEVEL_FLOWING);
        }

        public boolean isSource(FluidState state) {
            return false;
        }

        @Override
        protected boolean canConvertToSource(Level level) {
            return level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
        }
    }
}

