/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.fluids.base.BzFluid;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FlowingFluidAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class HoneyFluid
extends BzFluid {
    protected HoneyFluid(FluidData properties, boolean source) {
        super(properties, source);
    }

    @Override
    public Fluid getFlowing() {
        return (Fluid)BzFluids.HONEY_FLUID_FLOWING.get();
    }

    @Override
    public Fluid getSource() {
        return (Fluid)BzFluids.HONEY_FLUID.get();
    }

    @Override
    public Item getBucket() {
        return (Item)BzItems.HONEY_BUCKET.get();
    }

    public void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        float fluidHeightPercent = Math.min(1.0f, (float)(state.isSource() ? 8 : (Integer)state.getValue((Property)LEVEL)) / 7.0f);
        float fluidBottomOffset = Math.min(1.0f, (float)(state.isSource() ? 0 : (Integer)state.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL)) / 7.0f);
        if (random.nextInt(82) == 0) {
            worldIn.addParticle((ParticleOptions)BzParticles.HONEY_PARTICLE.get(), (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + fluidBottomOffset + random.nextFloat() * (fluidHeightPercent - fluidBottomOffset)), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions getDripParticle() {
        return (ParticleOptions)BzParticles.HONEY_PARTICLE.get();
    }

    @Override
    protected float getExplosionResistance() {
        return 120.0f;
    }

    @Override
    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    @Override
    public int getSlopeFindDistance(LevelReader world) {
        return 4;
    }

    @Override
    public int getDropOff(LevelReader world) {
        return 1;
    }

    @Override
    public int getTickDelay(LevelReader world) {
        return 30;
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid.is(BzTags.VISUAL_HONEY_FLUID);
    }

    @Override
    public boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.is(FluidTags.WATER);
    }

    @Override
    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((LiquidBlock)BzFluids.HONEY_FLUID_BLOCK.get()).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(state.isSource() ? 0 : state.getAmount()))).setValue((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)(state.isSource() ? Integer.valueOf(0) : (Integer)state.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL)))).setValue((Property)FALLING, (Comparable)Boolean.valueOf(!state.isSource() && (Boolean)state.getValue((Property)FALLING) != false))).setValue((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)((Boolean)state.getValue((Property)HoneyFluidBlock.ABOVE_FLUID)));
    }

    public void tick(Level world, BlockPos blockPos, FluidState fluidState) {
        boolean justFilledBottom = false;
        if (!fluidState.isSource()) {
            FluidState newFluidState = this.getNewLiquid(world, blockPos, world.getBlockState(blockPos));
            int spreadDelay = this.getSpreadDelay(world, blockPos, fluidState, newFluidState);
            if (newFluidState.isEmpty()) {
                fluidState = newFluidState;
                world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
            } else if (!newFluidState.equals(fluidState)) {
                if ((Integer)fluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0 && (newFluidState.isSource() || (Integer)newFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0)) {
                    justFilledBottom = true;
                }
                fluidState = newFluidState;
                BlockState blockstate = newFluidState.createLegacyBlock();
                world.setBlock(blockPos, blockstate, 2);
                world.scheduleTick(blockPos, newFluidState.getType(), HoneyFluid.adjustedFlowSpeed(spreadDelay, (LevelAccessor)world, blockPos));
                world.updateNeighborsAt(blockPos, blockstate.getBlock());
            }
        }
        if (!fluidState.isEmpty()) {
            int bottomFluidLevel;
            int n = bottomFluidLevel = fluidState.isSource() ? 0 : (Integer)fluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL);
            if (bottomFluidLevel == 0) {
                BlockState blockState = world.getBlockState(blockPos);
                BlockPos belowBlockPos = blockPos.below();
                BlockState belowBlockState = world.getBlockState(belowBlockPos);
                FluidState belowFluidState = this.getNewLiquid(world, belowBlockPos, belowBlockState);
                if (!belowBlockState.getFluidState().is(BzTags.HONEY_FLUID) && this.canSpreadTo((BlockGetter)world, blockPos, blockState, Direction.DOWN, belowBlockPos, belowBlockState, world.getFluidState(belowBlockPos), belowFluidState.getType())) {
                    if (!justFilledBottom) {
                        this.spreadDown((LevelAccessor)world, belowBlockPos, belowBlockState, Direction.DOWN, belowFluidState);
                        if (((FlowingFluidAccessor)((Object)this)).callSourceNeighborCount((LevelReader)world, blockPos) >= 3) {
                            ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
                        }
                    }
                } else if (fluidState.isSource() || !belowBlockState.getFluidState().getType().isSame((Fluid)this)) {
                    ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
                }
            }
        }
    }

    protected void spread(Level world, BlockPos blockPos, FluidState fluidState) {
        int bottomFluidLevel;
        if (!fluidState.isEmpty() && (bottomFluidLevel = ((Integer)fluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue()) == 0) {
            BlockState blockState = world.getBlockState(blockPos);
            BlockPos belowBlockPos = blockPos.below();
            BlockState belowBlockState = world.getBlockState(belowBlockPos);
            FluidState belowFluidState = this.getNewLiquid(world, belowBlockPos, belowBlockState);
            if (!belowBlockState.getFluidState().is(BzTags.HONEY_FLUID) && this.canSpreadTo((BlockGetter)world, blockPos, blockState, Direction.DOWN, belowBlockPos, belowBlockState, world.getFluidState(belowBlockPos), belowFluidState.getType())) {
                this.spreadDown((LevelAccessor)world, belowBlockPos, belowBlockState, Direction.DOWN, belowFluidState);
                if (((FlowingFluidAccessor)((Object)this)).callSourceNeighborCount((LevelReader)world, blockPos) >= 3) {
                    ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
                }
            } else if (fluidState.isSource() || !belowBlockState.getFluidState().getType().isSame((Fluid)this)) {
                ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
            }
        }
    }

    protected void spreadDown(LevelAccessor world, BlockPos blockPos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (!blockState.isAir()) {
            this.beforeDestroyingBlock(world, blockPos, blockState);
        }
        world.setBlock(blockPos, fluidState.createLegacyBlock(), 3);
    }

    protected FluidState getNewLiquid(Level worldReader, BlockPos blockPos, BlockState blockState) {
        int currentFluidLevel;
        int lowestNeighboringFluidLevel;
        boolean isBzFluidBlock = blockState.hasProperty((Property)HoneyFluidBlock.BOTTOM_LEVEL) && blockState.hasProperty((Property)LiquidBlock.LEVEL);
        int n = lowestNeighboringFluidLevel = isBzFluidBlock ? (Integer)blockState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) : 8;
        int highestNeighboringFluidLevel = currentFluidLevel = isBzFluidBlock ? (blockState.getFluidState().isSource() ? 8 : (Integer)blockState.getFluidState().getValue((Property)LEVEL)) : 0;
        int neighboringFluidSource = 0;
        boolean hasAboveFluid = isBzFluidBlock ? (Boolean)blockState.getValue((Property)HoneyFluidBlock.ABOVE_FLUID) : false;
        BlockPos aboveBlockPos = blockPos.above();
        BlockState aboveBlockState = worldReader.getBlockState(aboveBlockPos);
        BlockState belowBlockState = worldReader.getBlockState(blockPos.below());
        boolean canPassThroughBelow = ((FlowingFluidAccessor)((Object)this)).callCanPassThroughWall(Direction.DOWN, (BlockGetter)worldReader, blockPos, blockState, blockPos.below(), belowBlockState);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos sideBlockPos = blockPos.relative(direction);
            BlockState sideBlockState = worldReader.getBlockState(sideBlockPos);
            FluidState sideFluidState = sideBlockState.getFluidState();
            if (!sideFluidState.getType().isSame((Fluid)this) || !((FlowingFluidAccessor)((Object)this)).callCanPassThroughWall(direction, (BlockGetter)worldReader, blockPos, blockState, sideBlockPos, sideBlockState)) continue;
            if (sideFluidState.isSource()) {
                ++neighboringFluidSource;
            }
            highestNeighboringFluidLevel = Math.max(highestNeighboringFluidLevel, sideFluidState.getAmount());
            if (!sideFluidState.is(BzTags.SPECIAL_HONEY_LIKE) || canPassThroughBelow && !sideFluidState.isSource() && ((Boolean)sideBlockState.getValue((Property)FALLING)).booleanValue() && aboveBlockState.getFluidState().is(BzTags.SPECIAL_HONEY_LIKE)) continue;
            lowestNeighboringFluidLevel = Math.min(lowestNeighboringFluidLevel, sideFluidState.isSource() ? 0 : (Integer)sideFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL));
        }
        FluidState aboveFluidState = aboveBlockState.getFluidState();
        boolean aboveFluidIsThisFluid = !aboveFluidState.isEmpty() && aboveFluidState.getType().isSame((Fluid)this);
        int newBottomFluidLevel = Math.max(lowestNeighboringFluidLevel - 1, 0);
        boolean isFalling = true;
        int newFluidLevel = 8;
        int dropOffValue = this.getDropOff((LevelReader)worldReader);
        if (hasAboveFluid && !aboveFluidIsThisFluid) {
            dropOffValue = 0;
        }
        if (aboveFluidIsThisFluid && ((FlowingFluidAccessor)((Object)this)).callCanPassThroughWall(Direction.UP, (BlockGetter)worldReader, blockPos, blockState, aboveBlockPos, aboveBlockState)) {
            if (!aboveFluidState.isSource() && aboveFluidState.is(BzTags.SPECIAL_HONEY_LIKE) && (Integer)aboveFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0) {
                newFluidLevel = highestNeighboringFluidLevel - dropOffValue;
            }
        } else {
            isFalling = aboveFluidState.isEmpty() && neighboringFluidSource == 0 && highestNeighboringFluidLevel <= currentFluidLevel && canPassThroughBelow;
            newFluidLevel = highestNeighboringFluidLevel - dropOffValue;
        }
        return newFluidLevel <= 0 ? Fluids.EMPTY.defaultFluidState() : (FluidState)((FluidState)this.getFlowing(Math.min(newFluidLevel, 8), isFalling).setValue((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)Integer.valueOf(newBottomFluidLevel))).setValue((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)Boolean.valueOf(aboveFluidIsThisFluid && (aboveFluidState.isSource() || aboveFluidState.is(BzTags.SPECIAL_HONEY_LIKE) && (Integer)aboveFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0)));
    }

    public float getHeight(FluidState fluidState, BlockGetter world, BlockPos blockPos) {
        BlockPos aboveBlockPos = blockPos.above();
        BlockState aboveBlockState = world.getBlockState(aboveBlockPos);
        FluidState aboveFluidState = aboveBlockState.getFluidState();
        boolean aboveFluidIsThisFluid = !aboveFluidState.isEmpty() && aboveFluidState.getType().isSame((Fluid)this) && (aboveFluidState.isSource() || !aboveFluidState.is(BzTags.SPECIAL_HONEY_LIKE) || (Integer)aboveFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0);
        return (Boolean)fluidState.getValue((Property)HoneyFluidBlock.ABOVE_FLUID) != false || aboveFluidIsThisFluid ? 1.0f : fluidState.getOwnHeight();
    }

    public static boolean shouldRenderSide(BlockGetter world, BlockPos blockPos, Direction direction, FluidState currentFluidState) {
        if (direction == Direction.UP) {
            FluidState aboveFluidState = world.getBlockState(blockPos.above()).getFluidState();
            if (aboveFluidState.is(BzTags.SPECIAL_HONEY_LIKE)) {
                return !aboveFluidState.isSource() && (Integer)aboveFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0 || currentFluidState.getAmount() != 8;
            }
        } else {
            if (direction == Direction.DOWN) {
                BlockState belowState = world.getBlockState(blockPos.below());
                FluidState belowFluidState = belowState.getFluidState();
                if (belowFluidState.is(BzTags.SPECIAL_HONEY_LIKE)) {
                    return !currentFluidState.isSource() && (belowFluidState.getAmount() != 8 || (Integer)currentFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0);
                }
                return !currentFluidState.isSource() && (Integer)currentFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0 || !HoneyFluid.isFaceOccludedByNeighbor(world, blockPos, Direction.DOWN, 0.8888889f, belowState);
            }
            FluidState sideFluidState = world.getBlockState(blockPos.relative(direction)).getFluidState();
            if (sideFluidState.is(BzTags.SPECIAL_HONEY_LIKE)) {
                int bottomLayerCurrent = currentFluidState.isSource() ? 0 : (Integer)currentFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL);
                int bottomLayerSide = sideFluidState.isSource() ? 0 : (Integer)sideFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL);
                return bottomLayerCurrent < bottomLayerSide;
            }
        }
        return true;
    }

    private static boolean isFaceOccludedByNeighbor(BlockGetter blockGetter, BlockPos blockPos, Direction direction, float f, BlockState blockState) {
        return HoneyFluid.isFaceOccludedByState(blockGetter, direction, f, blockPos.relative(direction), blockState);
    }

    private static boolean isFaceOccludedByState(BlockGetter blockGetter, Direction direction, float f, BlockPos blockPos, BlockState blockState) {
        if (blockState.canOcclude()) {
            VoxelShape voxelShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)f, (double)1.0);
            VoxelShape voxelShape2 = blockState.getOcclusionShape(blockGetter, blockPos);
            return Shapes.blockOccudes((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (Direction)direction);
        }
        return false;
    }

    public static int adjustedFlowSpeed(int originalSpeed, LevelAccessor level, BlockPos blockPos) {
        return (int)((double)originalSpeed / Math.min(1.75, Math.max(0.75, (double)(((Biome)level.getBiome(blockPos).value()).getBaseTemperature() + 0.2f))));
    }

    public static class Source
    extends HoneyFluid {
        public Source(FluidData properties) {
            super(properties, true);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{HoneyFluidBlock.ABOVE_FLUID});
        }

        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }

        @Override
        protected boolean canConvertToSource(Level level) {
            return false;
        }
    }

    public static class Flowing
    extends HoneyFluid {
        public Flowing(FluidData properties) {
            super(properties, false);
            this.registerDefaultState((FluidState)((FluidState)((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(8))).setValue((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
            builder.add(new Property[]{HoneyFluidBlock.BOTTOM_LEVEL});
            builder.add(new Property[]{HoneyFluidBlock.ABOVE_FLUID});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }

        @Override
        protected boolean canConvertToSource(Level level) {
            return true;
        }
    }
}

