/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.teleportation;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.ServerLevelTickEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class BzWorldSavedData
extends SavedData {
    private static final BzWorldSavedData CLIENT_DUMMY = new BzWorldSavedData();
    private static final BzWorldSavedData SERVER_WIDE = new BzWorldSavedData();
    private static final List<QueuedEntityData> QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE = new ArrayList<QueuedEntityData>();
    private static final List<QueuedEntityData> QUEUED_ENTITIES_TO_GENERIC_TELEPORT = new ArrayList<QueuedEntityData>();
    private static final List<NextTickRunnable> RUNNABLES_FOR_NEXT_TICK = new ArrayList<NextTickRunnable>();

    public static BzWorldSavedData get(Level world) {
        if (!(world instanceof ServerLevel)) {
            return CLIENT_DUMMY;
        }
        return SERVER_WIDE;
    }

    public CompoundTag save(CompoundTag data, HolderLookup.Provider provider) {
        return null;
    }

    public static void queueEntityToTeleport(Entity entity, ResourceKey<Level> destination) {
        if (entity != null && !entity.level().isClientSide() && !BzWorldSavedData.isEntityQueuedToTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.add(new QueuedEntityData(entity, destination));
        }
    }

    public static void queueEntityToGenericTeleport(Entity entity, ResourceKey<Level> destination, BlockPos destinationPos, Runnable runnable) {
        if (entity != null && !entity.level().isClientSide() && !BzWorldSavedData.isEntityQueuedToGenericTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_GENERIC_TELEPORT.add(new QueuedEntityData(entity, destination, destinationPos, runnable));
        }
    }

    public static boolean isEntityQueuedToTeleportAlready(Entity entity) {
        return QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public static boolean isEntityQueuedToGenericTeleportAlready(Entity entity) {
        return QUEUED_ENTITIES_TO_GENERIC_TELEPORT.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public static void worldTick(ServerLevelTickEvent event) {
        if (event.end()) {
            BzWorldSavedData.tick((ServerLevel)event.getLevel());
        }
    }

    public static void tick(ServerLevel world) {
        Entity entity;
        ResourceKey<Level> destinationKey;
        HashSet<Entity> teleportedEntities;
        RUNNABLES_FOR_NEXT_TICK.removeIf(r -> r.executeTick(world));
        if (QUEUED_ENTITIES_TO_GENERIC_TELEPORT.size() > 0) {
            teleportedEntities = new HashSet<Entity>();
            for (QueuedEntityData entry2 : QUEUED_ENTITIES_TO_GENERIC_TELEPORT) {
                destinationKey = entry2.getDestination();
                BlockPos destinationPos = entry2.getDestinationPos();
                entity = entry2.getEntity();
                ServerLevel destination = world.getLevel().getServer().getLevel(destinationKey);
                BzWorldSavedData.baseTeleporting(entity, destinationPos.getCenter(), destination, teleportedEntities, entity);
                entry2.runnable.run();
            }
            QUEUED_ENTITIES_TO_GENERIC_TELEPORT.removeIf(entry -> teleportedEntities.contains(entry.getEntity()));
        }
        if (QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.size() > 0) {
            teleportedEntities = new HashSet();
            for (QueuedEntityData entry2 : QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE) {
                Entity entity2;
                if (!entry2.getIsCurrentTeleporting()) {
                    ServerPlayer serverPlayer;
                    entry2.setIsCurrentTeleporting(true);
                    destinationKey = entry2.getDestination();
                    if (destinationKey.equals(BzDimension.BZ_WORLD_KEY)) {
                        entity = entry2.getEntity();
                        if (entity instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)entity;
                            serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.teleporting_into_bz"), true);
                        }
                        ThreadExecutor.dimensionDestinationSearch(world.getServer(), () -> {
                            try {
                                ServerLevel bumblezoneWorld = world.getServer().getLevel(BzDimension.BZ_WORLD_KEY);
                                return Optional.of(EntityTeleportationBackend.getBzCoordinate(entry2.getEntity(), world, bumblezoneWorld));
                            }
                            catch (Throwable e) {
                                Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:", e);
                                return Optional.empty();
                            }
                        }).thenOnServerThread(entry2::setDestinationPosFound);
                        continue;
                    }
                    entity = entry2.getEntity();
                    if (entity instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)entity;
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.teleporting_out_of_bz"), true);
                    }
                    ThreadExecutor.dimensionDestinationSearch(world.getServer(), () -> {
                        try {
                            ServerLevel destination = world.getLevel().getServer().getLevel(destinationKey);
                            return Optional.of(EntityTeleportationBackend.destPostFromOutOfBoundsTeleport(entry2.getEntity(), destination));
                        }
                        catch (Throwable e) {
                            Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:", e);
                            return Optional.empty();
                        }
                    }).thenOnServerThread(entry2::setDestinationPosFound);
                    continue;
                }
                if (entry2.getDestinationPosFound() == null || teleportedEntities.contains(entity2 = entry2.getEntity())) continue;
                ResourceKey<Level> destinationKey2 = entry2.getDestination();
                ServerLevel destination = world.getLevel().getServer().getLevel(destinationKey2);
                if (entry2.getDestinationPosFound().isPresent()) {
                    Vec3 destinationPos = entry2.getDestinationPosFound().get();
                    if (destinationKey2.equals(BzDimension.BZ_WORLD_KEY)) {
                        BzWorldSavedData.enteringBumblezone(entity2, destinationPos, teleportedEntities);
                        continue;
                    }
                    if (entity2.getControllingPassenger() != null) {
                        BzWorldSavedData.exitingBumblezone((Entity)entity2.getControllingPassenger(), destinationPos, destination, teleportedEntities);
                        continue;
                    }
                    BzWorldSavedData.exitingBumblezone(entity2, destinationPos, destination, teleportedEntities);
                    continue;
                }
                teleportedEntities.add(entity2);
                if (!(entity2 instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.failed_teleporting"), false);
                Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Aborting teleportation. Please retry. Entity: {}-{} Pos: {} Destination: {}", new Object[]{entity2.getClass().getSimpleName(), entity2.getName(), entity2.position(), destinationKey2});
            }
            QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.removeIf(entry -> teleportedEntities.contains(entry.getEntity()));
        }
    }

    public static void enteringBumblezone(Entity entity, Vec3 destinationPosFound, Set<Entity> teleportedEntities) {
        if (!entity.level().isClientSide()) {
            MinecraftServer minecraftServer = entity.getServer();
            ServerLevel bumblezoneWorld = minecraftServer.getLevel(BzDimension.BZ_WORLD_KEY);
            BlockPos blockPos = BlockPos.containing((Position)destinationPosFound);
            if (bumblezoneWorld != null) {
                if (bumblezoneWorld.getBlockState(blockPos.above()).isSuffocating((BlockGetter)bumblezoneWorld, blockPos.above())) {
                    RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(bumblezoneWorld.getGameTime() + 5L, () -> {
                        ServerPlayer fakePlayer = BzWorldSavedData.createSilkTouchFakePlayer(bumblezoneWorld);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos, Blocks.AIR);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.above(), Blocks.AIR);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.below(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.above().above(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.north(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.west(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.east(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.south(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.north().above(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.west().above(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.east().above(), Blocks.HONEYCOMB_BLOCK);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.south().above(), Blocks.HONEYCOMB_BLOCK);
                    }));
                }
                if (BzDimensionConfigs.enableInitialWelcomeMessage && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(bumblezoneWorld.getGameTime() + 20L, () -> ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(playerData -> {
                        if (!playerData.gottenWelcomedInDimension) {
                            playerData.gottenWelcomedInDimension = true;
                            serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.advancement_hint"), false);
                        }
                    })));
                }
            }
            ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM).ifPresent(capability -> {
                capability.setNonBZPos(Optional.of(entity.position()));
                capability.setNonBZDim(entity.level().dimension().location());
                if (bumblezoneWorld == null) {
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer playerEntity = (ServerPlayer)entity;
                        Bumblezone.LOGGER.info("Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                        MutableComponent message = Component.translatable((String)"system.the_bumblezone.missing_dimension", (Object[])new Object[]{Component.translatable((String)"system.the_bumblezone.missing_dimension_link").withStyle(ChatFormatting.RED)});
                        playerEntity.displayClientMessage((Component)message, false);
                    }
                    teleportedEntities.add(entity);
                    return;
                }
                Entity baseVehicle = entity.getRootVehicle();
                BzWorldSavedData.baseTeleporting(entity, destinationPosFound, bumblezoneWorld, teleportedEntities, baseVehicle);
            });
        }
    }

    public static void exitingBumblezone(Entity entity, Vec3 destinationPosition, ServerLevel destination, Set<Entity> teleportedEntities) {
        BlockPos destBlockPos = BlockPos.containing((Position)destinationPosition);
        if (destination.getBlockState(destBlockPos.above()).isSuffocating((BlockGetter)destination, destBlockPos.above())) {
            RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(destination.getGameTime() + 5L, () -> {
                ServerPlayer fakePlayer = BzWorldSavedData.createSilkTouchFakePlayer(destination);
                BzWorldSavedData.destroyAndPlaceBlock(destination, fakePlayer, destBlockPos, Blocks.AIR);
                BzWorldSavedData.destroyAndPlaceBlock(destination, fakePlayer, destBlockPos.above(), Blocks.AIR);
            }));
        }
        Entity baseVehicle = entity.getRootVehicle();
        BzWorldSavedData.baseTeleporting(entity, destinationPosition, destination, teleportedEntities, baseVehicle);
    }

    private static void destroyAndPlaceBlock(ServerLevel level, ServerPlayer fakePlayer, BlockPos blockPos, Block block) {
        BlockState state = level.getBlockState(blockPos);
        BlockEntity blockEntity = state.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
        Block.dropResources((BlockState)state, (Level)level, (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)fakePlayer, (ItemStack)fakePlayer.getMainHandItem());
        level.setBlockAndUpdate(blockPos, block.defaultBlockState());
    }

    private static ServerPlayer createSilkTouchFakePlayer(ServerLevel level) {
        ServerPlayer serverPlayer = PlatformHooks.getFakePlayer(level, null);
        ItemStack fakeHandItem = Items.STONE_PICKAXE.getDefaultInstance();
        ItemEnchantments.Mutable mutableItemEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        mutableItemEnchantments.set(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, (Level)level), 1);
        fakeHandItem.set(DataComponents.ENCHANTMENTS, (Object)mutableItemEnchantments.toImmutable());
        serverPlayer.setItemInHand(InteractionHand.MAIN_HAND, fakeHandItem);
        return serverPlayer;
    }

    private static void baseTeleporting(Entity entity, Vec3 destinationPosition, ServerLevel destination, Set<Entity> teleportedEntities, Entity baseVehicle) {
        BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, destination, destinationPosition, teleportedEntities);
        ((ServerLevel)entity.level()).resetEmptyTime();
        destination.resetEmptyTime();
    }

    private static void teleportEntityAndAssignToVehicle(Entity entity, Entity vehicle, ServerLevel destination, Vec3 destinationPosition, Set<Entity> teleportedEntities) {
        Entity teleportedEntity;
        List passengers = entity.getPassengers();
        entity.ejectPassengers();
        entity.setPortalCooldown();
        if (destination.dimension().equals(BzDimension.BZ_WORLD_KEY)) {
            ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM).ifPresent(capability -> {
                capability.setNonBZPos(Optional.of(entity.position()));
                capability.setNonBZDim(entity.level().dimension().location());
            });
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.isSleeping()) {
                serverPlayer.stopSleepInBed(true, true);
            }
            if (PlatformHooks.isDimensionAllowed(serverPlayer, (ResourceKey<Level>)destination.dimension())) {
                serverPlayer.connection.send((Packet)new ClientboundRespawnPacket(new CommonPlayerSpawnInfo(destination.dimensionTypeRegistration(), destination.dimension(), BiomeManager.obfuscateSeed((long)destination.getSeed()), serverPlayer.gameMode.getGameModeForPlayer(), serverPlayer.gameMode.getPreviousGameModeForPlayer(), destination.isDebug(), destination.isFlat(), serverPlayer.getLastDeathLocation(), serverPlayer.getPortalCooldown()), 3));
                serverPlayer.teleportTo(destination, destinationPosition.x, destinationPosition.y + (double)0.1f, destinationPosition.z, serverPlayer.getYRot(), serverPlayer.getXRot());
                serverPlayer.connection.send((Packet)new ClientboundChangeDifficultyPacket(destination.getDifficulty(), destination.getLevelData().isDifficultyLocked()));
                serverPlayer.connection.send((Packet)new ClientboundSetExperiencePacket(serverPlayer.experienceProgress, serverPlayer.totalExperience, serverPlayer.experienceLevel));
                serverPlayer.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.getAbilities()));
                serverPlayer.server.getPlayerList().sendActivePlayerEffects(serverPlayer);
                serverPlayer.server.getPlayerList().sendLevelInfo(serverPlayer, destination);
                serverPlayer.server.getPlayerList().sendPlayerPermissionLevel(serverPlayer);
                serverPlayer.setPortalCooldown(100);
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 20, 1, false, false, false));
                serverPlayer.server.getPlayerList().sendAllPlayerInfo(serverPlayer);
                teleportedEntity = destination.getPlayerByUUID(serverPlayer.getUUID());
            } else {
                teleportedEntity = null;
            }
        } else {
            Entity newEntity = entity;
            if ((newEntity = newEntity.getType().create((Level)destination)) == null) {
                return;
            }
            newEntity.restoreFrom(entity);
            newEntity.moveTo(destinationPosition.x, destinationPosition.y, destinationPosition.z, entity.getYRot(), entity.getXRot());
            newEntity.setPortalCooldown(100);
            destination.addDuringTeleport(newEntity);
            teleportedEntity = newEntity;
            entity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        teleportedEntities.add(entity);
        if (teleportedEntity != null) {
            ChunkPos chunkpos = new ChunkPos(BlockPos.containing((double)destinationPosition.x, (double)destinationPosition.y, (double)destinationPosition.z));
            destination.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)entity.getId());
            if (vehicle != null) {
                teleportedEntity.startRiding(vehicle);
            }
            passengers.forEach(passenger -> BzWorldSavedData.teleportEntityAndAssignToVehicle(passenger, teleportedEntity, destination, destinationPosition, teleportedEntities));
        }
    }

    private static final class QueuedEntityData {
        private final Entity entity;
        private final ResourceKey<Level> destination;
        private final BlockPos destinationPos;
        private final Runnable runnable;
        private boolean isCurrentTeleporting = false;
        private Optional<Vec3> destinationPosFound = null;

        public QueuedEntityData(Entity entity, ResourceKey<Level> destination) {
            this.entity = entity;
            this.destination = destination;
            this.destinationPos = null;
            this.runnable = null;
        }

        public QueuedEntityData(Entity entity, ResourceKey<Level> destination, BlockPos destinationPos, Runnable runnable) {
            this.entity = entity;
            this.destination = destination;
            this.destinationPos = destinationPos;
            this.runnable = runnable;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public ResourceKey<Level> getDestination() {
            return this.destination;
        }

        public BlockPos getDestinationPos() {
            return this.destinationPos;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public Optional<Vec3> getDestinationPosFound() {
            return this.destinationPosFound;
        }

        public void setDestinationPosFound(Optional<Vec3> destinationPosFound) {
            this.destinationPosFound = destinationPosFound;
        }

        public boolean getIsCurrentTeleporting() {
            return this.isCurrentTeleporting;
        }

        public void setIsCurrentTeleporting(boolean isCurrentTeleporting) {
            this.isCurrentTeleporting = isCurrentTeleporting;
        }
    }

    private record NextTickRunnable(long targetTick, Runnable runnable) {
        public boolean executeTick(ServerLevel serverLevel) {
            if (serverLevel.getGameTime() >= this.targetTick()) {
                this.runnable.run();
                return true;
            }
            return false;
        }
    }
}

