/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminState;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.SentryWatcherSpawnEgg;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.LivingEntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SentryWatcherEntity
extends Entity
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_ID_ACTIVATED = SynchedEntityData.defineId(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ID_SHAKING = SynchedEntityData.defineId(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ID_NO_AI = SynchedEntityData.defineId(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Direction> DATA_ID_TARGET_FACING = SynchedEntityData.defineId(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER = SynchedEntityData.defineId(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public float xxa;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    private int shakingTime = 0;
    private Direction targetFacing;
    private boolean explosionPrimed = false;
    private boolean quarterTurns = false;
    private boolean prevShaking;
    private int shakeStartTick;
    private Vec3 prevVelocity;
    private Vec3 activatedStart;
    private int lastRightClicked = -100;
    private static final int MAX_CHARGING_DISTANCE = 80;
    private static final int SIGHT_RANGE = 36;
    private static final int UNABLE_TO_DESTROY_TOTAL_BLOCK_HARDNESS = 20;
    private static final float MAX_STEP_UP = 0.75f;
    private static final float ROTATION_SPEED = 1.5f;
    private static final float ACCELERATION_FLUID = 0.95f;
    private static final float ACCELERATION_GRAVITY = 0.98f;
    private static final float MAX_SPEED_CAP = 2.0f;

    public SentryWatcherEntity(Level worldIn) {
        super((EntityType)BzEntities.SENTRY_WATCHER.get(), worldIn);
        this.noCulling = true;
    }

    public SentryWatcherEntity(EntityType<? extends SentryWatcherEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public int getShakingTime() {
        return this.shakingTime;
    }

    public void setShakingTime(int shakingTime) {
        this.shakingTime = shakingTime;
    }

    public Direction getTargetFacing() {
        if (this.targetFacing == null) {
            this.targetFacing = this.getDirection();
        }
        return this.targetFacing;
    }

    public void setTargetFacing(Direction targetFacing) {
        this.targetFacing = targetFacing;
        this.setTargetFacingForSync();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_ACTIVATED, (Object)false);
        builder.define(DATA_ID_SHAKING, (Object)false);
        builder.define(DATA_ID_NO_AI, (Object)false);
        builder.define(DATA_ID_TARGET_FACING, (Object)this.getTargetFacing());
        builder.define(DATA_ID_OWNER, Optional.empty());
    }

    public boolean hasActivated() {
        return (Boolean)this.entityData.get(DATA_ID_ACTIVATED);
    }

    protected void setHasActivated(boolean activated) {
        this.entityData.set(DATA_ID_ACTIVATED, (Object)activated);
    }

    public boolean hasShaking() {
        return (Boolean)this.entityData.get(DATA_ID_SHAKING);
    }

    protected void setHasShaking(boolean isShaking) {
        this.entityData.set(DATA_ID_SHAKING, (Object)isShaking);
    }

    public boolean hasNoAI() {
        return (Boolean)this.entityData.get(DATA_ID_NO_AI);
    }

    protected void setNoAI(boolean noAI) {
        this.entityData.set(DATA_ID_NO_AI, (Object)noAI);
    }

    public Direction getTargetFacingFromSync() {
        return (Direction)this.entityData.get(DATA_ID_TARGET_FACING);
    }

    public void setTargetFacingForSync() {
        this.entityData.set(DATA_ID_TARGET_FACING, (Object)this.getTargetFacing());
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.entityData.get(DATA_ID_OWNER);
    }

    public void setOwner(Optional<UUID> owner) {
        this.entityData.set(DATA_ID_OWNER, owner);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        this.refreshDimensions();
        if (this.isInWater() && this.random.nextInt(20) == 0) {
            this.doWaterSplashEffect();
        }
        super.onSyncedDataUpdated(key);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putBoolean("explosionPrimed", this.explosionPrimed);
        compoundTag.putBoolean("quarterTurns", this.quarterTurns);
        if (this.activatedStart != null) {
            compoundTag.putDouble("activatedStartX", this.activatedStart.x());
            compoundTag.putDouble("activatedStartZ", this.activatedStart.z());
        }
        compoundTag.putBoolean("activated", this.hasActivated());
        compoundTag.putBoolean("shaking", this.hasShaking());
        compoundTag.putInt("shakingTime", this.getShakingTime());
        String targetFacingName = this.getTargetFacing().getName();
        compoundTag.putString("targetFacing", targetFacingName);
        if (compoundTag.contains("noAi")) {
            compoundTag.putBoolean("noAi", this.hasNoAI());
        } else if (compoundTag.contains("noAI")) {
            compoundTag.putBoolean("noAI", this.hasNoAI());
        } else {
            compoundTag.putBoolean("NoAI", this.hasNoAI());
        }
        if (this.getOwner().isPresent()) {
            compoundTag.putUUID("owner", this.getOwner().get());
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.explosionPrimed = compoundTag.getBoolean("explosionPrimed");
        this.quarterTurns = compoundTag.getBoolean("quarterTurns");
        this.activatedStart = new Vec3(compoundTag.getDouble("activatedStartX"), 0.0, compoundTag.getDouble("activatedStartZ"));
        this.setHasActivated(compoundTag.getBoolean("activated"));
        this.setHasShaking(compoundTag.getBoolean("shaking"));
        this.setShakingTime(compoundTag.getInt("shakingTime"));
        this.setHasShaking(this.getShakingTime() > 0);
        String targetFacingName = compoundTag.getString("targetFacing");
        Direction targetDirection = Direction.byName((String)targetFacingName);
        this.setTargetFacing(targetDirection);
        this.setNoAI(compoundTag.getBoolean("NoAI") || compoundTag.getBoolean("noAI") || compoundTag.getBoolean("noAi"));
        if (compoundTag.contains("owner")) {
            this.setOwner(Optional.of(compoundTag.getUUID("owner")));
        }
    }

    public void remove(Entity.RemovalReason removalReason) {
        super.remove(removalReason);
        if (this.explosionPrimed && !this.level().isClientSide() && removalReason == Entity.RemovalReason.KILLED) {
            this.largeExplosion();
        }
    }

    private void largeExplosion() {
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 6.0f, Level.ExplosionInteraction.MOB);
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 9.0f, Level.ExplosionInteraction.MOB);
    }

    public boolean isSpectator() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    public ItemStack getPickResult() {
        return ((Item)BzItems.SENTRY_WATCHER_SPAWN_EGG.get()).getDefaultInstance();
    }

    public void refreshDimensions() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        super.refreshDimensions();
        this.absMoveTo(x, y, z);
    }

    public float rotate(Rotation rotation) {
        this.setTargetFacing(rotation.rotate(this.getTargetFacing()));
        float f = Mth.wrapDegrees((float)this.getYRot());
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> f + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> f + 270.0f;
            case Rotation.CLOCKWISE_90 -> f + 90.0f;
            default -> f;
        };
    }

    public float mirror(Mirror mirror) {
        this.setTargetFacing(mirror.mirror(this.getTargetFacing()));
        float f = Mth.wrapDegrees((float)this.getYRot());
        return switch (mirror) {
            case Mirror.FRONT_BACK -> -f;
            case Mirror.LEFT_RIGHT -> 180.0f - f;
            default -> f;
        };
    }

    public boolean causeFallDamage(float f, float g, DamageSource arg) {
        if ((double)f > 1.5) {
            this.playSound(SoundEvents.GENERIC_BIG_FALL, 1.0f, 0.5f);
            this.playBlockFallSound();
            return true;
        }
        return false;
    }

    protected void playBlockFallSound() {
        if (!this.isSilent()) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)(this.getY() - (double)0.2f));
            int k = Mth.floor((double)this.getZ());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.level().getBlockState(pos);
            if (!blockstate.isAir()) {
                SoundType soundtype = blockstate.getSoundType();
                this.playSound(soundtype.getFallSound(), soundtype.getVolume() * 0.5f, soundtype.getPitch() * 0.75f);
            }
        }
    }

    public boolean isPushable() {
        return false;
    }

    public float getFluidSpeed() {
        return 0.95f;
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagKey, double d) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AABB aABB = this.getBoundingBox().deflate(0.001);
        int i = Mth.floor((double)aABB.minX);
        int j = Mth.ceil((double)aABB.maxX);
        int k = Mth.floor((double)aABB.minY);
        int l = Mth.ceil((double)aABB.maxY);
        int m = Mth.floor((double)aABB.minZ);
        int n = Mth.ceil((double)aABB.maxZ);
        double e = 0.0;
        boolean bl2 = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int p = i; p < j; ++p) {
            for (int q = k; q < l; ++q) {
                for (int r = m; r < n; ++r) {
                    double f;
                    mutableBlockPos.set(p, q, r);
                    FluidState fluidState = this.level().getFluidState((BlockPos)mutableBlockPos);
                    if (!fluidState.is(tagKey) || !((f = (double)((float)q + fluidState.getHeight((BlockGetter)this.level(), (BlockPos)mutableBlockPos))) >= aABB.minY)) continue;
                    bl2 = true;
                    e = Math.max(f - aABB.minY, e);
                }
            }
        }
        this.fluidHeight.put(tagKey, e);
        return bl2;
    }

    public boolean canCollideWith(Entity entity) {
        RootminEntity rootminEntity;
        if (entity instanceof RootminEntity && (rootminEntity = (RootminEntity)entity).getRootminPose() == RootminState.ENTITY_TO_BLOCK) {
            return false;
        }
        return entity.canBeCollidedWith() && !this.isPassengerOfSameVehicle(entity);
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (player != null && interactionHand == InteractionHand.MAIN_HAND && this.getOwner().isPresent() && (this.getOwner().get().equals(player.getUUID()) || this.getOwner().get().equals(SentryWatcherSpawnEgg.DISPENSER_OWNER_UUID))) {
            if (this.tickCount - this.lastRightClicked < 40) {
                GeneralUtils.givePlayerItem(player, interactionHand, ((Item)BzItems.SENTRY_WATCHER_SPAWN_EGG.get()).getDefaultInstance(), false, false);
                this.remove(Entity.RemovalReason.DISCARDED);
            } else {
                this.lastRightClicked = this.tickCount;
                this.setHasShaking(true);
                this.setShakingTime(40);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void tick() {
        super.tick();
        if (!this.isRemoved()) {
            this.aiStep();
        }
        if (this.hasActivated() && this.activatedStart != null && Math.abs(this.position().horizontalDistance() - this.activatedStart.horizontalDistance()) > 80.0) {
            this.deactivate();
        }
        this.level().getProfiler().push("rangeChecks");
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        this.level().getProfiler().pop();
    }

    public void travel() {
        if (this.isControlledByLocalInstance()) {
            boolean isFalling;
            double gravityModifier = 0.08;
            boolean bl = isFalling = this.getDeltaMovement().y <= 0.0;
            if (this.isInWater() || this.isInLava()) {
                double e = this.getY();
                float speed = this.getFluidSpeed();
                float g = 0.02f;
                float h = 0.0f;
                if (!this.onGround()) {
                    h *= 0.5f;
                }
                if (h > 0.0f) {
                    speed += (0.54600006f - speed) * h / 3.0f;
                    g += (this.getFluidSpeed() - g) * h / 3.0f;
                }
                this.moveRelative(g, Vec3.ZERO);
                this.move(MoverType.SELF, this.getDeltaMovement());
                Vec3 vec32 = this.getDeltaMovement();
                this.setDeltaMovement(vec32.multiply((double)speed, (double)0.8f, (double)speed));
                Vec3 vec33 = this.getFluidFallingAdjustedMovement(gravityModifier, isFalling, this.getDeltaMovement());
                this.setDeltaMovement(vec33);
                if (this.horizontalCollision && this.isFree(vec33.x, vec33.y + (double)0.6f - this.getY() + e, vec33.z)) {
                    this.setDeltaMovement(vec33.x, 0.3f, vec33.z);
                }
            } else {
                BlockPos blockPos = this.getBlockPosBelowThatAffectsMyMovement();
                Vec3 vec37 = this.handleRelativeFrictionAndCalculateMovement();
                double ySpeed = vec37.y;
                if (this.level().isClientSide && !this.level().hasChunkAt(blockPos)) {
                    ySpeed = this.getY() > (double)this.level().getMinBuildHeight() ? -0.1 : 0.0;
                } else if (!this.isNoGravity()) {
                    ySpeed -= gravityModifier;
                }
                this.setDeltaMovement(vec37.x, ySpeed * (double)0.98f, vec37.z);
            }
        } else if (this.level().isClientSide()) {
            if (this.hasActivated() && this.onGround() && (Math.abs(this.getDeltaMovement().x()) > 0.001 || Math.abs(this.getDeltaMovement().z()) > 0.001)) {
                int particlesToSpawn = (int)(1.0 + Math.abs(this.getDeltaMovement().x() * 50.0) + Math.abs(this.getDeltaMovement().z() + 50.0));
                for (int i = 0; i < particlesToSpawn; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.position().x() + this.random.nextGaussian() * 0.6, this.position().y() + this.random.nextGaussian() * 0.1 + 0.2, this.position().z() + this.random.nextGaussian() * 0.6, this.random.nextGaussian() * 0.01 + 0.01, this.random.nextGaussian() * 0.01 + 0.01, this.random.nextGaussian() * 0.01 + 0.01);
                }
            }
            if (this.hasShaking() && (!this.prevShaking || (this.tickCount - this.shakeStartTick) % 10 == 0)) {
                this.level().playLocalSound(this.blockPosition(), (SoundEvent)BzSounds.SENTRY_WATCHER_ACTIVATING.get(), SoundSource.NEUTRAL, 2.5f, 1.0f, false);
            } else if (this.hasActivated() && !this.hasShaking() && this.tickCount % 10 == 0) {
                this.level().playLocalSound(this.blockPosition(), (SoundEvent)BzSounds.SENTRY_WATCHER_MOVING.get(), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
            }
            if (!this.prevShaking && this.hasShaking()) {
                this.shakeStartTick = this.tickCount;
            }
            this.prevShaking = this.hasShaking();
        }
        double xSpeed = this.getDeltaMovement().x();
        double zSpeed = this.getDeltaMovement().z();
        this.setDeltaMovement(GeneralUtils.capBetween(xSpeed, -2.0, 2.0), this.getDeltaMovement().y(), GeneralUtils.capBetween(zSpeed, -2.0, 2.0));
        this.pushEntities();
    }

    protected void serverAiStep() {
        ServerLevel serverLevel;
        StructureStart structureStart;
        Level newX2;
        Vec3 offset;
        if (this.getShakingTime() > 0) {
            this.setShakingTime(this.getShakingTime() - 1);
            if (this.getShakingTime() <= 0) {
                this.setHasShaking(false);
            }
        }
        if (this.hasActivated()) {
            if (this.horizontalCollision && this.getDeltaMovement().horizontalDistance() < (double)1.0E-4f) {
                this.deactivate();
                double pastSpeed = this.prevVelocity.horizontalDistance();
                if (pastSpeed > 0.01) {
                    List list = this.level().getEntities((Entity)this, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this));
                    for (Entity entity : list) {
                        if (entity.getType().is(BzTags.SENTRY_WATCHER_CANNOT_DAMAGE)) continue;
                        entity.hurt(this.level().damageSources().source(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (Entity)this), 1.0f);
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        float oldHealth = livingEntity.getHealth();
                        float maxhealth = Math.max(livingEntity.getHealth(), livingEntity.getMaxHealth());
                        double healthToLose = Mth.clampedLerp((double)(maxhealth / 3.0f), (double)(maxhealth - 1.0f), (double)(pastSpeed - 0.2));
                        double possibleNewHealth = (double)oldHealth - healthToLose;
                        double newHealth = Math.max(possibleNewHealth, 1.0);
                        livingEntity.setHealth((float)newHealth);
                        if (!(livingEntity instanceof Player)) continue;
                        Player player = (Player)livingEntity;
                        double armorDamage = Mth.clampedLerp((double)1.0, (double)8.0, (double)(pastSpeed - 0.2));
                        ((LivingEntityAccessor)player).callHurtArmor(this.level().damageSources().source(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (Entity)this), (float)armorDamage);
                    }
                }
            } else if (!this.hasNoAI() && this.getShakingTime() <= 0) {
                Vec3 currentVelocity = this.getDeltaMovement();
                double newX2 = currentVelocity.x();
                double newY = currentVelocity.y();
                double newZ = currentVelocity.z();
                Direction currentDirection = this.getTargetFacing();
                if (currentDirection.getStepX() != 0) {
                    newX2 += (double)((float)currentDirection.getStepX() / 200.0f);
                    newX2 *= 1.05;
                } else if (currentDirection.getStepZ() != 0) {
                    newZ += (double)((float)currentDirection.getStepZ() / 200.0f);
                    newZ *= 1.05;
                }
                this.setDeltaMovement(newX2, newY, newZ);
            }
        } else if (!this.hasNoAI() && this.tickCount % 10 == 0 && this.getYRot() == this.getTargetFacing().toYRot() && !this.scanAndBeginActivationIfEnemyFound(offset = Vec3.atLowerCornerOf((Vec3i)Rotation.CLOCKWISE_90.rotate(this.getTargetFacing()).getNormal()).scale(0.5))) {
            this.scanAndBeginActivationIfEnemyFound(offset.scale(-1.0));
        }
        if (!this.hasNoAI() && this.explosionPrimed && this.tickCount % 20 == 0 && (newX2 = this.level()) instanceof ServerLevel && ((structureStart = (serverLevel = (ServerLevel)newX2).structureManager().getStructureWithPieceAt(this.blockPosition(), BzTags.SEMPITERNAL_SANCTUMS)) == null || !structureStart.isValid())) {
            this.kill();
        }
    }

    private boolean scanAndBeginActivationIfEnemyFound(Vec3 offset) {
        Vec3 eyePosition = this.getEyePosition().add(offset);
        Vec3 finalPos = eyePosition.add(Vec3.atLowerCornerOf((Vec3i)this.getTargetFacing().getNormal().multiply(36)));
        AABB boundsForChecking = this.getBoundingBox().inflate(36.0);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)eyePosition, (Vec3)finalPos, (AABB)boundsForChecking, this::canSeeEntity);
        if (entityHitResult != null) {
            this.setHasActivated(true);
            this.setShakingTime(40);
            this.setHasShaking(true);
            this.activatedStart = this.position();
            return true;
        }
        finalPos = this.position().add(0.0, 0.1, 0.0).add(Vec3.atLowerCornerOf((Vec3i)this.getTargetFacing().getNormal().multiply(36)));
        boundsForChecking = this.getBoundingBox().inflate(36.0);
        EntityHitResult entityHitResult2 = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)eyePosition, (Vec3)finalPos, (AABB)boundsForChecking, this::canSeeEntity);
        if (entityHitResult2 != null) {
            this.setHasActivated(true);
            this.setShakingTime(40);
            this.setHasShaking(true);
            this.activatedStart = this.position();
            return true;
        }
        return false;
    }

    private void deactivate() {
        this.setHasActivated(false);
        if (this.quarterTurns) {
            this.setTargetFacing(this.getTargetFacing().getCounterClockWise());
        } else {
            this.setTargetFacing(this.getTargetFacing().getOpposite());
        }
        this.setDeltaMovement(0.0, this.getDeltaMovement().y(), 0.0);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 0.2, this.getZ(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX(), this.getY() + 0.5, this.getZ(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY() + 1.0, this.getZ(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.playSound((Entity)this, this.blockPosition(), (SoundEvent)BzSounds.SENTRY_WATCHER_CRASH.get(), SoundSource.NEUTRAL, 2.5f, 1.0f);
        }
    }

    private boolean canSeeEntity(Entity entity) {
        Player player;
        if (entity.getType().is(BzTags.SENTRY_WATCHER_FORCED_NEVER_ACTIVATES_WHEN_SEEN) || entity.isSpectator()) {
            return false;
        }
        if (entity.getType().is(BzTags.SENTRY_WATCHER_ACTIVATES_WHEN_SEEN)) {
            return true;
        }
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.getUUID().equals(this.getOwner().orElse(null)))) {
            return false;
        }
        return entity instanceof LivingEntity && !BeeAggression.isBeelikeEntity(entity);
    }

    public void aiStep() {
        if (this.hasNoAI()) {
            return;
        }
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            double d = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double e = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double f = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double g = Mth.wrapDegrees((double)(this.lerpYRot - (double)this.getYRot()));
            this.setYRot(this.getYRot() + (float)g / (float)this.lerpSteps);
            this.setXRot(this.getXRot() + (float)(this.lerpXRot - (double)this.getXRot()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.setPos(d, e, f);
            this.setRot(this.getYRot(), this.getXRot());
        }
        this.turnToTargetFacing();
        Vec3 vec3 = this.getDeltaMovement();
        double newX = vec3.x;
        double newY = vec3.y;
        double newZ = vec3.z;
        if (Math.abs(vec3.x) < 0.003) {
            newX = 0.0;
        }
        if (Math.abs(vec3.y) < 0.003) {
            newY = 0.0;
        }
        if (Math.abs(vec3.z) < 0.003) {
            newZ = 0.0;
        }
        this.setDeltaMovement(newX, newY, newZ);
        this.level().getProfiler().push("ai");
        if (this.isImmobile()) {
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi()) {
            this.level().getProfiler().push("newAi");
            this.serverAiStep();
            this.level().getProfiler().pop();
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("travel");
        this.travel();
        this.level().getProfiler().pop();
        this.level().getProfiler().push("freezing");
        if (!this.level().isClientSide) {
            int m = this.getTicksFrozen();
            if (this.isInPowderSnow && this.canFreeze()) {
                this.setTicksFrozen(Math.min(this.getTicksRequiredToFreeze(), m + 1));
            } else {
                this.setTicksFrozen(Math.max(0, m - 2));
            }
        }
        this.level().getProfiler().pop();
    }

    private void turnToTargetFacing() {
        if (!this.hasNoAI() && !this.hasActivated() && this.getYRot() != this.getTargetFacingFromSync().toYRot()) {
            double newYDiff;
            double newY;
            double targetY = this.getTargetFacing().toYRot();
            double currentY = this.getYRot();
            double diff = targetY - currentY;
            double diff2 = targetY - (currentY + 360.0);
            double diffToUse = diff;
            if (Math.abs(diff) > Math.abs(diff2)) {
                diffToUse = diff2;
            }
            if ((newY = currentY + (newYDiff = Math.max(Math.min(diffToUse, 1.5), -1.5))) < 0.0) {
                newY += 360.0;
            } else if (newY >= 360.0) {
                newY -= 360.0;
            }
            this.setYRot((float)newY);
            if (this.tickCount % 20 == 0) {
                this.level().playLocalSound(this.blockPosition(), (SoundEvent)BzSounds.SENTRY_WATCHER_MOVING.get(), SoundSource.NEUTRAL, 0.4f, 0.2f, false);
            }
        }
    }

    protected void pushEntities() {
        if (this.level().isClientSide()) {
            this.level().getEntities(EntityTypeTest.forClass(Player.class), this.getBoundingBox(), EntitySelector.pushableBy((Entity)this)).forEach(this::doPush);
        } else {
            List list = this.level().getEntities((Entity)this, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this));
            if (!list.isEmpty()) {
                int j;
                int i = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
                if (i > 0 && list.size() > i - 1 && this.random.nextInt(4) == 0) {
                    j = 0;
                    for (Entity entity : list) {
                        if (entity.isPassenger()) continue;
                        ++j;
                    }
                }
                for (j = 0; j < list.size(); ++j) {
                    Entity entity = (Entity)list.get(j);
                    this.doPush(entity);
                }
            }
        }
    }

    protected void doPush(Entity entity) {
        if (entity instanceof LivingEntity) {
            double speedDiff;
            Vec3 currentVelocity = this.getDeltaMovement();
            Vec3 victimVelocity = entity.getDeltaMovement();
            Vec3 diffVelocity = currentVelocity.subtract(victimVelocity);
            double d = speedDiff = this.getTargetFacing().getStepX() != 0 ? Math.abs(diffVelocity.x()) : Math.abs(diffVelocity.z());
            if (speedDiff > 0.2) {
                speedDiff -= 0.1;
                double pushEffect = 1.1;
                entity.setDeltaMovement(0.0, entity.getDeltaMovement().y(), 0.0);
                entity.push(this.getDeltaMovement().x() * pushEffect, 0.0, this.getDeltaMovement().z() * pushEffect);
                AABB sentryBounds = this.getBoundingBox();
                Vec3 pushToSpot = entity.position();
                switch (this.getTargetFacing()) {
                    case NORTH: {
                        pushToSpot = new Vec3(pushToSpot.x(), pushToSpot.y(), sentryBounds.minZ);
                        break;
                    }
                    case SOUTH: {
                        pushToSpot = new Vec3(pushToSpot.x(), pushToSpot.y(), sentryBounds.maxZ);
                        break;
                    }
                    case WEST: {
                        pushToSpot = new Vec3(sentryBounds.minX, pushToSpot.y(), pushToSpot.z());
                        break;
                    }
                    case EAST: {
                        pushToSpot = new Vec3(sentryBounds.maxX, pushToSpot.y(), pushToSpot.z());
                    }
                }
                entity.setPos(pushToSpot);
                if (!this.level().isClientSide() && !entity.getType().is(BzTags.SENTRY_WATCHER_CANNOT_DAMAGE)) {
                    ServerPlayer serverPlayer;
                    float damageMultiplier = 30.0f;
                    if (entity instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity)) {
                        damageMultiplier = 16.0f;
                    }
                    int beeArmorOn = BeeArmor.getBeeThemedWearablesCount(entity);
                    entity.hurt(this.level().damageSources().source(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (Entity)this), (float)(speedDiff * (double)(damageMultiplier -= (float)beeArmorOn * 1.333333f)));
                }
            } else {
                super.push(entity);
            }
        } else if (entity instanceof SentryWatcherEntity) {
            this.deactivate();
        } else {
            super.push(entity);
        }
    }

    public void push(double d, double e, double f) {
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement() {
        Vec3 deltaMovement = this.getDeltaMovement();
        if (!this.hasActivated()) {
            deltaMovement = deltaMovement.multiply(0.9, 1.0, 0.9);
        }
        this.move(MoverType.SELF, deltaMovement);
        deltaMovement = this.getDeltaMovement();
        if (this.horizontalCollision && this.getBlockStateOn().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow((Entity)this)) {
            deltaMovement = new Vec3(deltaMovement.x, 0.2, deltaMovement.z);
        }
        return deltaMovement;
    }

    public Vec3 getFluidFallingAdjustedMovement(double d, boolean bl, Vec3 vec3) {
        if (!this.isNoGravity() && !this.isSprinting()) {
            double e = bl && Math.abs(vec3.y - 0.005) >= 0.003 && Math.abs(vec3.y - d / 16.0) < 0.003 ? -0.003 : vec3.y - d / 16.0;
            return new Vec3(vec3.x, e, vec3.z);
        }
        return vec3;
    }

    public void move(MoverType moverType, Vec3 vec3) {
        if (this.noPhysics) {
            this.setPos(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
        } else {
            Vec3 collision;
            double d;
            this.wasOnFire = this.isOnFire();
            if (moverType == MoverType.PISTON && (vec3 = this.limitPistonMovement(vec3)).equals((Object)Vec3.ZERO)) {
                return;
            }
            this.level().getProfiler().push("move");
            if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
                vec3 = vec3.multiply(this.stuckSpeedMultiplier);
                this.stuckSpeedMultiplier = Vec3.ZERO;
                this.setDeltaMovement(Vec3.ZERO);
            }
            if ((d = (collision = this.collide(vec3 = this.maybeBackOffFromEdge(vec3, moverType))).lengthSqr()) > 1.0E-7) {
                BlockHitResult blockHitResult;
                if (this.fallDistance != 0.0f && d >= 1.0 && (blockHitResult = this.level().clip(new ClipContext(this.position(), this.position().add(collision), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, (Entity)this))).getType() != HitResult.Type.MISS) {
                    this.resetFallDistance();
                }
                this.setPos(this.getX() + collision.x, this.getY() + collision.y, this.getZ() + collision.z);
            }
            this.level().getProfiler().pop();
            this.level().getProfiler().push("rest");
            this.prevVelocity = vec3;
            boolean loseXSpeed = !Mth.equal((double)vec3.x, (double)collision.x);
            boolean loseZSpeed = !Mth.equal((double)vec3.z, (double)collision.z);
            this.horizontalCollision = loseXSpeed || loseZSpeed;
            this.verticalCollision = vec3.y != collision.y;
            this.verticalCollisionBelow = this.verticalCollision && vec3.y < 0.0;
            Vec3 deltaMovement = this.getDeltaMovement();
            if (this.horizontalCollision && Math.abs(deltaMovement.x()) + Math.abs(deltaMovement.z()) > 0.01) {
                this.destroyBlocksInWay();
            }
            this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(collision) : false;
            this.setOnGroundWithMovement(this.verticalCollisionBelow, collision);
            BlockPos blockPos = this.getOnPosLegacy();
            BlockState blockState = this.level().getBlockState(blockPos);
            this.checkFallDamage(collision.y, this.onGround(), blockState, blockPos);
            if (this.isRemoved()) {
                this.level().getProfiler().pop();
            } else {
                Entity.MovementEmission movementEmission;
                if (this.horizontalCollision) {
                    Vec3 vec33 = this.getDeltaMovement();
                    this.setDeltaMovement(loseXSpeed ? 0.0 : vec33.x, vec33.y, loseZSpeed ? 0.0 : vec33.z);
                }
                Block block = blockState.getBlock();
                if (vec3.y != collision.y) {
                    block.updateEntityAfterFallOn((BlockGetter)this.level(), (Entity)this);
                }
                if (this.onGround()) {
                    block.stepOn(this.level(), blockPos, blockState, (Entity)this);
                }
                if ((movementEmission = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
                    double e = collision.x;
                    double f = collision.y;
                    double g = collision.z;
                    this.flyDist += (float)(collision.length() * 0.6);
                    BlockPos blockPos2 = this.getOnPos();
                    BlockState blockState2 = this.level().getBlockState(blockPos2);
                    this.walkDist += (float)collision.horizontalDistance() * 0.6f;
                    this.moveDist += (float)Math.sqrt(e * e + f * f + g * g) * 0.6f;
                    if (this.moveDist > ((EntityAccessor)((Object)this)).getNextStep() && !blockState2.isAir()) {
                        boolean bl4 = blockPos2.equals((Object)blockPos);
                        boolean bl5 = ((EntityAccessor)((Object)this)).callVibrationAndSoundEffectsFromBlock(blockPos, blockState, movementEmission.emitsSounds(), bl4, vec3);
                        if (!bl4) {
                            bl5 |= ((EntityAccessor)((Object)this)).callVibrationAndSoundEffectsFromBlock(blockPos2, blockState2, false, movementEmission.emitsEvents(), vec3);
                        }
                        if (bl5) {
                            ((EntityAccessor)((Object)this)).setNextStep(this.nextStep());
                        } else if (this.isInWater()) {
                            ((EntityAccessor)((Object)this)).setNextStep(this.nextStep());
                            if (movementEmission.emitsSounds()) {
                                this.waterSwimSound();
                            }
                            if (movementEmission.emitsEvents()) {
                                this.gameEvent((Holder)GameEvent.SWIM);
                            }
                        }
                    } else if (blockState2.isAir()) {
                        this.processFlappingMovement();
                    }
                }
                this.tryCheckInsideBlocks();
                if (this.level().getBlockStatesIfLoaded(this.getBoundingBox().deflate(1.0E-6)).noneMatch(blockStatex -> blockStatex.is(BlockTags.FIRE) || blockStatex.is(Blocks.LAVA))) {
                    if (this.getRemainingFireTicks() <= 0) {
                        this.setRemainingFireTicks(-this.getFireImmuneTicks());
                    }
                    if (this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                        this.playEntityOnFireExtinguishedSound();
                    }
                }
                if (this.isOnFire() && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                    this.setRemainingFireTicks(-this.getFireImmuneTicks());
                }
                this.level().getProfiler().pop();
            }
        }
    }

    private void destroyBlocksInWay() {
        Direction facing = this.getTargetFacing();
        AABB aabb = this.getBoundingBox();
        BlockPos min = null;
        BlockPos max = null;
        double xStep = (double)facing.getStepX() / 3.0;
        double zStep = (double)facing.getStepZ() / 3.0;
        switch (facing) {
            case NORTH: {
                min = new BlockPos((int)Math.floor(aabb.minX + xStep + 1.0E-4), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.minZ + zStep + 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.maxX + xStep - (double)1.0E-4f), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.minZ + zStep + 1.0E-4));
                break;
            }
            case SOUTH: {
                min = new BlockPos((int)Math.floor(aabb.minX + xStep + 1.0E-4), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.maxZ + zStep - 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.maxX + xStep - 1.0E-4), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.maxZ + zStep - 1.0E-4));
                break;
            }
            case WEST: {
                min = new BlockPos((int)Math.floor(aabb.minX + xStep + 1.0E-4), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.minZ + zStep + 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.minX + xStep + 1.0E-4), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.maxZ + zStep - 1.0E-4));
                break;
            }
            case EAST: {
                min = new BlockPos((int)Math.floor(aabb.maxX + xStep - 1.0E-4), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.minZ + zStep + 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.maxX + xStep - 1.0E-4), (int)Math.floor(aabb.minY), (int)Math.floor(aabb.maxZ + zStep - 1.0E-4));
            }
        }
        if (min != null && this.getOwner().isEmpty()) {
            boolean canDemolish = true;
            double totalhardness = 0.0;
            int alwaysDestroyCounter = 0;
            ArrayList<BlockPos> demolishPos = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.betweenClosed(min, max)) {
                BlockState state = this.level().getBlockState(pos);
                VoxelShape blockShape = state.getCollisionShape((BlockGetter)this.level(), pos);
                if ((!blockShape.isEmpty() || state.is(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) && blockShape.max(Direction.Axis.Y) > this.getY() - (double)this.getBlockY()) {
                    if (state.is(BzTags.SENTRY_WATCHER_FORCED_NEVER_DESTROY)) {
                        canDemolish = false;
                        break;
                    }
                    demolishPos.add(pos.immutable());
                    totalhardness += (double)state.getBlock().getExplosionResistance();
                    if (state.is(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) {
                        ++alwaysDestroyCounter;
                    }
                }
                BlockPos abovePos = pos.above();
                BlockState aboveState = this.level().getBlockState(abovePos);
                if (aboveState.getCollisionShape((BlockGetter)this.level(), abovePos).isEmpty() && !aboveState.is(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) continue;
                if (aboveState.is(BzTags.SENTRY_WATCHER_FORCED_NEVER_DESTROY)) {
                    canDemolish = false;
                    break;
                }
                demolishPos.add(abovePos);
                totalhardness += (double)aboveState.getBlock().getExplosionResistance();
                if (!aboveState.is(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) continue;
                ++alwaysDestroyCounter;
            }
            if (canDemolish && (alwaysDestroyCounter == demolishPos.size() || totalhardness < 20.0)) {
                for (BlockPos pos : demolishPos) {
                    this.level().destroyBlock(pos, true);
                }
                this.horizontalCollision = false;
            }
        }
    }

    private Vec3 collide(Vec3 incomingSpeed) {
        boolean zCollided;
        AABB sentryBoundingBox = this.getBoundingBox();
        ArrayList shapesCollidedWith = new ArrayList();
        boolean isNotMoving = incomingSpeed.lengthSqr() == 0.0;
        Vec3 collidedVelocity = isNotMoving ? incomingSpeed : SentryWatcherEntity.collideBoundingBox((Entity)this, (Vec3)incomingSpeed, (AABB)sentryBoundingBox, (Level)this.level(), shapesCollidedWith);
        boolean xCollided = incomingSpeed.x != collidedVelocity.x;
        boolean bl = zCollided = incomingSpeed.z != collidedVelocity.z;
        if (this.maxUpStep() > 0.0f && (xCollided || zCollided)) {
            Vec3 vec35;
            Vec3 vec33 = SentryWatcherEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(incomingSpeed.x, (double)this.maxUpStep(), incomingSpeed.z), (AABB)sentryBoundingBox, (Level)this.level(), shapesCollidedWith);
            Vec3 vec34 = SentryWatcherEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, (double)this.maxUpStep(), 0.0), (AABB)sentryBoundingBox.expandTowards(incomingSpeed.x, 0.0, incomingSpeed.z), (Level)this.level(), shapesCollidedWith);
            if (vec34.y < (double)this.maxUpStep() && (vec35 = SentryWatcherEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(incomingSpeed.x, 0.0, incomingSpeed.z), (AABB)sentryBoundingBox.move(vec34), (Level)this.level(), shapesCollidedWith).add(vec34)).horizontalDistanceSqr() > vec33.horizontalDistanceSqr()) {
                vec33 = vec35;
            }
            if (vec33.horizontalDistanceSqr() > collidedVelocity.horizontalDistanceSqr()) {
                return vec33.add(SentryWatcherEntity.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, -vec33.y + incomingSpeed.y, 0.0), (AABB)sentryBoundingBox.move(vec33), (Level)this.level(), shapesCollidedWith));
            }
        }
        return collidedVelocity;
    }

    public void lerpTo(double d, double e, double f, float g, float h, int i) {
        this.lerpX = d;
        this.lerpY = e;
        this.lerpZ = f;
        this.lerpYRot = g;
        this.lerpXRot = h;
        this.lerpSteps = i;
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    public boolean canChangeDimensions(Level toLevel, Level fromLevel) {
        return false;
    }

    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public float maxUpStep() {
        return 0.75f;
    }

    protected boolean isImmobile() {
        return false;
    }
}

