/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class PurpleSpikeEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> DATA_ID_SPIKE_CHARGE = SynchedEntityData.defineId(PurpleSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ID_SPIKE_ACTIVE = SynchedEntityData.defineId(PurpleSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int spikeChargeTimer = 0;
    public int spikeTimer = 0;
    public boolean spikeChargeClientPhaseTracker = false;
    public int spikeChargeClientTimeTracker = 0;
    private UUID essenceController = null;
    private BlockPos essenceControllerBlockPos = null;
    private ResourceKey<Level> essenceControllerDimension = null;

    public PurpleSpikeEntity(EntityType<? extends PurpleSpikeEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_SPIKE_CHARGE, (Object)(this.spikeChargeTimer > 0 ? 1 : 0));
        builder.define(DATA_ID_SPIKE_ACTIVE, (Object)(this.spikeTimer > 0 ? 1 : 0));
    }

    public UUID getEssenceController() {
        return this.essenceController;
    }

    public void setEssenceController(UUID essenceController) {
        this.essenceController = essenceController;
    }

    public BlockPos getEssenceControllerBlockPos() {
        return this.essenceControllerBlockPos;
    }

    public void setEssenceControllerBlockPos(BlockPos essenceControllerBlockPos) {
        this.essenceControllerBlockPos = essenceControllerBlockPos;
    }

    public ResourceKey<Level> getEssenceControllerDimension() {
        return this.essenceControllerDimension;
    }

    public void setEssenceControllerDimension(ResourceKey<Level> essenceControllerDimension) {
        this.essenceControllerDimension = essenceControllerDimension;
    }

    public boolean hasSpikeCharge() {
        return (Boolean)this.entityData.get(DATA_ID_SPIKE_CHARGE);
    }

    protected void setHasSpikeCharge(boolean hasSpikeCharge) {
        this.entityData.set(DATA_ID_SPIKE_CHARGE, (Object)hasSpikeCharge);
    }

    public boolean hasSpike() {
        return (Boolean)this.entityData.get(DATA_ID_SPIKE_ACTIVE);
    }

    protected void setHasSpike(boolean hasSpike) {
        this.entityData.set(DATA_ID_SPIKE_ACTIVE, (Object)hasSpike);
    }

    public int getSpikeChargeTimer() {
        return this.spikeChargeTimer;
    }

    public void setSpikeChargeTimer(int spikeChargeTimer) {
        if (this.getSpikeTimer() > 0 && this.spikeChargeTimer == 0) {
            this.addSpikeTimer(spikeChargeTimer);
            return;
        }
        this.spikeChargeTimer = spikeChargeTimer;
    }

    public int getSpikeTimer() {
        return this.spikeTimer;
    }

    public void setSpikeTimer(int spikeTimer) {
        this.spikeTimer = spikeTimer;
    }

    public void addSpikeTimer(int spikeTimer) {
        this.spikeTimer += spikeTimer;
    }

    public void tick() {
        List list;
        super.tick();
        boolean hasSpikeCharge = this.hasSpikeCharge();
        boolean hasSpike = this.hasSpike();
        if (this.level().isClientSide()) {
            if (this.tickCount % 2 == 0 && !hasSpikeCharge && hasSpike) {
                this.makeParticle(1, false);
            }
            if (this.spikeChargeClientPhaseTracker != hasSpikeCharge) {
                if (!this.spikeChargeClientPhaseTracker && hasSpike) {
                    this.spikeChargeClientTimeTracker = 0;
                }
                this.spikeChargeClientPhaseTracker = hasSpikeCharge;
            }
            this.spikeChargeClientTimeTracker = !hasSpikeCharge && !hasSpike ? 0 : ++this.spikeChargeClientTimeTracker;
        } else {
            this.setHasSpike(this.getSpikeTimer() > 0);
            this.setHasSpikeCharge(this.getSpikeChargeTimer() > 0);
            if (this.spikeChargeTimer > 0) {
                --this.spikeChargeTimer;
            } else if (this.spikeTimer > 0) {
                --this.spikeTimer;
            }
        }
        if (hasSpike && !hasSpikeCharge && this.tickCount % 3 == 0 && !(list = this.level().getEntities((Entity)this, this.getBoundingBox())).isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!this.level().isClientSide()) {
                    float damageAmount;
                    float maxHealth = Math.max(livingEntity.getHealth(), livingEntity.getMaxHealth());
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        if (serverPlayer.isCreative()) continue;
                        damageAmount = EssenceOfTheBees.hasEssence(serverPlayer) ? maxHealth / 5.0f : maxHealth / 3.0f;
                    } else {
                        damageAmount = maxHealth / 10.0f;
                    }
                    livingEntity.hurt(this.level().damageSources().source(BzDamageSources.SPIKE_TYPE, (Entity)this), damageAmount);
                    for (Holder mobEffect : new HashSet(livingEntity.getActiveEffectsMap().keySet())) {
                        if (!((MobEffect)mobEffect.value()).isBeneficial()) continue;
                        livingEntity.removeEffect(mobEffect);
                    }
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 1, true, true, true));
                }
                this.makeParticle(1, true);
            }
        }
        if (!this.level().isClientSide() && this.tickCount % 20 == 0) {
            this.checkIfStillInEvent();
        }
    }

    private void checkIfStillInEvent() {
        UUID essenceUuid = this.getEssenceController();
        ResourceKey<Level> essenceDimension = this.getEssenceControllerDimension();
        BlockPos essenceBlockPos = this.getEssenceControllerBlockPos();
        if (essenceBlockPos == null || essenceUuid == null || essenceDimension == null) {
            return;
        }
        BlockPos blockPos = this.blockPosition();
        EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.level(), essenceDimension, essenceBlockPos, essenceUuid);
        if (essenceBlockEntity != null) {
            BlockPos arenaSize = essenceBlockEntity.getArenaSize();
            if (Math.abs(blockPos.getX() - essenceBlockPos.getX()) > arenaSize.getX() / 2 || Math.abs(blockPos.getY() - essenceBlockPos.getY()) > arenaSize.getY() / 2 || Math.abs(blockPos.getZ() - essenceBlockPos.getZ()) > arenaSize.getZ() / 2) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void baseTick() {
    }

    private void makeParticle(int particlesToSpawn, boolean hit) {
        block4: {
            if (particlesToSpawn <= 0) break block4;
            if (hit) {
                Vec3 center = this.blockPosition().getCenter();
                for (int i = 0; i < particlesToSpawn; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, center.x(), center.y() - 0.5, center.z(), (double)(this.random.nextFloat() - 0.5f), (double)(this.random.nextFloat() + 0.5f), (double)(this.random.nextFloat() - 0.5f));
                    this.level().addParticle((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, center.x(), center.y() - 0.5, center.z(), (double)(this.random.nextFloat() - 0.5f), (double)(this.random.nextFloat() + 0.5f), (double)(this.random.nextFloat() - 0.5f));
                }
            } else {
                double size = this.getBoundingBox().getSize();
                double x = this.getX() + (double)(this.random.nextFloat() - 0.5f) * size;
                double y = this.getY() + size / 3.0 + (double)(this.random.nextFloat() - 0.5f) * size;
                double z = this.getZ() + (double)(this.random.nextFloat() - 0.5f) * size;
                for (int i = 0; i < particlesToSpawn; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, x, y, z, (double)((this.random.nextFloat() - 0.5f) * 0.05f), (double)((this.random.nextFloat() + 0.5f) * 0.5f), (double)((this.random.nextFloat() - 0.5f) * 0.05f));
                }
            }
        }
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean canChangeDimensions(Level fromLevel, Level toLevel) {
        return false;
    }

    public Entity changeDimension(DimensionTransition dimensionTransition) {
        return this;
    }

    public int getPortalCooldown() {
        return Integer.MAX_VALUE;
    }

    public boolean shouldRender(double x, double y, double z) {
        return this.hasSpike() || this.hasSpikeCharge();
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setSpikeTimer(compoundTag.getInt("spike_timer"));
        this.setSpikeChargeTimer(compoundTag.getInt("spike_charge_timer"));
        if (compoundTag.contains("essenceController")) {
            this.setEssenceController(compoundTag.getUUID("essenceController"));
        }
        if (compoundTag.contains("essenceControllerBlockPos")) {
            NbtUtils.readBlockPos((CompoundTag)compoundTag, (String)"essenceControllerBlockPos").ifPresent(this::setEssenceControllerBlockPos);
        }
        if (compoundTag.contains("essenceControllerDimension")) {
            this.setEssenceControllerDimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)compoundTag.getString("essenceControllerDimension"))));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("spike_timer", this.getSpikeTimer());
        compoundTag.putInt("spike_charge_timer", this.getSpikeChargeTimer());
        if (this.getEssenceController() != null) {
            compoundTag.putUUID("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.put("essenceControllerBlockPos", NbtUtils.writeBlockPos((BlockPos)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.putString("essenceControllerDimension", this.getEssenceControllerDimension().location().toString());
        }
    }
}

