/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;

public class DirtPelletEntity
extends ThrowableItemProjectile {
    private boolean eventBased = false;
    private Entity homingTarget = null;
    private static final EntityDataAccessor<Optional<UUID>> DATA_HOMING_TARGET_UUID = SynchedEntityData.defineId(DirtPelletEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> DATA_IS_HOMING = SynchedEntityData.defineId(DirtPelletEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public DirtPelletEntity(EntityType<? extends DirtPelletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public DirtPelletEntity(Level world, LivingEntity livingEntity) {
        super((EntityType)BzEntities.DIRT_PELLET_ENTITY.get(), livingEntity, world);
    }

    public DirtPelletEntity(Level world, double x, double y, double z) {
        super((EntityType)BzEntities.DIRT_PELLET_ENTITY.get(), x, y, z, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HOMING_TARGET_UUID, Optional.empty());
        builder.define(DATA_IS_HOMING, (Object)false);
    }

    public boolean isEventBased() {
        return this.eventBased;
    }

    public void setEventBased(boolean eventBased) {
        this.eventBased = eventBased;
    }

    public boolean isHoming() {
        return (Boolean)this.entityData.get(DATA_IS_HOMING);
    }

    public void setHoming(boolean homing) {
        this.entityData.set(DATA_IS_HOMING, (Object)homing);
    }

    public UUID getHomingTargetUUID() {
        return ((Optional)this.entityData.get(DATA_HOMING_TARGET_UUID)).orElse(null);
    }

    public void setHomingTargetUUID(UUID homingTargetUUID) {
        this.entityData.set(DATA_HOMING_TARGET_UUID, Optional.of(homingTargetUUID));
    }

    protected Item getDefaultItem() {
        return (Item)BzItems.DIRT_PELLET.get();
    }

    private ParticleOptions getParticle() {
        ItemStack itemStack = this.getItem();
        return itemStack.isEmpty() ? new ItemParticleOption(ParticleTypes.ITEM, this.getDefaultItem().getDefaultInstance()) : new ItemParticleOption(ParticleTypes.ITEM, itemStack);
    }

    protected ParticleOptions getTrailParticle() {
        return this.getParticle();
    }

    public void tick() {
        Player player;
        if (this.isHoming() && this.homingTarget == null && this.getHomingTargetUUID() != null && (player = this.level().getPlayerByUUID(this.getHomingTargetUUID())) != null) {
            this.homingTarget = player;
        }
        if ((this.tickCount + 2) % 5 == 0) {
            Vec3 futurePos = this.position().add(this.getDeltaMovement());
            this.level().addParticle(this.getTrailParticle(), futurePos.x(), futurePos.y() + 0.1, futurePos.z(), 0.0, 0.0, 0.0);
        }
        super.tick();
        if (this.homingTarget != null && this.getOwner() != null) {
            double magicSideGravityConstant;
            double demoninatorDotProduct;
            double numeratorDotProduct;
            Vec3 projectionPoint;
            Vec3 deltaMovement = this.getDeltaMovement();
            Vec3 shooterProjectileDiff = this.getOwner().position().subtract(this.position());
            Vec3 shooterVictimDiff = this.getOwner().position().subtract(this.homingTarget.position());
            Vec3 vectorToProjectionPoint = (shooterProjectileDiff = shooterProjectileDiff.subtract(0.0, shooterProjectileDiff.y(), 0.0)).subtract(projectionPoint = (shooterVictimDiff = shooterVictimDiff.subtract(0.0, shooterVictimDiff.y(), 0.0)).scale((numeratorDotProduct = shooterProjectileDiff.x() * shooterVictimDiff.x() + shooterProjectileDiff.z() * shooterVictimDiff.z()) / (demoninatorDotProduct = shooterVictimDiff.x() * shooterVictimDiff.x() + shooterVictimDiff.z() * shooterVictimDiff.z())));
            Vec3 sideGravityVector = vectorToProjectionPoint.scale(magicSideGravityConstant = 0.022);
            if (Double.isFinite(sideGravityVector.x()) && Double.isFinite(sideGravityVector.z())) {
                this.setDeltaMovement(deltaMovement.add(sideGravityVector));
            }
        }
    }

    public void handleEntityEvent(byte flag) {
        if (flag == 3) {
            ParticleOptions particleOptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleOptions, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.1, this.random.nextGaussian() * 0.1, this.random.nextGaussian() * 0.1);
            }
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (entity instanceof DirtPelletEntity) {
            DirtPelletEntity dirtPelletEntity2 = (DirtPelletEntity)entity;
            if (dirtPelletEntity2.getOwner() == this.getOwner()) {
                return false;
            }
            if (this.position().closerThan((Position)dirtPelletEntity2.position(), 0.5)) {
                return super.canHitEntity(entity);
            }
            return false;
        }
        return super.canHitEntity(entity);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        RootminEntity rootminEntity;
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        EntityType type = entity.getType();
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)type);
        int damage = 1;
        if (entity instanceof DirtPelletEntity) {
            DirtPelletEntity hitDirtPelletEntity = (DirtPelletEntity)entity;
            if (!this.level().isClientSide) {
                hitDirtPelletEntity.level().broadcastEntityEvent((Entity)this, (byte)3);
                hitDirtPelletEntity.level().playSound(null, this.blockPosition(), (SoundEvent)BzSounds.DIRT_PELLET_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                hitDirtPelletEntity.discard();
            }
        }
        if (!type.is(BzTags.DIRT_PELLET_FORCE_NO_EXTRA_DAMAGE)) {
            Mob mob;
            if (type.is(BzTags.DIRT_PELLET_EXTRA_DAMAGE)) {
                damage = 3;
            } else if (!resourceLocation.getNamespace().equals("minecraft") && !resourceLocation.getNamespace().equals("the_bumblezone") && (entity instanceof FlyingMob || entity instanceof Mob && (mob = (Mob)entity).getMoveControl() instanceof FlyingMoveControl)) {
                damage = 3;
            }
        }
        if (this.eventBased || entity instanceof RootminEntity && (rootminEntity = (RootminEntity)entity).getEssenceController() != null) {
            if (entity instanceof RootminEntity) {
                damage = 1;
            } else if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                float maxHeart = Math.max(serverPlayer.getHealth(), serverPlayer.getMaxHealth());
                damage = !EssenceOfTheBees.hasEssence(serverPlayer) ? (int)(maxHeart / 2.0f) : (int)(maxHeart / 4.0f);
            } else {
                damage = 5;
            }
        }
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
        if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).isSpectator()) {
            Object object;
            Player player;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
                return;
            }
            Vector2d direction = new Vector2d(this.getDeltaMovement().x(), this.getDeltaMovement().z()).normalize();
            double yRotHitRadian = Mth.atan2((double)direction.x(), (double)direction.y());
            double knockbackStrength = 1.0;
            if (livingEntity instanceof RootminEntity) {
                knockbackStrength = this.isEventBased() ? 0.0 : 0.1;
            }
            livingEntity.knockback(knockbackStrength, (double)(-Mth.sin((float)((float)yRotHitRadian))), (double)(-Mth.cos((float)((float)yRotHitRadian))));
            if (this.eventBased && (object = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)object;
                for (Holder mobEffect : new HashSet(livingEntity.getActiveEffectsMap().keySet())) {
                    if (!((MobEffect)mobEffect.value()).isBeneficial()) continue;
                    livingEntity.removeEffect(mobEffect);
                }
                if (this.random.nextBoolean()) {
                    int slotStartIndex = this.random.nextInt(4);
                    for (int i = 0; i < 4; ++i) {
                        int slotIndex = (slotStartIndex + i) % 4;
                        EquipmentSlot equipmentSlot = switch (slotIndex) {
                            case 1 -> EquipmentSlot.CHEST;
                            case 2 -> EquipmentSlot.LEGS;
                            case 3 -> EquipmentSlot.FEET;
                            default -> EquipmentSlot.HEAD;
                        };
                        ItemStack armorItem = livingEntity.getItemBySlot(equipmentSlot);
                        if (armorItem.isEmpty() || EnchantmentHelper.has((ItemStack)armorItem, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) || armorItem.is(BzTags.LIFE_ARENA_ARMOR_CANNOT_BE_KNOCKED_OFF)) continue;
                        livingEntity.setItemSlot(equipmentSlot, ItemStack.EMPTY);
                        this.dropItemFromEntity(livingEntity, armorItem, false, true);
                        break;
                    }
                }
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.DUST_PARTICLE.get()), livingEntity.getX(), livingEntity.getEyeY(), livingEntity.getZ(), 15, this.random.nextGaussian() * 0.2, this.random.nextGaussian() * 0.25 + 0.1, this.random.nextGaussian() * 0.2, 0.0);
            }
        }
    }

    private ItemEntity dropItemFromEntity(LivingEntity livingEntity, ItemStack itemStack, boolean randomMovement, boolean setOwner) {
        if (itemStack.isEmpty()) {
            return null;
        }
        double d = livingEntity.getEyeY() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(livingEntity.level(), livingEntity.getX(), d, livingEntity.getZ(), itemStack);
        itemEntity.setPickUpDelay(40);
        if (setOwner) {
            itemEntity.setThrower((Entity)livingEntity);
        }
        if (randomMovement) {
            float f = this.random.nextFloat() * 0.5f;
            float g = this.random.nextFloat() * ((float)Math.PI * 2);
            itemEntity.setDeltaMovement((double)(-Mth.sin((float)g) * f), (double)0.2f, (double)(Mth.cos((float)g) * f));
        } else {
            float g = Mth.sin((float)(livingEntity.getXRot() * ((float)Math.PI / 180)));
            float h = Mth.cos((float)(livingEntity.getXRot() * ((float)Math.PI / 180)));
            float i = Mth.sin((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            float j = Mth.cos((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            float k = this.random.nextFloat() * ((float)Math.PI * 2);
            float l = 0.02f * this.random.nextFloat();
            itemEntity.setDeltaMovement((double)(-i * h * 0.3f) + Math.cos(k) * (double)l, (double)(-g * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(j * h * 0.3f) + Math.sin(k) * (double)l);
        }
        livingEntity.level().addFreshEntity((Entity)itemEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.awardStat(Stats.ITEM_DROPPED.get((Object)itemStack.getItem()), itemStack.getCount());
            serverPlayer.awardStat(Stats.DROP);
        }
        return itemEntity;
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.level().playSound(null, this.blockPosition(), (SoundEvent)BzSounds.DIRT_PELLET_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.discard();
        }
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        double speed = this.getDeltaMovement().length();
        return (float)Math.max(speed, 8.0);
    }

    public boolean hurt(DamageSource damageSource, float f) {
        if (this.isInvulnerableTo(damageSource)) {
            return false;
        }
        this.markHurt();
        Entity entity = damageSource.getEntity();
        if (entity != null) {
            if (!this.level().isClientSide) {
                Vec3 vec3 = entity.getLookAngle();
                this.setDeltaMovement(vec3);
                if (this.isHoming() && this.getOwner() != null) {
                    this.setHomingTargetUUID(this.getOwner().getUUID());
                    this.homingTarget = this.getOwner();
                } else {
                    this.setHoming(false);
                }
                this.setOwner(entity);
            }
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean("isEvent", this.isEventBased());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setEventBased(compoundTag.getBoolean("isEvent"));
    }
}

