/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;

public class RootminHurtByTargetGoal
extends TargetGoal {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
    private int timestamp;

    public RootminHurtByTargetGoal(PathfinderMob mob) {
        super((Mob)mob, true);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        int lastHurtByMobTimestamp = this.mob.getLastHurtByMobTimestamp();
        LivingEntity livingEntity = this.mob.getLastHurtByMob();
        if (lastHurtByMobTimestamp != this.timestamp && livingEntity != null) {
            if (livingEntity.getType() == EntityType.PLAYER && this.mob.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                return false;
            }
            if (livingEntity instanceof RootminEntity) {
                RootminEntity rootminEntity;
                RootminEntity rootminEntityAttacker = (RootminEntity)livingEntity;
                Mob mob = this.mob;
                if (mob instanceof RootminEntity && !(rootminEntity = (RootminEntity)mob).isInvulnerable()) {
                    rootminEntity.runCurse();
                    rootminEntityAttacker.runEmbarrassed();
                    rootminEntity.disableAttackGoals = true;
                    rootminEntityAttacker.disableAttackGoals = true;
                    rootminEntity.rootminToLookAt = rootminEntityAttacker;
                    rootminEntityAttacker.rootminToLookAt = rootminEntity;
                    this.timestamp = this.mob.getLastHurtByMobTimestamp();
                    return false;
                }
            }
            if (livingEntity.getType().is(BzTags.ROOTMIN_FORCED_DO_NOT_TARGET)) {
                return false;
            }
            return this.canAttack(livingEntity, HURT_BY_TARGETING);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.mob.getLastHurtByMob());
        this.targetMob = this.mob.getTarget();
        this.timestamp = this.mob.getLastHurtByMobTimestamp();
        this.unseenMemoryTicks = 300;
        super.start();
        if (this.targetMob != null) {
            List rootminEntities = this.mob.level().getEntitiesOfClass(RootminEntity.class, this.mob.getBoundingBox().inflate(30.0));
            for (RootminEntity rootminEntity : rootminEntities) {
                if (rootminEntity != this.mob && rootminEntity.getTarget() != this.targetMob && !RootminEntity.POSES_THAT_CANT_BE_MOTION_INTERRUPTED.contains((Object)rootminEntity.getRootminPose())) {
                    rootminEntity.runAngry();
                }
                rootminEntity.setTarget(this.targetMob);
                rootminEntity.superHatedPlayer = this.targetMob.getUUID();
            }
        }
    }
}

