/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public final class BeeDedicatedSpawning {
    private BeeDedicatedSpawning() {
    }

    public static void specialSpawnBees(ServerLevel world) {
        int despawnDistance = 80;
        int entityCountChange = 0;
        Set<Bee> allWildBees = GeneralUtils.getAllWildBees();
        List serverPlayers = world.players();
        for (Bee wildBee : allWildBees) {
            boolean isTooFar = true;
            for (ServerPlayer serverPlayer : serverPlayers) {
                if (PlatformHooks.isFakePlayer(serverPlayer) || !(wildBee.position().subtract(serverPlayer.position()).length() <= (double)despawnDistance)) continue;
                isTooFar = false;
                break;
            }
            if (!isTooFar) continue;
            wildBee.remove(Entity.RemovalReason.DISCARDED);
            --entityCountChange;
        }
        int beesPerPlayer = BzGeneralConfigs.nearbyBeesPerPlayerInBz;
        int maxWildBeeLimit = beesPerPlayer * serverPlayers.size();
        if (allWildBees.size() <= maxWildBeeLimit) {
            for (ServerPlayer serverPlayer : serverPlayers) {
                if (PlatformHooks.isFakePlayer(serverPlayer)) continue;
                int nearbyBees = 0;
                for (Entity entity : world.getEntities((Entity)serverPlayer, serverPlayer.getBoundingBox().inflate((double)despawnDistance, (double)despawnDistance, (double)despawnDistance))) {
                    if (!(entity instanceof Bee)) continue;
                    ++nearbyBees;
                }
                for (int i = nearbyBees; i <= beesPerPlayer; ++i) {
                    BlockPos newBeePos = GeneralUtils.getRandomBlockposWithinRange((LivingEntity)serverPlayer, 45, 20);
                    if (!world.getBlockState(newBeePos).isAir()) continue;
                    Bee newBee = BzGeneralConfigs.variantBeeTypes.size() > 0 && world.getRandom().nextFloat() < 0.05f ? (Bee)((EntityType)BzEntities.VARIANT_BEE.get()).create((Level)world) : (Bee)EntityType.BEE.create((Level)world);
                    newBee.setPos(Vec3.atCenterOf((Vec3i)newBeePos));
                    newBee.setDeltaMovement(new Vec3(0.0, 1.0, 0.0));
                    newBee.setSpeed(0.0f);
                    newBee.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(newBee.blockPosition()), MobSpawnType.NATURAL, null);
                    PlatformHooks.finalizeSpawn((Mob)newBee, (ServerLevelAccessor)world, null, MobSpawnType.NATURAL);
                    world.addFreshEntity((Entity)newBee);
                    ++entityCountChange;
                }
            }
        }
        GeneralUtils.adjustEntityCountInBz(entityCountChange);
    }
}

