/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerBreakSpeedEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;

public class CombCutterEnchantmentApplication {
    private static final GeneralUtils.Lazy<Set<Block>> TARGET_BLOCKS = new GeneralUtils.Lazy();
    private static final GeneralUtils.Lazy<Set<Block>> LESSER_TARGET_BLOCKS = new GeneralUtils.Lazy();

    public static int getCombCutterEnchantLevel(ItemStack stack, Level level) {
        Holder<Enchantment> ncombCutterurotoxin = EnchantmentUtils.getEnchantmentHolder(BzEnchantments.COMB_CUTTER, level);
        return Math.min(EnchantmentHelper.getItemEnchantmentLevel(ncombCutterurotoxin, (ItemStack)stack), BzGeneralConfigs.neurotoxinMaxLevel);
    }

    public static Set<Block> getTargetBlocks() {
        return TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<Block> validBlocks = new HashSet<Block>();
            for (ResourceLocation key : BuiltInRegistries.BLOCK.keySet()) {
                String path = key.getPath();
                if (!path.contains("comb") && !path.contains("luminescent_wax") && !path.contains("ancient_wax")) continue;
                validBlocks.add((Block)BuiltInRegistries.BLOCK.get(key));
            }
            return validBlocks;
        });
    }

    public static Set<Block> getLesserTargetBlocks() {
        return LESSER_TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<Block> validBlocks = new HashSet<Block>();
            for (ResourceLocation key : BuiltInRegistries.BLOCK.keySet()) {
                String path = key.getPath();
                Block block = (Block)BuiltInRegistries.BLOCK.get(key);
                if (!(block instanceof BeehiveBlock) && !path.contains("hive") && !path.contains("nest") && (!path.contains("wax") || path.contains("waxed"))) continue;
                validBlocks.add(block);
            }
            return validBlocks;
        });
    }

    public static void attemptFasterMining(PlayerBreakSpeedEvent event) {
        if (CombCutterEnchantmentApplication.getTargetBlocks().contains(event.state().getBlock())) {
            CombCutterEnchantmentApplication.mineFaster(event, false);
        } else if (CombCutterEnchantmentApplication.getLesserTargetBlocks().contains(event.state().getBlock())) {
            CombCutterEnchantmentApplication.mineFaster(event, true);
        }
    }

    private static void mineFaster(PlayerBreakSpeedEvent event, boolean lesserTarget) {
        Player playerEntity = event.player();
        ItemStack itemStack = playerEntity.getMainHandItem();
        int equipmentLevel = EnchantmentHelper.getEnchantmentLevel(EnchantmentUtils.getEnchantmentHolder(BzEnchantments.COMB_CUTTER, playerEntity.level()), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.isEmpty()) {
            double newSpeed = equipmentLevel * equipmentLevel + (lesserTarget ? 3 : 13);
            if (playerEntity.hasEffect(MobEffects.DIG_SLOWDOWN)) {
                int amplifier = playerEntity.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier();
                if (amplifier < 0) {
                    amplifier = 3;
                }
                newSpeed /= (Math.pow(amplifier, 6.0) + 2.0) * 20.0;
            }
            event.speed().addAndGet(newSpeed);
        }
    }

    public static void increasedCombDrops(Player playerEntity, Level world, BlockPos pos) {
        ItemStack itemStack = playerEntity.getMainHandItem();
        int equipmentLevel = EnchantmentHelper.getEnchantmentLevel(EnchantmentUtils.getEnchantmentHolder(BzEnchantments.COMB_CUTTER, playerEntity.level()), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.isEmpty()) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.HONEYCOMB, equipmentLevel * 3));
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                ((GenericTrigger)((Object)BzCriterias.COMB_CUTTER_EXTRA_DROPS_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }
}

