/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.neoforge;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class BzGeneralConfig {
    public static final ModConfigSpec GENERAL_SPEC;
    public static ModConfigSpec.BooleanValue bzHoneyFluidFromHoneyBottles;
    public static ModConfigSpec.ConfigValue<List<? extends String>> variantBeeTypes;
    public static ModConfigSpec.DoubleValue beehemothSpeed;
    public static ModConfigSpec.BooleanValue beehemothFriendlyFire;
    public static ModConfigSpec.BooleanValue specialBeeSpawning;
    public static ModConfigSpec.BooleanValue beeLootInjection;
    public static ModConfigSpec.BooleanValue moddedBeeLootInjection;
    public static ModConfigSpec.BooleanValue glisteringHoneyBrewingRecipe;
    public static ModConfigSpec.BooleanValue beeStingerBrewingRecipe;
    public static ModConfigSpec.BooleanValue beeSoupBrewingRecipe;
    public static ModConfigSpec.IntValue nearbyBeesPerPlayerInBz;
    public static ModConfigSpec.BooleanValue dispensersDropGlassBottles;
    public static ModConfigSpec.IntValue broodBlocksBeeSpawnCapacity;
    public static ModConfigSpec.BooleanValue pileOfPollenHyperFireSpread;
    public static ModConfigSpec.BooleanValue superCandlesBurnsMobs;
    public static ModConfigSpec.IntValue neurotoxinMaxLevel;
    public static ModConfigSpec.IntValue paralyzedMaxTickDuration;
    public static ModConfigSpec.IntValue beeQueenBonusTradeRewardMultiplier;
    public static ModConfigSpec.IntValue beeQueenBonusTradeDurationInTicks;
    public static ModConfigSpec.IntValue beeQueenBonusTradeAmountTillSatified;
    public static ModConfigSpec.BooleanValue beeQueenSpecialDayTrades;
    public static ModConfigSpec.BooleanValue beeQueenRespawning;
    public static ModConfigSpec.BooleanValue allowWanderingTraderMusicDiscsTrades;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeItemEntities;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeExperienceOrbEntities;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeItemUI;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeExperienceUI;
    public static ModConfigSpec.IntValue crystallineFlowerEnchantingPowerAllowedPerTier;
    public static ModConfigSpec.IntValue crystallineFlowerExtraXpNeededForTiers;
    public static ModConfigSpec.IntValue crystallineFlowerExtraTierCost;
    public static ModConfigSpec.BooleanValue repeatableEssenceEvents;
    public static ModConfigSpec.IntValue cosmicCrystalHealth;
    public static ModConfigSpec.IntValue ragingEssenceAbilityUse;
    public static ModConfigSpec.IntValue ragingEssenceCooldown;
    public static ModConfigSpec.ConfigValue<List<? extends Integer>> ragingEssenceStrengthLevels;
    public static ModConfigSpec.IntValue knowingEssenceAbilityUse;
    public static ModConfigSpec.IntValue knowingEssenceCooldown;
    public static ModConfigSpec.BooleanValue knowingEssenceStructureNameServer;
    public static ModConfigSpec.IntValue calmingEssenceAbilityUse;
    public static ModConfigSpec.IntValue calmingEssenceCooldown;
    public static ModConfigSpec.IntValue lifeEssenceAbilityUse;
    public static ModConfigSpec.IntValue lifeEssenceCooldown;
    public static ModConfigSpec.IntValue radianceEssenceAbilityUse;
    public static ModConfigSpec.IntValue radianceEssenceCooldown;
    public static ModConfigSpec.IntValue continuityEssenceCooldown;

    private static void setupConfig(ModConfigSpec.Builder builder) {
        builder.push("Bumblezone Fluid Options");
        bzHoneyFluidFromHoneyBottles = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether extracting fluid from Honey Bottles will attempt to generate Bumblezone Honey Fluid.\n"}).translation("the_bumblezone.config.bzhoneyfluidfromhoneybottles").define("bzHoneyFluidFromHoneyBottles", true);
        builder.pop();
        builder.push("Variant Bee Options");
        variantBeeTypes = builder.comment(new String[]{" \n-----------------------------------------------------\n", " What skin variations of Variant Bees can spawn! Add more bee textures to this folder assets\\the_bumblezone\\textures\\entity\\bee_variants and define the bee in this config!\n"}).translation("the_bumblezone.config.variantbeetypes").defineList("variantBeeTypes", Arrays.asList("redtail_bee", "green_bee", "blue_bee", "white_bee", "ukraine_bee", "trans_bee", "asexual_bee", "agender_bee", "aroace_bee", "aromantic_bee", "bisexual_bee", "pan_bee", "enby_bee", "reverse_bee", "neapolitan_bee", "rainbow_bee"), entry -> true);
        builder.pop();
        builder.push("Beehemoth Options");
        beehemothSpeed = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Base speed for the Beehemoth when being rode by a player.\n"}).translation("the_bumblezone.config.beehemothspeed").defineInRange("beehemothSpeed", 0.95, 0.0, 100.0);
        beehemothFriendlyFire = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Allows tamed Beehemoths to take damage from owner.\n"}).translation("the_bumblezone.config.beehemothfriendlyfire").define("beehemothFriendlyFire", true);
        builder.pop();
        builder.push("Special Bee Spawning Options");
        specialBeeSpawning = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bumblezone will handle spawning vanilla bees near players in the Bumblezone to make it feel full of Bees.", " Bees too far will be despawned in Bumblezone unless the bee has a hive, is name tagged, or is set to persistent.", " Note: Modded bees will not be spawned through this system. Those will be spawned by normal biome spawning.\n"}).translation("the_bumblezone.config.specialbeespawning").define("specialBeeSpawning", true);
        nearbyBeesPerPlayerInBz = builder.comment(new String[]{" \n-----------------------------------------------------\n", " If specialBeeSpawning is set to true, this config controls how many vanilla bees should be", " near each player in Bumblezone dimension. Higher numbers like 100 is insane lol. 25 is nice.\n"}).translation("the_bumblezone.config.nearbybeesperplayerinbz").defineInRange("nearbyBeesPerPlayerInBz", 25, 0, 1000);
        builder.pop();
        builder.push("Bee Loot Injection Options");
        beeLootInjection = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bee Stingers should drop from adult Bees that die while still having their stinger.", " This pulls from this loot table for the drops: `the_bumblezone:entities/bee_stinger_drops`\n"}).translation("the_bumblezone.config.beelootinjection").define("beeLootInjection", true);
        moddedBeeLootInjection = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bee Stingers should drop from adult modded Bees that die while still having their stinger.", " This pulls from this loot table for the drops: `the_bumblezone:entities/bee_stinger_drops`\n"}).translation("the_bumblezone.config.moddedbeelootinjection").define("moddedBeeLootInjection", true);
        builder.pop();
        builder.push("Brewing Recipe Options");
        glisteringHoneyBrewingRecipe = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Glistering Honey Crystals can be used to make Potions of Luck"}).translation("the_bumblezone.config.glisteringhoneybrewingrecipe").define("glisteringHoneyBrewingRecipe", true);
        beeStingerBrewingRecipe = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bee Stingers can be used to make Potions of Long Poison"}).translation("the_bumblezone.config.beestingerbrewingrecipe").define("beeStingerBrewingRecipe", true);
        beeSoupBrewingRecipe = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bee Soup can be used to make Potions of Neurotoxin"}).translation("the_bumblezone.config.beesoupbrewingrecipe").define("beeSoupBrewingRecipe", true);
        builder.pop();
        builder.push("Enchantments Options");
        neurotoxinMaxLevel = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Maximum level that Neurotoxin enchantment's strength can be regardless of the enchantment's level.\n Note, changing this won't change enchantment's own max level. Just that this config set to 2 will make level 3 enchant behave like level 2.\n To change an enchantment's max level display, datapack replace data/the_bumblezone/enchantment/neurotoxin.json file.\n"}).translation("the_bumblezone.config.neurotoxinmaxlevel").defineInRange("neurotoxinMaxLevel", 2, 1, 255);
        paralyzedMaxTickDuration = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Sets maximum tick duration the Paralyzed effect can be on an entity. Actions that reapply Paralyzed can still reset the timer and keep entity stunned.\n"}).translation("the_bumblezone.config.paralyzedmaxtickduration").defineInRange("paralyzedMaxTickDuration", 600, 1, 1000000);
        builder.pop();
        builder.push("General Mechanics Options");
        dispensersDropGlassBottles = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Should Dispensers always drop the Glass Bottle when using specific ", " bottle items on certain The Bumblezone blocks? ", " ", " Example: Using Honey Bottle to feed Honeycomb Brood Blocks will grow the larva and", " drop the Glass Bottle instead of putting it back into Dispenser if this is set to true.\n"}).translation("the_bumblezone.config.dispensersdropglassbottles").define("dispensersDropGlassBottles", false);
        broodBlocksBeeSpawnCapacity = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Brood Blocks will automatically spawn bees until the number of active bees is the value below. ", " Set this higher to allow Brood Blocks to spawn more bees in a smaller area or set it to 0 to turn ", " off automatic Brood Block bee spawning.\n"}).translation("the_bumblezone.config.broodblocksbeespawncapacity").defineInRange("broodBlocksBeeSpawnCapacity", 40, 0, 1000);
        pileOfPollenHyperFireSpread = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Pile of Pollen should spread fire super quickly to burn away huge swathes of pollen.\n"}).translation("the_bumblezone.config.pileofpollenhyperfirespread").define("pileOfPollenHyperFireSpread", false);
        superCandlesBurnsMobs = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Allows lit Super Candles/Potion Candle to burn mobs in its flame.\n"}).translation("the_bumblezone.config.supercandlesburnsmobs").define("superCandlesBurnsMobs", true);
        beeQueenBonusTradeRewardMultiplier = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Multiplies the trade reward by this much for bonus Trades! 0 or 1 set here disables bonus Trades.\n"}).translation("the_bumblezone.config.beequeenbonusTraderewardmultiplier").defineInRange("beeQueenBonusTradeRewardMultiplier", 3, 0, 256);
        beeQueenBonusTradeDurationInTicks = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How long in ticks that bonus Trades will last for before the Bee Queen asks for a new item.", " Setting this to 0 disables bonus Trades. Anything less than a minute (1200) will not broadcast request message to players\n"}).translation("the_bumblezone.config.beequeenbonusTradedurationinticks").defineInRange("beeQueenBonusTradeDurationInTicks", 24000, 0, 2000000);
        beeQueenBonusTradeAmountTillSatified = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How many boosted trades are allowed until the bonus Trade is depleted until the queen requests a new item", " Setting this to 0 disables bonus Trades.\n"}).translation("the_bumblezone.config.beequeenbonusTradeamounttillsatified").defineInRange("beeQueenBonusTradeAmountTillSatified", 24, 0, 1000000);
        beeQueenSpecialDayTrades = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether to allow special trades to activate during certain days of the year.\n"}).translation("the_bumblezone.config.beequeenspecialdaytrades").define("beeQueenSpecialDayTrades", true);
        beeQueenRespawning = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Allow Bee Queen to respawn in Throne Pillar when located with fresh Throne Honey Compass.\n"}).translation("the_bumblezone.config.beequeenrespawning").define("beeQueenRespawning", true);
        crystallineFlowerConsumeItemEntities = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether the Crystalline Flower block will eat any item entity that touches the block's collision box in the world\n"}).translation("the_bumblezone.config.crystallineflowerconsumeitementities").define("crystallineFlowerConsumeItemEntities", true);
        crystallineFlowerConsumeExperienceOrbEntities = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether the Crystalline Flower block will pull in and eat any experience orb that touches it in the world\n"}).translation("the_bumblezone.config.crystallineflowerconsumeexperienceorbentities").define("crystallineFlowerConsumeExperienceOrbEntities", true);
        crystallineFlowerConsumeItemUI = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether the Crystalline Flower's GUI allows players to feed it items directly\n"}).translation("the_bumblezone.config.crystallineflowerconsumeitemui").define("crystallineFlowerConsumeItemUI", true);
        crystallineFlowerConsumeExperienceUI = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether the Crystalline Flower's GUI allows players to feed it the player's experience\n"}).translation("the_bumblezone.config.crystallineflowerconsumeexperienceui").define("crystallineFlowerConsumeExperienceUI", true);
        crystallineFlowerEnchantingPowerAllowedPerTier = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Controls how much \"enchanting power\" is used per tier to determine what enchantment shows up.", " Enchantments of higher levels or rarity requires more \"enchanting power\" before they show up in the UI.", " Think of this like how Enchanting Tables only shows stronger or rarer enchantments when you have more bookshelves.", " Except here, the flower's tier times this config value is used as the threshold to know what enchantment and level to show.\n"}).translation("the_bumblezone.config.crystallineflowerenchantingpowerallowedpertier").defineInRange("crystallineFlowerEnchantingPowerAllowedPerTier", 8, 0, 1000);
        crystallineFlowerExtraXpNeededForTiers = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How much extra experience is required to reach the next tier for the Crystalline Flower.", " Remember, item consuming is also affected as items are converted to experience when the flower consumes it.\n"}).translation("the_bumblezone.config.crystallineflowerextraxpneededfortiers").defineInRange("crystallineFlowerExtraXpNeededForTiers", 0, -1000000, 1000000);
        crystallineFlowerExtraTierCost = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Increases or decreases the tier cost of all enchantments available by whatever value you set.", " The enchantment's tier cost will be capped between 1 and 6.\n"}).translation("the_bumblezone.config.crystallineflowerextratiercost").defineInRange("crystallineFlowerExtraTierCost", 0, -5, 5);
        builder.pop();
        builder.push("Music Disc Options");
        allowWanderingTraderMusicDiscsTrades = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Wandering Traders can have a rare trade for Bumblezone Music Discs.\n"}).translation("the_bumblezone.config.allowwanderingtradermusicdiscstrades").define("allowWanderingTraderMusicDiscsTrades", true);
        builder.pop();
        builder.push("Essence Options");
        repeatableEssenceEvents = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether the Essence events in Sempiternal Sanctums can be repeated after beating it once.\n"}).translation("the_bumblezone.config.repeatableessenceevents").define("repeatableEssenceEvents", true);
        cosmicCrystalHealth = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How much max health Cosmic Crystal entity has. (For Continuity Essence event)\n"}).translation("the_bumblezone.config.cosmiccrystalhealth").defineInRange("cosmicCrystalHealth", 60, 1, 1000000);
        ragingEssenceAbilityUse = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How much ability use this item has before depleted.\n"}).translation("the_bumblezone.config.ragingessenceabilityuse").defineInRange("ragingEssenceAbilityUse", 28, 0, 1000000);
        ragingEssenceCooldown = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.config.ragingessencecooldown").defineInRange("ragingEssenceCooldown", 36000, 0, 1000000);
        ragingEssenceStrengthLevels = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How many rage levels there are and what level Strength effect each rage level gives.\n The list is in order of the effect levels that the player will get as they make highlighted kills.\n Adding or removing numbers will change the maximum number of rage tiers too.\n"}).translation("the_bumblezone.config.ragingessencestrengthlevels").defineList("ragingEssenceStrengthLevels", Arrays.asList(1, 2, 3, 5, 8, 14, 20), entry -> {
            if (entry instanceof Integer) {
                Integer integer = (Integer)entry;
                return integer > 0;
            }
            return false;
        });
        knowingEssenceAbilityUse = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How much ability use (per second) this item has before depleted.\n"}).translation("the_bumblezone.config.knowingessenceabilityuse").defineInRange("knowingEssenceAbilityUse", 1200, 0, 1000000);
        knowingEssenceCooldown = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.config.knowingessencecooldown").defineInRange("knowingEssenceCooldown", 18000, 0, 1000000);
        knowingEssenceStructureNameServer = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether clients should be allowed to see names of structures they are in with this item. \n"}).translation("the_bumblezone.config.knowingEssenceStructureNameServer").define("knowingEssenceStructureNameServer", true);
        calmingEssenceAbilityUse = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How much ability use (per second) this item has before depleted.\n"}).translation("the_bumblezone.config.calmingessenceabilityuse").defineInRange("calmingEssenceAbilityUse", 600, 0, 1000000);
        calmingEssenceCooldown = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.config.calmingessencecooldown").defineInRange("calmingEssenceCooldown", 12000, 0, 1000000);
        lifeEssenceAbilityUse = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How much ability use this item has before depleted.\n"}).translation("the_bumblezone.config.lifeessenceabilityuse").defineInRange("lifeEssenceAbilityUse", 1000, 0, 1000000);
        lifeEssenceCooldown = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.config.lifeessencecooldown").defineInRange("lifeEssenceCooldown", 12000, 0, 1000000);
        radianceEssenceAbilityUse = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How much ability use (per 25 ticks) this item has before depleted.\n"}).translation("the_bumblezone.config.radianceessenceabilityuse").defineInRange("radianceEssenceAbilityUse", 4800, 0, 1000000);
        radianceEssenceCooldown = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.config.radianceessencecooldown").defineInRange("radianceEssenceCooldown", 12000, 0, 1000000);
        continuityEssenceCooldown = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.config.continuityessencecooldown").defineInRange("continuityEssenceCooldown", 48000, 0, 1000000);
        builder.pop();
    }

    public static void copyToCommon() {
        BzGeneralConfigs.variantBeeTypes = new ArrayList<String>((Collection)variantBeeTypes.get());
        BzGeneralConfigs.beehemothSpeed = (Double)beehemothSpeed.get();
        BzGeneralConfigs.beehemothFriendlyFire = (Boolean)beehemothFriendlyFire.get();
        BzGeneralConfigs.specialBeeSpawning = (Boolean)specialBeeSpawning.get();
        BzGeneralConfigs.beeLootInjection = (Boolean)beeLootInjection.get();
        BzGeneralConfigs.moddedBeeLootInjection = (Boolean)moddedBeeLootInjection.get();
        BzGeneralConfigs.glisteringHoneyBrewingRecipe = (Boolean)glisteringHoneyBrewingRecipe.get();
        BzGeneralConfigs.beeStingerBrewingRecipe = (Boolean)beeStingerBrewingRecipe.get();
        BzGeneralConfigs.nearbyBeesPerPlayerInBz = (Integer)nearbyBeesPerPlayerInBz.get();
        BzGeneralConfigs.dispensersDropGlassBottles = (Boolean)dispensersDropGlassBottles.get();
        BzGeneralConfigs.broodBlocksBeeSpawnCapacity = (Integer)broodBlocksBeeSpawnCapacity.get();
        BzGeneralConfigs.pileOfPollenHyperFireSpread = (Boolean)pileOfPollenHyperFireSpread.get();
        BzGeneralConfigs.superCandlesBurnsMobs = (Boolean)superCandlesBurnsMobs.get();
        BzGeneralConfigs.neurotoxinMaxLevel = (Integer)neurotoxinMaxLevel.get();
        BzGeneralConfigs.paralyzedMaxTickDuration = (Integer)paralyzedMaxTickDuration.get();
        BzGeneralConfigs.beeQueenBonusTradeRewardMultiplier = (Integer)beeQueenBonusTradeRewardMultiplier.get();
        BzGeneralConfigs.beeQueenBonusTradeDurationInTicks = (Integer)beeQueenBonusTradeDurationInTicks.get();
        BzGeneralConfigs.beeQueenBonusTradeAmountTillSatified = (Integer)beeQueenBonusTradeAmountTillSatified.get();
        BzGeneralConfigs.beeQueenSpecialDayTrades = (Boolean)beeQueenSpecialDayTrades.get();
        BzGeneralConfigs.beeQueenRespawning = (Boolean)beeQueenRespawning.get();
        BzGeneralConfigs.allowWanderingTraderMusicDiscsTrades = (Boolean)allowWanderingTraderMusicDiscsTrades.get();
        BzGeneralConfigs.crystallineFlowerConsumeItemEntities = (Boolean)crystallineFlowerConsumeItemEntities.get();
        BzGeneralConfigs.crystallineFlowerConsumeExperienceOrbEntities = (Boolean)crystallineFlowerConsumeExperienceOrbEntities.get();
        BzGeneralConfigs.crystallineFlowerConsumeItemUI = (Boolean)crystallineFlowerConsumeItemUI.get();
        BzGeneralConfigs.crystallineFlowerConsumeExperienceUI = (Boolean)crystallineFlowerConsumeExperienceUI.get();
        BzGeneralConfigs.crystallineFlowerEnchantingPowerAllowedPerTier = (Integer)crystallineFlowerEnchantingPowerAllowedPerTier.get();
        BzGeneralConfigs.crystallineFlowerExtraXpNeededForTiers = (Integer)crystallineFlowerExtraXpNeededForTiers.get();
        BzGeneralConfigs.crystallineFlowerExtraTierCost = (Integer)crystallineFlowerExtraTierCost.get();
        BzGeneralConfigs.repeatableEssenceEvents = (Boolean)repeatableEssenceEvents.get();
        BzGeneralConfigs.cosmicCrystalHealth = (Integer)cosmicCrystalHealth.get();
        BzGeneralConfigs.ragingEssenceAbilityUse = (Integer)ragingEssenceAbilityUse.get();
        BzGeneralConfigs.ragingEssenceCooldown = (Integer)ragingEssenceCooldown.get();
        BzGeneralConfigs.ragingEssenceStrengthLevels = ((List)ragingEssenceStrengthLevels.get()).stream().mapToInt(i -> i).toArray();
        BzGeneralConfigs.knowingEssenceAbilityUse = (Integer)knowingEssenceAbilityUse.get();
        BzGeneralConfigs.knowingEssenceCooldown = (Integer)knowingEssenceCooldown.get();
        BzGeneralConfigs.knowingEssenceStructureNameServer = (Boolean)knowingEssenceStructureNameServer.get();
        BzGeneralConfigs.calmingEssenceAbilityUse = (Integer)calmingEssenceAbilityUse.get();
        BzGeneralConfigs.calmingEssenceCooldown = (Integer)calmingEssenceCooldown.get();
        BzGeneralConfigs.lifeEssenceAbilityUse = (Integer)lifeEssenceAbilityUse.get();
        BzGeneralConfigs.lifeEssenceCooldown = (Integer)lifeEssenceCooldown.get();
        BzGeneralConfigs.radianceEssenceAbilityUse = (Integer)radianceEssenceAbilityUse.get();
        BzGeneralConfigs.radianceEssenceCooldown = (Integer)radianceEssenceCooldown.get();
        BzGeneralConfigs.continuityEssenceCooldown = (Integer)continuityEssenceCooldown.get();
    }

    static {
        ModConfigSpec.Builder configBuilder = new ModConfigSpec.Builder();
        BzGeneralConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

