/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.pileofpollen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.events.client.BlockRenderedOnScreenEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PileOfPollenRenderer {
    private static final ResourceLocation TEXTURE_POLLEN = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/block/pile_of_pollen/pile_of_pollen.png");
    private static final ResourceLocation TEXTURE_POLLEN_SUSPICIOUS = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/block/pile_of_pollen/pile_of_pollen_suspicious_1.png");

    public static boolean pileOfPollenOverlay(BlockRenderedOnScreenEvent event) {
        BlockState blockState = event.state();
        if (event.type().equals((Object)BlockRenderedOnScreenEvent.Type.BLOCK) && blockState.is(BzTags.POLLEN_BLOCKS)) {
            Player playerEntity = event.player();
            PoseStack matrixStack = event.stack();
            boolean isInPollen = false;
            for (int x = -1; x <= 1; ++x) {
                block1: for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        if (x * x + y * y + z * z <= 2) continue;
                        double eyePosX = playerEntity.getX() + (double)((float)x * playerEntity.getBbWidth() * 0.155f);
                        double eyePosY = playerEntity.getEyeY() + (double)((float)y * 0.12f);
                        double eyePosZ = playerEntity.getZ() + (double)((float)z * playerEntity.getBbWidth() * 0.155f);
                        Vec3 eyePosition = new Vec3(eyePosX, eyePosY, eyePosZ);
                        BlockPos eyeBlockPos = BlockPos.containing((Position)eyePosition);
                        BlockState eyeBlock = playerEntity.level().getBlockState(eyeBlockPos);
                        VoxelShape blockBounds = eyeBlock.getShape((BlockGetter)playerEntity.level(), eyeBlockPos);
                        if (blockBounds.isEmpty()) continue;
                        Vec3 eyePos = eyePosition.subtract(Vec3.atLowerCornerOf((Vec3i)eyeBlockPos));
                        if (!blockBounds.bounds().contains(eyePos)) continue;
                        isInPollen = true;
                        x = 2;
                        z = 2;
                        continue block1;
                    }
                }
            }
            if (!isInPollen) {
                return true;
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(blockState.is((Block)BzBlocks.PILE_OF_POLLEN_SUSPICIOUS.get()) ? TEXTURE_POLLEN_SUSPICIOUS : TEXTURE_POLLEN));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float opacity = 1.0f;
            float brightness = 0.3f;
            float redStrength = 1.0f;
            float greenStrength = 0.9f;
            float blueStrength = 0.8f;
            RenderSystem.setShaderColor((float)(brightness * redStrength), (float)(brightness * greenStrength), (float)(brightness * blueStrength), (float)opacity);
            float pitch = -playerEntity.getYRot() / 64.0f;
            float yaw = playerEntity.getXRot() / 64.0f;
            float yawPlus4 = 4.0f + yaw;
            float pitchPlus4 = 4.0f + pitch;
            float movementScaling = 0.85f;
            Vector3f playerPosition = playerEntity.position().multiply((double)movementScaling, (double)movementScaling, (double)movementScaling).toVector3f();
            float smallXZOffset = playerPosition.x() * playerPosition.z() * 0.0f;
            float smallYOffset = playerPosition.y() * 0.33f;
            Matrix4f matrix4f = matrixStack.last().pose();
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(pitchPlus4 - smallXZOffset, yawPlus4 - playerPosition.y());
            bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(pitch - smallXZOffset, yawPlus4 - playerPosition.y());
            bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(pitch - smallXZOffset, yaw - playerPosition.y());
            bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(pitchPlus4 - smallXZOffset, yaw - playerPosition.y());
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.setShaderColor((float)(brightness * redStrength), (float)(brightness * greenStrength), (float)(brightness * blueStrength), (float)(opacity * 0.33f));
            bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(pitchPlus4 - playerPosition.x(), yawPlus4 - smallYOffset);
            bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(pitch - playerPosition.x(), yawPlus4 - smallYOffset);
            bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(pitch - playerPosition.x(), yaw - smallYOffset);
            bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(pitchPlus4 - playerPosition.x(), yaw - smallYOffset);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.setShaderColor((float)(brightness * redStrength), (float)(brightness * greenStrength), (float)(brightness * blueStrength), (float)(opacity * 0.33f));
            bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(pitchPlus4 - playerPosition.z(), yawPlus4 - smallYOffset);
            bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(pitch - playerPosition.z(), yawPlus4 - smallYOffset);
            bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(pitch - playerPosition.z(), yaw - smallYOffset);
            bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(pitchPlus4 - playerPosition.z(), yaw - smallYOffset);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }
}

