/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.fluids;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluid;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoneyFluidRendering {
    public static void renderSpecialHoneyFluid(BlockPos blockPos, BlockAndTintGetter level, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, TextureAtlasSprite[] sprites) {
        BlockState aboveState = level.getBlockState(blockPos.relative(Direction.UP));
        BlockState northState = level.getBlockState(blockPos.relative(Direction.NORTH));
        BlockState southState = level.getBlockState(blockPos.relative(Direction.SOUTH));
        BlockState westState = level.getBlockState(blockPos.relative(Direction.WEST));
        BlockState eastState = level.getBlockState(blockPos.relative(Direction.EAST));
        FluidState aboveFluid = aboveState.getFluidState();
        FluidState northFluid = northState.getFluidState();
        FluidState southFluid = southState.getFluidState();
        FluidState westFluid = westState.getFluidState();
        FluidState eastFluid = eastState.getFluidState();
        boolean isNotSameFluidAbove = !HoneyFluidRendering.isNeighborSameFluid(fluidState, aboveFluid);
        boolean shouldRenderUp = HoneyFluid.shouldRenderSide((BlockGetter)level, blockPos, Direction.UP, fluidState);
        boolean renderNorth = HoneyFluid.shouldRenderSide((BlockGetter)level, blockPos, Direction.NORTH, fluidState);
        boolean renderSouth = HoneyFluid.shouldRenderSide((BlockGetter)level, blockPos, Direction.SOUTH, fluidState);
        boolean renderWest = HoneyFluid.shouldRenderSide((BlockGetter)level, blockPos, Direction.WEST, fluidState);
        boolean renderEast = HoneyFluid.shouldRenderSide((BlockGetter)level, blockPos, Direction.EAST, fluidState);
        boolean renderDown = HoneyFluid.shouldRenderSide((BlockGetter)level, blockPos, Direction.DOWN, fluidState);
        if (isNotSameFluidAbove || shouldRenderUp || renderDown || renderEast || renderWest || renderNorth || renderSouth) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            float y;
            float r;
            float q;
            float p;
            float o;
            float downShade = level.getShade(Direction.DOWN, true);
            float upShade = level.getShade(Direction.UP, true);
            float northShade = level.getShade(Direction.NORTH, true);
            float westShade = level.getShade(Direction.WEST, true);
            Fluid fluid = fluidState.getType();
            float n = HoneyFluidRendering.getHeight(level, fluid, blockPos, blockState, fluidState);
            if (n >= 1.0f) {
                o = 1.0f;
                p = 1.0f;
                q = 1.0f;
                r = 1.0f;
            } else {
                float s = HoneyFluidRendering.getHeight(level, fluid, blockPos.north(), northState, northFluid);
                float t = HoneyFluidRendering.getHeight(level, fluid, blockPos.south(), southState, southFluid);
                float u = HoneyFluidRendering.getHeight(level, fluid, blockPos.east(), eastState, eastFluid);
                float v = HoneyFluidRendering.getHeight(level, fluid, blockPos.west(), westState, westFluid);
                o = HoneyFluidRendering.calculateAverageHeight(level, fluid, n, s, u, blockPos.relative(Direction.NORTH).relative(Direction.EAST));
                p = HoneyFluidRendering.calculateAverageHeight(level, fluid, n, s, v, blockPos.relative(Direction.NORTH).relative(Direction.WEST));
                q = HoneyFluidRendering.calculateAverageHeight(level, fluid, n, t, u, blockPos.relative(Direction.SOUTH).relative(Direction.EAST));
                r = HoneyFluidRendering.calculateAverageHeight(level, fluid, n, t, v, blockPos.relative(Direction.SOUTH).relative(Direction.WEST));
            }
            double renderX = blockPos.getX() & 0xF;
            double renderY = blockPos.getY() & 0xF;
            double renderZ = blockPos.getZ() & 0xF;
            float f = y = fluidState.isSource() ? 0.0f : (float)((Integer)fluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0f;
            if (isNotSameFluidAbove && !HoneyFluidRendering.isFaceOccludedByNeighbor((BlockGetter)level, blockPos, Direction.UP, Math.min(Math.min(p, r), Math.min(q, o)), aboveState) || shouldRenderUp) {
                float ai;
                float ah;
                p -= 0.001f;
                r -= 0.001f;
                q -= 0.001f;
                o -= 0.001f;
                Vec3 vec3 = fluidState.getFlow((BlockGetter)level, blockPos);
                if (vec3.x == 0.0 && vec3.z == 0.0) {
                    textureAtlasSprite = sprites[0];
                    u1 = textureAtlasSprite.getU(0.0f);
                    v1 = textureAtlasSprite.getV(0.0f);
                    u2 = u1;
                    v2 = textureAtlasSprite.getV(1.0f);
                    u3 = textureAtlasSprite.getU(1.0f);
                    v3 = v2;
                    u4 = u3;
                    v4 = v1;
                } else {
                    boolean isDiagonal = vec3.x % 1.0 != 0.0 || vec3.z % 1.0 != 0.0;
                    float sizing = 1.0f;
                    if (isDiagonal) {
                        textureAtlasSprite = sprites[3];
                        sizing = Math.abs(vec3.x()) == Math.abs(vec3.z()) ? 1.415f : 1.215f;
                    } else {
                        textureAtlasSprite = sprites[1];
                    }
                    ah = (float)Mth.atan2((double)vec3.z, (double)vec3.x) - 1.5707964f;
                    ai = Mth.sin((float)ah) * 0.25f * sizing;
                    float aj = Mth.cos((float)ah) * 0.25f * sizing;
                    u1 = textureAtlasSprite.getU(0.5f + (-aj - ai));
                    v1 = textureAtlasSprite.getV(0.5f - aj + ai);
                    u2 = textureAtlasSprite.getU(0.5f - aj + ai);
                    v2 = textureAtlasSprite.getV(0.5f + aj + ai);
                    u3 = textureAtlasSprite.getU(0.5f + aj + ai);
                    v3 = textureAtlasSprite.getV(0.5f + (aj - ai));
                    u4 = textureAtlasSprite.getU(0.5f + (aj - ai));
                    v4 = textureAtlasSprite.getV(0.5f + (-aj - ai));
                }
                float al = (u1 + u2 + u3 + u4) / 4.0f;
                ah = (v1 + v2 + v3 + v4) / 4.0f;
                ai = sprites[0].uvShrinkRatio();
                u1 = Mth.lerp((float)ai, (float)u1, (float)al);
                u2 = Mth.lerp((float)ai, (float)u2, (float)al);
                u3 = Mth.lerp((float)ai, (float)u3, (float)al);
                u4 = Mth.lerp((float)ai, (float)u4, (float)al);
                v1 = Mth.lerp((float)ai, (float)v1, (float)ah);
                v2 = Mth.lerp((float)ai, (float)v2, (float)ah);
                v3 = Mth.lerp((float)ai, (float)v3, (float)ah);
                v4 = Mth.lerp((float)ai, (float)v4, (float)ah);
                int uv2 = HoneyFluidRendering.getLightColor(level, blockPos);
                HoneyFluidRendering.vertex(vertexConsumer, renderX + 0.0, renderY + (double)p, renderZ + 0.0, upShade, upShade, upShade, u1, v1, uv2);
                HoneyFluidRendering.vertex(vertexConsumer, renderX + 0.0, renderY + (double)r, renderZ + 1.0, upShade, upShade, upShade, u2, v2, uv2);
                HoneyFluidRendering.vertex(vertexConsumer, renderX + 1.0, renderY + (double)q, renderZ + 1.0, upShade, upShade, upShade, u3, v3, uv2);
                HoneyFluidRendering.vertex(vertexConsumer, renderX + 1.0, renderY + (double)o, renderZ + 0.0, upShade, upShade, upShade, u4, v4, uv2);
                if (fluidState.shouldRenderBackwardUpFace((BlockGetter)level, blockPos.above())) {
                    HoneyFluidRendering.vertex(vertexConsumer, renderX + 0.0, renderY + (double)p, renderZ + 0.0, upShade, upShade, upShade, u1, v1, uv2);
                    HoneyFluidRendering.vertex(vertexConsumer, renderX + 1.0, renderY + (double)o, renderZ + 0.0, upShade, upShade, upShade, u4, v4, uv2);
                    HoneyFluidRendering.vertex(vertexConsumer, renderX + 1.0, renderY + (double)q, renderZ + 1.0, upShade, upShade, upShade, u3, v3, uv2);
                    HoneyFluidRendering.vertex(vertexConsumer, renderX + 0.0, renderY + (double)r, renderZ + 1.0, upShade, upShade, upShade, u2, v2, uv2);
                }
            }
            if (renderDown) {
                u1 = sprites[0].getU0();
                u2 = sprites[0].getU1();
                u3 = sprites[0].getV0();
                u4 = sprites[0].getV1();
                int ap = HoneyFluidRendering.getLightColor(level, blockPos.below());
                v2 = downShade;
                v3 = downShade;
                v4 = downShade;
                HoneyFluidRendering.downVertex(vertexConsumer, renderX, renderY + (double)y, renderZ + 1.0, v2, v3, v4, u1, u4, ap);
                HoneyFluidRendering.downVertex(vertexConsumer, renderX, renderY + (double)y, renderZ, v2, v3, v4, u1, u3, ap);
                HoneyFluidRendering.downVertex(vertexConsumer, renderX + 1.0, renderY + (double)y, renderZ, v2, v3, v4, u2, u3, ap);
                HoneyFluidRendering.downVertex(vertexConsumer, renderX + 1.0, renderY + (double)y, renderZ + 1.0, v2, v3, v4, u2, u4, ap);
            }
            int aq = HoneyFluidRendering.getLightColor(level, blockPos);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                double au;
                double at;
                double as;
                double ar;
                if (!(switch (direction) {
                    case Direction.NORTH -> {
                        u4 = p;
                        v1 = o;
                        ar = renderX;
                        as = renderX + 1.0;
                        at = renderZ + (double)0.001f;
                        au = renderZ + (double)0.001f;
                        yield renderNorth;
                    }
                    case Direction.SOUTH -> {
                        u4 = q;
                        v1 = r;
                        ar = renderX + 1.0;
                        as = renderX;
                        at = renderZ + 1.0 - (double)0.001f;
                        au = renderZ + 1.0 - (double)0.001f;
                        yield renderSouth;
                    }
                    case Direction.WEST -> {
                        u4 = r;
                        v1 = p;
                        ar = renderX + (double)0.001f;
                        as = renderX + (double)0.001f;
                        at = renderZ + 1.0;
                        au = renderZ;
                        yield renderWest;
                    }
                    default -> {
                        u4 = o;
                        v1 = q;
                        ar = renderX + 1.0 - (double)0.001f;
                        as = renderX + 1.0 - (double)0.001f;
                        at = renderZ;
                        au = renderZ + 1.0;
                        yield renderEast;
                    }
                }) || HoneyFluidRendering.isFaceOccludedByNeighbor((BlockGetter)level, blockPos, direction, Math.max(u4, v1), level.getBlockState(blockPos.relative(direction)))) continue;
                BlockPos blockPos2 = blockPos.relative(direction);
                TextureAtlasSprite textureAtlasSprite2 = sprites[1];
                Block block = level.getBlockState(blockPos2).getBlock();
                if (block instanceof HalfTransparentBlock || block instanceof LeavesBlock) {
                    textureAtlasSprite2 = sprites[0];
                }
                float av = textureAtlasSprite2.getU(0.0f);
                float aw = textureAtlasSprite2.getU(0.5f);
                float ax = textureAtlasSprite2.getV((1.0f - u4) * 0.5f);
                float ay = textureAtlasSprite2.getV((1.0f - v1) * 0.5f);
                float az = textureAtlasSprite2.getV(y == 0.0f ? 0.5f : 0.5f * (1.0f - y));
                float ba = direction.getAxis() == Direction.Axis.Z ? northShade : westShade;
                float bb = upShade * ba;
                float bc = upShade * ba;
                float bd = upShade * ba;
                HoneyFluidRendering.vertex(vertexConsumer, ar, renderY + (double)u4, at, bb, bc, bd, av, ax, aq);
                HoneyFluidRendering.vertex(vertexConsumer, as, renderY + (double)v1, au, bb, bc, bd, aw, ay, aq);
                HoneyFluidRendering.vertex(vertexConsumer, as, renderY + (double)y, au, bb, bc, bd, aw, az, aq);
                HoneyFluidRendering.vertex(vertexConsumer, ar, renderY + (double)y, at, bb, bc, bd, av, az, aq);
                if (textureAtlasSprite2 == sprites[0]) continue;
                HoneyFluidRendering.vertex(vertexConsumer, ar, renderY + (double)y, at, bb, bc, bd, av, az, aq);
                HoneyFluidRendering.vertex(vertexConsumer, as, renderY + (double)y, au, bb, bc, bd, aw, az, aq);
                HoneyFluidRendering.vertex(vertexConsumer, as, renderY + (double)v1, au, bb, bc, bd, aw, ay, aq);
                HoneyFluidRendering.vertex(vertexConsumer, ar, renderY + (double)u4, at, bb, bc, bd, av, ax, aq);
            }
        }
    }

    private static void vertex(VertexConsumer vertexConsumer, double x, double y, double z, float r, float g, float b, float u, float v, int uv2) {
        vertexConsumer.addVertex((float)x, (float)y, (float)z).setColor(r, g, b, 1.0f).setUv(u, v).setLight(uv2).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void downVertex(VertexConsumer vertexConsumer, double d, double e, double f, float g, float h, float i, float j, float k, int l) {
        vertexConsumer.addVertex((float)d, (float)e, (float)f).setColor(g, h, i, 1.0f).setUv(j, k).setLight(l).setNormal(0.0f, -1.0f, 0.0f);
    }

    private static boolean isNeighborSameFluid(FluidState fluidState, FluidState fluidState2) {
        return fluidState2.getType().isSame(fluidState.getType());
    }

    private static boolean isFaceOccludedByNeighbor(BlockGetter blockGetter, BlockPos blockPos, Direction direction, float f, BlockState blockState) {
        return HoneyFluidRendering.isFaceOccludedByState(blockGetter, direction, f, blockPos.relative(direction), blockState);
    }

    private static boolean isFaceOccludedByState(BlockGetter blockGetter, Direction direction, float f, BlockPos blockPos, BlockState blockState) {
        if (blockState.canOcclude()) {
            VoxelShape voxelShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)f, (double)1.0);
            VoxelShape voxelShape2 = blockState.getOcclusionShape(blockGetter, blockPos);
            return Shapes.blockOccudes((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (Direction)direction);
        }
        return false;
    }

    private static int getLightColor(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos) {
        int i = LevelRenderer.getLightColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
        int j = LevelRenderer.getLightColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos.above());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int m = i >> 16 & 0xFF;
        int n = j >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(m, n) << 16;
    }

    private static float calculateAverageHeight(BlockAndTintGetter blockAndTintGetter, Fluid fluid, float f, float g, float h, BlockPos blockPos) {
        if (!(h >= 1.0f) && !(g >= 1.0f)) {
            float[] fs = new float[2];
            if (h > 0.0f || g > 0.0f) {
                float i = HoneyFluidRendering.getHeight(blockAndTintGetter, fluid, blockPos);
                if (i >= 1.0f) {
                    return 1.0f;
                }
                HoneyFluidRendering.addWeightedHeight(fs, i);
            }
            HoneyFluidRendering.addWeightedHeight(fs, f);
            HoneyFluidRendering.addWeightedHeight(fs, h);
            HoneyFluidRendering.addWeightedHeight(fs, g);
            return fs[0] / fs[1];
        }
        return 1.0f;
    }

    private static void addWeightedHeight(float[] fs, float f) {
        if (f >= 0.8f) {
            fs[0] = fs[0] + f * 10.0f;
            fs[1] = fs[1] + 10.0f;
        } else if (f >= 0.0f) {
            fs[0] = fs[0] + f;
            fs[1] = fs[1] + 1.0f;
        }
    }

    private static float getHeight(BlockAndTintGetter blockAndTintGetter, Fluid fluid, BlockPos blockPos) {
        BlockState blockState = blockAndTintGetter.getBlockState(blockPos);
        return HoneyFluidRendering.getHeight(blockAndTintGetter, fluid, blockPos, blockState, blockState.getFluidState());
    }

    private static float getHeight(BlockAndTintGetter blockAndTintGetter, Fluid fluid, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (fluid.isSame(fluidState.getType())) {
            FluidState aboveFluidState = blockAndTintGetter.getFluidState(blockPos.above());
            boolean aboveFluidIsThisFluid = !aboveFluidState.isEmpty() && aboveFluidState.getType().isSame(fluid) && (aboveFluidState.isSource() || !aboveFluidState.is(BzTags.SPECIAL_HONEY_LIKE) || (Integer)aboveFluidState.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0);
            return aboveFluidIsThisFluid ? 1.0f : fluidState.getOwnHeight();
        }
        return !blockState.isSolid() ? 0.0f : -1.0f;
    }
}

