/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.essence;

import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.KnowingEssence;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class KnowingEssenceStructureMessage {
    private static final String SEPARATOR = "item.the_bumblezone.essence_knowing_separator";
    private static final String WITHIN_TEXT = "item.the_bumblezone.essence_knowing_within_text";
    private static final String WITHIN_TEXT_PLURAL = "item.the_bumblezone.essence_knowing_within_text_plural";
    private static final String FIRST_LETTER_REGEX = "\\b(.)(.*?)\\b";
    private static final Pattern FIRST_LETTER_PATTERN = Pattern.compile("\\b(.)(.*?)\\b");

    public static void inStructureMessage(Player player, GuiGraphics guiGraphics) {
        ItemStack offHandItem;
        String structureResourceLocationStrings;
        if (KnowingEssence.IsKnowingEssenceActive(player) && BzClientConfigs.knowingEssenceStructureNameClient && !(structureResourceLocationStrings = KnowingEssence.GetAllStructure(offHandItem = player.getOffhandItem())).isEmpty()) {
            Minecraft minecraft = Minecraft.getInstance();
            String[] structEntries = structureResourceLocationStrings.split(" ");
            MutableComponent line1 = null;
            MutableComponent line2 = null;
            MutableComponent line3 = null;
            int currentEntryIndex = 0;
            if (GeneralUtilsClient.isAdvancedToolTipActive()) {
                for (String structEntry : structEntries) {
                    int currentLine = currentEntryIndex % 3;
                    if (currentLine == 0) {
                        line1 = line1 != null ? Component.translatable((String)SEPARATOR, (Object[])new Object[]{line1, Component.literal((String)structEntry)}) : Component.literal((String)structEntry);
                    } else if (currentLine == 1) {
                        line2 = line2 != null ? Component.translatable((String)SEPARATOR, (Object[])new Object[]{line2, Component.literal((String)structEntry)}) : Component.literal((String)structEntry);
                    } else if (currentLine == 2) {
                        line3 = line3 != null ? Component.translatable((String)SEPARATOR, (Object[])new Object[]{line3, Component.literal((String)structEntry)}) : Component.literal((String)structEntry);
                    }
                    ++currentEntryIndex;
                }
            } else {
                for (String structEntry : structEntries) {
                    int currentLine = currentEntryIndex % 3;
                    String langKey = KnowingEssenceStructureMessage.transformStructureToLangKey(structEntry);
                    Language language = Language.getInstance();
                    if (!language.has(langKey)) {
                        langKey = structEntry.split(":")[1].replace("_", " ").replace("/", " ");
                        langKey = FIRST_LETTER_PATTERN.matcher(langKey).replaceAll(matchResult -> matchResult.group(1).toUpperCase() + matchResult.group(2));
                    }
                    if (currentLine == 0) {
                        line1 = line1 != null ? Component.translatable((String)SEPARATOR, (Object[])new Object[]{line1, Component.translatable((String)langKey)}) : Component.translatable((String)langKey);
                    } else if (currentLine == 1) {
                        line2 = line2 != null ? Component.translatable((String)SEPARATOR, (Object[])new Object[]{line2, Component.translatable((String)langKey)}) : Component.translatable((String)langKey);
                    } else if (currentLine == 2) {
                        line3 = line3 != null ? Component.translatable((String)SEPARATOR, (Object[])new Object[]{line3, Component.translatable((String)langKey)}) : Component.translatable((String)langKey);
                    }
                    ++currentEntryIndex;
                }
            }
            KnowingEssenceStructureMessage.renderScrollingString(minecraft, guiGraphics, line1, line2, line3);
        }
    }

    private static String transformStructureToLangKey(String resourceLocation) {
        return "structure." + resourceLocation.replace(":", ".");
    }

    public static void renderScrollingString(Minecraft minecraft, GuiGraphics guiGraphics, Component line1, Component line2, Component line3) {
        int linesToMake = 0;
        if (line1 != null) {
            ++linesToMake;
        }
        if (line2 != null) {
            ++linesToMake;
        }
        if (line3 != null) {
            ++linesToMake;
        }
        guiGraphics.drawString(minecraft.font, (Component)Component.translatable((String)(line2 == null ? WITHIN_TEXT : WITHIN_TEXT_PLURAL)), 4, guiGraphics.guiHeight() - 12 - 10 * linesToMake, -50, true);
        if (line1 != null) {
            KnowingEssenceStructureMessage.renderScrollingString(minecraft, guiGraphics, line1, 0);
        }
        if (line2 != null) {
            KnowingEssenceStructureMessage.renderScrollingString(minecraft, guiGraphics, line2, 20);
        }
        if (line3 != null) {
            KnowingEssenceStructureMessage.renderScrollingString(minecraft, guiGraphics, line3, 40);
        }
    }

    public static void renderScrollingString(Minecraft minecraft, GuiGraphics guiGraphics, Component component, int yOffset) {
        int startOfHotbar = (guiGraphics.guiWidth() - 250) / 2;
        GeneralUtilsClient.renderScrollingString(guiGraphics, minecraft.font, component, BzClientConfigs.knowingEssenceStructureNameXCoord, guiGraphics.guiHeight() - BzClientConfigs.knowingEssenceStructureNameYCoord - yOffset, BzClientConfigs.knowingEssenceStructureNameXCoord + startOfHotbar, guiGraphics.guiHeight(), 16769168);
    }
}

