/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.essence;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.items.essence.KnowingEssence;
import com.telepathicgrunt.the_bumblezone.mixin.client.LevelRendererAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector4d;

public class KnowingEssenceLootBlockOutlining {
    private static final double DRAW_RADIUS = 0.45;
    private static final double MIN_CORNER = 0.04999999999999999;
    private static final double MAX_CORNER = 0.95;
    private static final Vector4d VECTOR_4D_MIN = new Vector4d(0.04999999999999999, 0.04999999999999999, 0.04999999999999999, 1.0);
    private static final Vector4d VECTOR_4D_MAX = new Vector4d(0.95, 0.95, 0.95, 1.0);

    public static void outlineLootBlocks(PoseStack poseStack, Camera camera, LevelRenderer levelRenderer) {
        Player player = GeneralUtilsClient.getClientPlayer();
        if (KnowingEssence.IsKnowingEssenceActive(player)) {
            Level level = player.level();
            Vec3 cameraPos = camera.getPosition();
            BlockPos worldSpot = BlockPos.containing((Position)cameraPos);
            poseStack.pushPose();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.disableDepthTest();
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
            boolean drewLines = false;
            int chunkRadius = 4;
            ChunkPos centerChunkPos = new ChunkPos(worldSpot);
            for (int x = -chunkRadius; x <= chunkRadius; ++x) {
                for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                    LevelChunk chunk = level.getChunk(x + centerChunkPos.x, z + centerChunkPos.z);
                    for (Map.Entry blockEntityEntry : chunk.getBlockEntities().entrySet()) {
                        BlockEntity blockEntity = (BlockEntity)blockEntityEntry.getValue();
                        BlockState blockState = blockEntity.getBlockState();
                        Block block = blockState.getBlock();
                        if (!blockState.is(BzTags.KNOWING_BLOCK_ENTITY_FORCED_HIGHLIGHTING) && !(blockEntity instanceof RandomizableContainerBlockEntity) && !(blockEntity instanceof BrushableBlockEntity) && !(blockEntity instanceof EnderChestBlockEntity) && !(block instanceof EnderChestBlock) || blockState.is(BzTags.KNOWING_BLOCK_ENTITY_PREVENT_HIGHLIGHTING)) continue;
                        BlockPos lootBlockPos = (BlockPos)blockEntityEntry.getKey();
                        if (!((LevelRendererAccessor)levelRenderer).getCullingFrustum().isVisible(new AABB((double)lootBlockPos.getX() + 0.04999999999999999, (double)lootBlockPos.getY() + 0.04999999999999999, (double)lootBlockPos.getZ() + 0.04999999999999999, (double)lootBlockPos.getX() + 0.95, (double)lootBlockPos.getY() + 0.95, (double)lootBlockPos.getZ() + 0.95))) continue;
                        int colorInt = block.defaultMapColor().col;
                        int red = FastColor.ARGB32.red((int)colorInt);
                        int green = FastColor.ARGB32.green((int)colorInt);
                        int blue = FastColor.ARGB32.blue((int)colorInt);
                        KnowingEssenceLootBlockOutlining.renderLineBox(bufferbuilder, poseStack.last().pose(), (float)(VECTOR_4D_MIN.x() + (double)lootBlockPos.getX() - cameraPos.x()), (float)(VECTOR_4D_MIN.y() + (double)lootBlockPos.getY() - cameraPos.y()), (float)(VECTOR_4D_MIN.z() + (double)lootBlockPos.getZ() - cameraPos.z()), (float)(VECTOR_4D_MAX.x() + (double)lootBlockPos.getX() - cameraPos.x()), (float)(VECTOR_4D_MAX.y() + (double)lootBlockPos.getY() - cameraPos.y()), (float)(VECTOR_4D_MAX.z() + (double)lootBlockPos.getZ() - cameraPos.z()), red, green, blue, 255);
                        drewLines = true;
                    }
                }
            }
            if (drewLines) {
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            }
            poseStack.popPose();
            RenderSystem.enableDepthTest();
            RenderType.cutout().clearRenderState();
        }
    }

    private static void renderLineBox(BufferBuilder builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue, int alpha) {
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(-1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(-1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
    }
}

