/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.datacomponents.BumbleBeeChestplateData;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.BumbleBeeChestplate;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BeeArmorModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation VARIANT_1_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"bee_armor"), "bee_armor");
    public static final ModelLayerLocation VARIANT_2_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"bee_armor"), "bee_armor_2");
    protected final EquipmentSlot slot;
    public LivingEntity entityLiving;
    public final ModelPart leftWing;
    public final ModelPart rightWing;
    public final ModelPart leftPollen;
    public final ModelPart rightPollen;
    public final ModelPart trueRightLeg;
    public final ModelPart trueLeftLeg;
    public final ModelPart bootRight;
    public final ModelPart bootLeft;

    public BeeArmorModel(ModelPart part, EquipmentSlot slot, LivingEntity livingEntity) {
        super(part);
        this.slot = slot;
        this.entityLiving = livingEntity;
        this.leftWing = part.getChild("body").getChild("left_wing");
        this.rightWing = part.getChild("body").getChild("right_wing");
        this.leftPollen = part.getChild("left_leg").getChild("true_left_leg").getChild("pollen_left");
        this.rightPollen = part.getChild("right_leg").getChild("true_right_leg").getChild("pollen_right");
        this.trueLeftLeg = part.getChild("left_leg").getChild("true_left_leg");
        this.trueRightLeg = part.getChild("right_leg").getChild("true_right_leg");
        this.bootRight = part.getChild("right_leg").getChild("right_boot");
        this.bootLeft = part.getChild("left_leg").getChild("left_boot");
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int light, int overlay, int packedColor) {
        this.setAllVisible(false);
        switch (this.slot) {
            case HEAD: {
                this.head.visible = true;
                this.hat.visible = true;
                this.head.render(poseStack, buffer, light, overlay);
                break;
            }
            case CHEST: {
                this.body.visible = true;
                this.rightArm.visible = true;
                this.leftArm.visible = true;
                ItemStack itemStack = BumbleBeeChestplate.getEntityBeeChestplate(this.entityLiving);
                if (!itemStack.isEmpty() && ((BumbleBeeChestplateData)itemStack.get((DataComponentType)BzDataComponents.BUMBLEBEE_CHESTPLATE_DATA.get())).isFlying()) {
                    BeeArmor beeArmor;
                    long time = System.currentTimeMillis();
                    double currentProg = Math.abs(Math.sin((double)time / 40.0));
                    this.leftWing.yRot = -45.0f;
                    this.leftWing.xRot = (float)Mth.lerp((double)currentProg, (double)-0.5, (double)1.5);
                    this.rightWing.yRot = 45.0f;
                    this.rightWing.xRot = (float)Mth.lerp((double)currentProg, (double)-0.5, (double)1.5);
                    Item item = itemStack.getItem();
                    if (item instanceof BeeArmor && (beeArmor = (BeeArmor)item).getVariant() == 2) {
                        this.rightWing.zRot = 0.0f;
                        this.leftWing.yRot = -44.5f;
                    }
                } else {
                    BeeArmor beeArmor;
                    Item item = itemStack.getItem();
                    if (item instanceof BeeArmor && (beeArmor = (BeeArmor)item).getVariant() == 2) {
                        this.leftWing.yRot = -0.2f;
                        this.leftWing.xRot = -0.15f;
                        this.rightWing.yRot = 0.2f;
                        this.rightWing.xRot = -0.2f;
                        this.rightWing.zRot = -0.5f;
                    } else {
                        this.leftWing.yRot = -0.6f;
                        this.leftWing.xRot = -0.2f;
                        this.rightWing.yRot = 0.6f;
                        this.rightWing.xRot = -0.2f;
                    }
                }
                this.body.render(poseStack, buffer, light, overlay);
                break;
            }
            case LEGS: {
                this.body.visible = true;
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                this.trueRightLeg.visible = true;
                this.trueLeftLeg.visible = true;
                this.bootRight.visible = false;
                this.bootLeft.visible = false;
                ItemStack itemStack = HoneyBeeLeggings.getEntityBeeLegging(this.entityLiving);
                if (!itemStack.isEmpty() && HoneyBeeLeggings.isPollinated(itemStack)) {
                    this.leftPollen.visible = true;
                    this.rightPollen.visible = true;
                } else {
                    this.leftPollen.visible = false;
                    this.rightPollen.visible = false;
                }
                this.leftLeg.render(poseStack, buffer, light, overlay);
                this.rightLeg.render(poseStack, buffer, light, overlay);
                break;
            }
            case FEET: {
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                this.bootRight.visible = true;
                this.bootLeft.visible = true;
                this.trueRightLeg.visible = false;
                this.trueLeftLeg.visible = false;
                this.leftLeg.render(poseStack, buffer, light, overlay);
                this.rightLeg.render(poseStack, buffer, light, overlay);
            }
        }
    }

    public static LayerDefinition createVariant1() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition armorHead = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -9.0f, -6.0f, 10.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition cube_r1 = armorHead.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(28, 82).addBox(1.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 82).addBox(-3.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 89).addBox(2.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(20, 89).addBox(-3.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = armorHead.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(40, 82).addBox(-3.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 82).addBox(2.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition armorBody = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 21).addBox(-4.505f, 4.0f, -2.505f, 9.01f, 8.0f, 5.01f, new CubeDeformation(0.0f)).texOffs(32, 66).addBox(-3.5f, 2.0f, -2.5f, 7.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 82).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition cube_r3 = armorBody.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(36, 82).addBox(-1.0f, 6.5f, -9.25f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = armorBody.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)-1.82f, (float)3.1027f, (float)2.1854f));
        PartDefinition LeftWing_r1 = left_wing.addOrReplaceChild("LeftWing_r1", CubeListBuilder.create().texOffs(0, 89).addBox(-0.25f, -2.75f, 3.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 87).addBox(-0.25f, -0.75f, 4.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(3, 89).addBox(-0.25f, -1.75f, 6.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 90).addBox(-0.25f, -2.75f, 7.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 91).addBox(-0.25f, -4.75f, 4.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(2, 93).addBox(-0.25f, -5.75f, 5.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(3, 91).addBox(-0.25f, -4.75f, 6.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(3, 93).addBox(-0.25f, -6.75f, 6.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(5, 91).addBox(-0.25f, -5.75f, 8.5f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5623f, (float)-3.1027f, (float)-2.1854f, (float)-0.6695f, (float)0.7911f, (float)1.3711f));
        PartDefinition right_wing = armorBody.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)2.0946f, (float)2.7065f, (float)2.1491f));
        PartDefinition RightWing_r1 = right_wing.addOrReplaceChild("RightWing_r1", CubeListBuilder.create().texOffs(12, 91).addBox(-1.0f, -10.25f, 3.75f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 93).addBox(-1.0f, -11.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(10, 91).addBox(-1.0f, -9.25f, 1.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 93).addBox(-1.0f, -10.25f, 0.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 91).addBox(-1.0f, -9.25f, -0.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 90).addBox(-1.0f, -7.25f, 2.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 89).addBox(-1.0f, -6.25f, 1.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 87).addBox(-1.0f, -5.25f, -0.25f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(7, 89).addBox(-1.0f, -7.25f, -1.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0946f, (float)-2.7065f, (float)-2.1491f, (float)-0.9071f, (float)0.8312f, (float)1.7963f));
        PartDefinition right_leg_main = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = right_leg_main.addOrReplaceChild("true_right_leg", CubeListBuilder.create().texOffs(20, 37).addBox(-2.75f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_right = right_leg.addOrReplaceChild("pollen_right", CubeListBuilder.create().texOffs(40, 37).addBox(1.005f, 1.25f, -2.995f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition bootRight = right_leg_main.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(52, 44).addBox(-1.0f, 6.25f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 96).addBox(-3.0f, 7.0f, -4.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_main = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = left_leg_main.addOrReplaceChild("true_left_leg", CubeListBuilder.create().texOffs(0, 37).addBox(-2.25f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_left = left_leg.addOrReplaceChild("pollen_left", CubeListBuilder.create().texOffs(0, 50).addBox(3.0f, 1.25f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition bootLeft = left_leg_main.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(0, 96).addBox(-3.0f, 7.0f, -4.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(52, 44).addBox(-1.0f, 6.25f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static LayerDefinition createVariant2() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition armorHead = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -9.0f, -6.0f, 10.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.25f, (float)0.0f));
        PartDefinition antennas = armorHead.addOrReplaceChild("antennas", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.0f, (float)3.0f));
        PartDefinition cube_r1 = antennas.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(28, 82).addBox(1.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 82).addBox(-3.5f, -14.0f, 6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 89).addBox(2.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(20, 89).addBox(-3.0f, -12.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = antennas.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(40, 82).addBox(-3.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 82).addBox(2.0f, -12.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition armorBody = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 19).addBox(-4.505f, 0.0f, -2.505f, 9.01f, 12.0f, 5.01f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition cube_r3 = armorBody.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(36, 82).addBox(-0.5f, 0.5f, 0.75f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = armorBody.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)2.0946f, (float)2.9565f, (float)2.3991f));
        PartDefinition RightWing_r1 = right_wing.addOrReplaceChild("RightWing_r1", CubeListBuilder.create().texOffs(13, 77).addBox(-1.0f, -10.25f, 3.75f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 85).addBox(-1.0f, -9.25f, 1.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 82).addBox(-1.0f, -11.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(6, 86).addBox(-1.0f, -10.25f, 0.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 86).addBox(-1.0f, -6.25f, 1.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(3, 86).addBox(-1.0f, -7.25f, 2.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 85).addBox(-1.0f, -9.25f, -0.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 77).addBox(-1.0f, -5.25f, -0.25f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 85).addBox(-1.0f, -7.25f, -1.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8446f, (float)-2.9565f, (float)-2.8991f, (float)-0.9071f, (float)0.8312f, (float)1.7963f));
        PartDefinition left_wing = armorBody.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)-2.1554f, (float)2.9565f, (float)2.3991f));
        PartDefinition LeftWing_r1 = left_wing.addOrReplaceChild("LeftWing_r1", CubeListBuilder.create().texOffs(5, 74).addBox(-1.0f, -10.25f, 1.75f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(5, 82).addBox(-1.0f, -8.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 85).addBox(-1.0f, -9.25f, 4.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 86).addBox(-1.0f, -7.25f, 3.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 86).addBox(-1.0f, -8.25f, -0.25f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(3, 86).addBox(-1.0f, -9.25f, 0.75f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 82).addBox(-1.0f, -6.25f, 1.75f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 82).addBox(-1.0f, -5.25f, -0.25f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 80).addBox(-1.0f, -7.25f, -1.25f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8446f, (float)-2.9565f, (float)-2.8991f, (float)-0.9071f, (float)0.8312f, (float)1.7963f));
        PartDefinition right_leg_main = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = right_leg_main.addOrReplaceChild("true_right_leg", CubeListBuilder.create().texOffs(0, 37).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_right = right_leg.addOrReplaceChild("pollen_right", CubeListBuilder.create().texOffs(40, 37).addBox(-2.995f, 1.5f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_boot = right_leg_main.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(0, 96).addBox(-3.0f, 7.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.005f)).texOffs(22, 107).addBox(-2.901f, 7.9f, -2.1f, 5.0f, 4.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_main = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = left_leg_main.addOrReplaceChild("true_left_leg", CubeListBuilder.create().texOffs(20, 37).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pollen_left = left_leg.addOrReplaceChild("pollen_left", CubeListBuilder.create().texOffs(0, 50).addBox(0.005f, 1.5f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_boot = left_leg_main.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(0, 96).addBox(-2.0f, 7.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.005f)).texOffs(22, 98).addBox(-2.099f, 7.9f, -2.1f, 5.0f, 4.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }
}

