/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.items;

import com.telepathicgrunt.the_bumblezone.datacomponents.HoneyCompassTargetData;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HoneyCompassItemProperty {
    public static ClampedItemPropertyFunction getClampedItemPropertyFunction() {
        return new ClampedItemPropertyFunction(){
            private final CompassWobble wobble = new CompassWobble();
            private final CompassWobble wobbleRandom = new CompassWobble();

            public float unclampedCall(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : itemStack.getEntityRepresentation();
                if (entity == null) {
                    return 0.0f;
                }
                if (clientLevel == null && entity.level() instanceof ClientLevel) {
                    clientLevel = (ClientLevel)entity.level();
                }
                if (clientLevel == null) {
                    return 0.0f;
                }
                BlockPos blockPos = this.getStructurePosition((Level)clientLevel, itemStack);
                long gameTime = clientLevel.getGameTime();
                if (blockPos != null && !(entity.position().distanceToSqr((double)blockPos.getX() + 0.5, entity.position().y(), (double)blockPos.getZ() + 0.5) < (double)1.0E-5f)) {
                    double angleToRender;
                    boolean isLocalPlayer = livingEntity instanceof Player && ((Player)livingEntity).isLocalPlayer();
                    double currentFacingAngle = 0.0;
                    if (isLocalPlayer) {
                        currentFacingAngle = livingEntity.getYRot();
                    } else if (entity instanceof ItemFrame) {
                        currentFacingAngle = this.getFrameRotation((ItemFrame)entity);
                    } else if (entity instanceof ItemEntity) {
                        currentFacingAngle = 180.0f - ((ItemEntity)entity).getSpin(0.5f) / ((float)Math.PI * 2) * 360.0f;
                    } else if (livingEntity != null) {
                        currentFacingAngle = livingEntity.yBodyRot;
                    }
                    currentFacingAngle = Mth.positiveModulo((double)(currentFacingAngle / 360.0), (double)1.0);
                    double angleToTarget = this.getAngleTo(Vec3.atCenterOf((Vec3i)blockPos), (Entity)entity) / 6.2831854820251465;
                    if (isLocalPlayer) {
                        if (this.wobble.shouldUpdate(gameTime)) {
                            this.wobble.update(gameTime, 0.5 - (currentFacingAngle - 0.25));
                        }
                        angleToRender = angleToTarget + this.wobble.rotation;
                    } else {
                        angleToRender = 0.5 - (currentFacingAngle - 0.25 - angleToTarget);
                    }
                    return Mth.positiveModulo((float)((float)angleToRender), (float)1.0f);
                }
                if (this.wobbleRandom.shouldUpdate(gameTime)) {
                    this.wobbleRandom.update(gameTime, Math.random());
                }
                double d = this.wobbleRandom.rotation + (double)((float)this.hash(i) / 2.1474836E9f);
                return Mth.positiveModulo((float)((float)d), (float)1.0f);
            }

            private int hash(int i) {
                return i * 1327217883;
            }

            @Nullable
            private BlockPos getStructurePosition(Level level, ItemStack itemStack) {
                Optional<ResourceKey<Level>> optional;
                HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
                boolean structurePos = honeyCompassTargetData.targetPos().isPresent();
                boolean dimension = honeyCompassTargetData.targetDimension().isPresent();
                if (structurePos && dimension && (optional = honeyCompassTargetData.targetDimension()).isPresent() && level.dimension() == optional.get()) {
                    return honeyCompassTargetData.targetPos().orElse(BlockPos.ZERO);
                }
                return null;
            }

            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.getDirection();
                int itemFrameFacingAngle = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
                return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + itemFrame.getRotation() * 45 + itemFrameFacingAngle));
            }

            private double getAngleTo(Vec3 vec3, Entity entity) {
                return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX());
            }
        };
    }

    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long currentTick) {
            return this.lastUpdateTick != currentTick;
        }

        void update(long lastTick, double currentRotation) {
            this.lastUpdateTick = lastTick;
            double rotDiff = currentRotation - this.rotation;
            rotDiff = Mth.positiveModulo((double)(rotDiff + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += rotDiff * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.positiveModulo((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

