/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.telepathicgrunt.the_bumblezone.client.BeehemothControls;
import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.client.armor.BeeArmorModelProvider;
import com.telepathicgrunt.the_bumblezone.client.armor.FlowerHeadwearModelProvider;
import com.telepathicgrunt.the_bumblezone.client.blockentityrenderer.EssenceBlockEntityRenderer;
import com.telepathicgrunt.the_bumblezone.client.blocks.ConnectedBlockModel;
import com.telepathicgrunt.the_bumblezone.client.dimension.BzDimensionSpecialEffects;
import com.telepathicgrunt.the_bumblezone.client.items.FlowerHeadwearColoring;
import com.telepathicgrunt.the_bumblezone.client.items.HoneyCompassItemProperty;
import com.telepathicgrunt.the_bumblezone.client.items.InfinityBarrierColoring;
import com.telepathicgrunt.the_bumblezone.client.items.PotionCandleColoring;
import com.telepathicgrunt.the_bumblezone.client.particles.DustParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.HoneyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.PollenPuffParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.RoyalJellyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.SparkleParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.VoiceParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.WindParticle;
import com.telepathicgrunt.the_bumblezone.client.rendering.HiddenEffectIconRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.armor.BeeArmorModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.armor.FlowerHeadwearModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.electricring.ElectricRingModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.electricring.ElectricRingRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeyslime.HoneySlimeRendering;
import com.telepathicgrunt.the_bumblezone.client.rendering.pileofpollen.PileOfPollenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.purplespike.PurpleSpikeModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.purplespike.PurpleSpikeRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.sentrywatcher.SentryWatcherModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.sentrywatcher.SentryWatcherRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.variantbee.BackupVariantBeeModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.variantbee.BackupVariantBeeRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.variantbee.VariantBeeRenderer;
import com.telepathicgrunt.the_bumblezone.client.screens.BuzzingBriefcaseScreen;
import com.telepathicgrunt.the_bumblezone.client.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.client.screens.StrictChestScreen;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.datacomponents.AbilityEssenceCooldownData;
import com.telepathicgrunt.the_bumblezone.events.client.BlockRenderedOnScreenEvent;
import com.telepathicgrunt.the_bumblezone.events.client.ClientSetupEnqueuedEvent;
import com.telepathicgrunt.the_bumblezone.events.client.ClientTickEvent;
import com.telepathicgrunt.the_bumblezone.events.client.KeyInputEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterArmorProviderEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterBlockColorEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterBlockEntityRendererEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterDimensionEffectsEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEffectRenderersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEntityLayersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEntityRenderersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterItemColorEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterItemPropertiesEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterKeyMappingEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterMenuScreenEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterParticleEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterRenderTypeEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterShaderEvent;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerTickEvent;
import com.telepathicgrunt.the_bumblezone.items.BeeCannon;
import com.telepathicgrunt.the_bumblezone.items.CrystalCannon;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.BlockEntityRenderersAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.client.ClientLevelAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzClientFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.FactoryManager;
import java.util.HashSet;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BrushableBlockRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;

public class BumblezoneClient {
    public static final Function<ResourceLocation, RenderType> ENTITY_CUTOUT_EMISSIVE_RENDER_TYPE = Util.memoize(resourceLocation -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENERGY_SWIRL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setTransparencyState(RenderStateShard.NO_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setOverlayState(RenderStateShard.NO_OVERLAY).createCompositeState(false);
        return RenderType.create((String)"the_bumblezone:entity_cutout_emissive", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)compositeState);
    });
    public static final Function<ResourceLocation, RenderType> ENTITY_TRANSPARENT_EMISSIVE_RENDER_TYPE = Util.memoize(resourceLocation -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENERGY_SWIRL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setOverlayState(RenderStateShard.NO_OVERLAY).createCompositeState(false);
        return RenderType.create((String)"the_bumblezone:entity_transparent_emissive", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)compositeState);
    });

    public static void init() {
        FactoryManager.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"connected"), (AthenaModelFactory)ConnectedBlockModel.FACTORY);
        PlayerTickEvent.CLIENT_EVENT.addListener(MusicHandler::tickMusicFader);
        RegisterParticleEvent.EVENT.addListener(BumblezoneClient::onParticleSetup);
        RegisterEntityRenderersEvent.EVENT.addListener(BumblezoneClient::registerEntityRenderers);
        RegisterEntityLayersEvent.EVENT.addListener(BumblezoneClient::registerEntityLayers);
        RegisterKeyMappingEvent.EVENT.addListener(BumblezoneClient::registerKeyBinding);
        RegisterDimensionEffectsEvent.EVENT.addListener(BumblezoneClient::registerDimensionEffects);
        RegisterShaderEvent.EVENT.addListener(BumblezoneClient::registerShaders);
        RegisterBlockColorEvent.EVENT.addListener(InfinityBarrierColoring::registerBlockColors);
        RegisterBlockColorEvent.EVENT.addListener(PotionCandleColoring::registerBlockColors);
        RegisterItemColorEvent.EVENT.addListener(PotionCandleColoring::registerItemColors);
        RegisterItemColorEvent.EVENT.addListener(FlowerHeadwearColoring::registerItemColors);
        ClientTickEvent.EVENT.addListener(event -> {
            if (event.end()) {
                StinglessBeeHelmet.decrementHighlightingCounter(GeneralUtilsClient.getClientPlayer());
            }
        });
        ClientSetupEnqueuedEvent.EVENT.addListener(BumblezoneClient::clientSetup);
        BlockRenderedOnScreenEvent.EVENT.addListener(PileOfPollenRenderer::pileOfPollenOverlay);
        KeyInputEvent.EVENT.addListener(BeehemothControls::keyInput);
        RegisterMenuScreenEvent.EVENT.addListener(BumblezoneClient::registerScreens);
        RegisterItemPropertiesEvent.EVENT.addListener(BumblezoneClient::registerItemProperties);
        RegisterRenderTypeEvent.EVENT.addListener(BumblezoneClient::registerRenderTypes);
        RegisterArmorProviderEvent.EVENT.addListener(BumblezoneClient::registerArmorProviders);
        RegisterEffectRenderersEvent.EVENT.addListener(BumblezoneClient::registerEffectRenderers);
        RegisterBlockEntityRendererEvent.EVENT.addListener(BumblezoneClient::registerBlockEntityRenderers);
        BzClientFluids.CLIENT_FLUIDS.init();
    }

    public static void clientSetup(ClientSetupEnqueuedEvent event) {
        HashSet<Item> particleMarkerBlocks = new HashSet<Item>(ClientLevelAccessor.getMARKER_PARTICLE_ITEMS());
        particleMarkerBlocks.add((Item)BzItems.HEAVY_AIR.get());
        ClientLevelAccessor.setMARKER_PARTICLE_ITEMS(particleMarkerBlocks);
    }

    public static void registerBlockEntityRenderers(RegisterBlockEntityRendererEvent<?> event) {
        BlockEntityRenderersAccessor.bumblezone$callRegister((BlockEntityType)BzBlockEntities.ESSENCE_BLOCK.get(), EssenceBlockEntityRenderer::new);
        BlockEntityRenderersAccessor.bumblezone$callRegister((BlockEntityType)BzBlockEntities.STATE_FOCUSED_BRUSHABLE_BLOCK_ENTITY.get(), BrushableBlockRenderer::new);
    }

    public static void registerEffectRenderers(RegisterEffectRenderersEvent event) {
        event.register((Holder<MobEffect>)BzEffects.HIDDEN.holder(), new HiddenEffectIconRenderer());
    }

    public static void registerArmorProviders(RegisterArmorProviderEvent event) {
        event.register((Item)BzItems.FLOWER_HEADWEAR.get(), FlowerHeadwearModelProvider::new);
        event.register((Item)BzItems.STINGLESS_BEE_HELMET_1.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.STINGLESS_BEE_HELMET_2.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.BUMBLE_BEE_CHESTPLATE_1.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.BUMBLE_BEE_CHESTPLATE_2.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.TRANS_BUMBLE_BEE_CHESTPLATE_1.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.TRANS_BUMBLE_BEE_CHESTPLATE_2.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.HONEY_BEE_LEGGINGS_1.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.HONEY_BEE_LEGGINGS_2.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.CARPENTER_BEE_BOOTS_1.get(), BeeArmorModelProvider::new);
        event.register((Item)BzItems.CARPENTER_BEE_BOOTS_2.get(), BeeArmorModelProvider::new);
    }

    public static void registerKeyBinding(RegisterKeyMappingEvent event) {
        event.register(BeehemothControls.KEY_BIND_BEEHEMOTH_UP);
        event.register(BeehemothControls.KEY_BIND_BEEHEMOTH_DOWN);
    }

    private static void registerScreens(RegisterMenuScreenEvent event) {
        event.register((MenuType)BzMenuTypes.STRICT_9x1.get(), StrictChestScreen::new);
        event.register((MenuType)BzMenuTypes.STRICT_9x2.get(), StrictChestScreen::new);
        event.register((MenuType)BzMenuTypes.STRICT_9x3.get(), StrictChestScreen::new);
        event.register((MenuType)BzMenuTypes.STRICT_9x4.get(), StrictChestScreen::new);
        event.register((MenuType)BzMenuTypes.STRICT_9x5.get(), StrictChestScreen::new);
        event.register((MenuType)BzMenuTypes.STRICT_9x6.get(), StrictChestScreen::new);
        event.register((MenuType)BzMenuTypes.CRYSTALLINE_FLOWER.get(), CrystallineFlowerScreen::new);
        event.register((MenuType)BzMenuTypes.BUZZING_BRIEFCASE.get(), BuzzingBriefcaseScreen::new);
    }

    private static void registerItemProperties(RegisterItemPropertiesEvent event) {
        event.register((Item)BzItems.HONEY_CRYSTAL_SHIELD.get(), ResourceLocation.withDefaultNamespace((String)"blocking"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
        event.register((Item)BzItems.STINGER_SPEAR.get(), ResourceLocation.withDefaultNamespace((String)"throwing"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
        event.register((Item)BzItems.HONEY_COMPASS.get(), ResourceLocation.withDefaultNamespace((String)"angle"), HoneyCompassItemProperty.getClampedItemPropertyFunction());
        event.register((Item)BzItems.BEE_CANNON.get(), ResourceLocation.withDefaultNamespace((String)"primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
        event.register((Item)BzItems.CRYSTAL_CANNON.get(), ResourceLocation.withDefaultNamespace((String)"primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
        event.register((Item)BzItems.BEE_CANNON.get(), ResourceLocation.withDefaultNamespace((String)"bee_count"), (itemStack, world, livingEntity, int1) -> (float)BeeCannon.getNumberOfBees(itemStack) / 10.0f);
        event.register((Item)BzItems.CRYSTAL_CANNON.get(), ResourceLocation.withDefaultNamespace((String)"crystal_count"), (itemStack, world, livingEntity, int1) -> (float)CrystalCannon.getNumberOfCrystals(itemStack) / 10.0f);
        event.register((Item)BzItems.CRYSTAL_CANNON.get(), ResourceLocation.withDefaultNamespace((String)"crystal_count"), (itemStack, world, livingEntity, int1) -> (float)CrystalCannon.getNumberOfCrystals(itemStack) / 10.0f);
        event.register((Item)BzItems.HONEYCOMB_BROOD.get(), ResourceLocation.withDefaultNamespace((String)"is_creative_tab_icon"), (itemStack, world, livingEntity, integer) -> itemStack.getComponents().has(DataComponents.CUSTOM_DATA) && ((CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA)).contains("isCreativeTabIcon") && ((CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA)).getUnsafe().getBoolean("isCreativeTabIcon") ? 1.0f : 0.0f);
        event.register((Item)BzItems.HONEY_BEE_LEGGINGS_1.get(), ResourceLocation.withDefaultNamespace((String)"pollen"), (itemStack, world, livingEntity, int1) -> HoneyBeeLeggings.isPollinated(itemStack) ? 1.0f : 0.0f);
        event.register((Item)BzItems.HONEY_BEE_LEGGINGS_2.get(), ResourceLocation.withDefaultNamespace((String)"pollen"), (itemStack, world, livingEntity, int1) -> HoneyBeeLeggings.isPollinated(itemStack) ? 1.0f : 0.0f);
        BumblezoneClient.registerEssenceItemProperty(event, (Item)BzItems.ESSENCE_RAGING.get());
        BumblezoneClient.registerEssenceItemProperty(event, (Item)BzItems.ESSENCE_KNOWING.get());
        BumblezoneClient.registerEssenceItemProperty(event, (Item)BzItems.ESSENCE_CALMING.get());
        BumblezoneClient.registerEssenceItemProperty(event, (Item)BzItems.ESSENCE_LIFE.get());
        BumblezoneClient.registerEssenceItemProperty(event, (Item)BzItems.ESSENCE_RADIANCE.get());
        BumblezoneClient.registerEssenceItemProperty(event, (Item)BzItems.ESSENCE_CONTINUITY.get());
    }

    private static void registerEssenceItemProperty(RegisterItemPropertiesEvent event, Item item) {
        event.register(item, ResourceLocation.withDefaultNamespace((String)"state"), (itemStack, world, livingEntity, integer) -> {
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof AbilityEssenceItem) {
                AbilityEssenceItem abilityEssenceItem = (AbilityEssenceItem)patt0$temp;
                AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
                if (!abilityEssenceActivityData.isInInventory()) {
                    return 0.0f;
                }
                if (abilityEssenceActivityData.isActive()) {
                    return abilityEssenceItem.getAbilityUseRemaining(itemStack) == abilityEssenceItem.getMaxAbilityUseAmount() ? 0.2f : 0.25f;
                }
                if (abilityEssenceActivityData.isLocked() || ((AbilityEssenceCooldownData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get())).forcedCooldown()) {
                    return 0.3f;
                }
                return abilityEssenceItem.getAbilityUseRemaining(itemStack) == abilityEssenceItem.getMaxAbilityUseAmount() ? 0.1f : 0.15f;
            }
            return 0.0f;
        });
    }

    private static void registerRenderTypes(RegisterRenderTypeEvent event) {
        event.register(RenderType.translucent(), (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), (Fluid)BzFluids.SUGAR_WATER_FLUID_FLOWING.get(), (Fluid)BzFluids.HONEY_FLUID.get(), (Fluid)BzFluids.HONEY_FLUID_FLOWING.get(), (Fluid)BzFluids.ROYAL_JELLY_FLUID.get(), (Fluid)BzFluids.ROYAL_JELLY_FLUID_FLOWING.get());
        event.register(RenderType.cutout(), (Block)BzBlocks.STICKY_HONEY_REDSTONE.get(), (Block)BzBlocks.STICKY_HONEY_RESIDUE.get(), (Block)BzBlocks.HONEY_WEB.get(), (Block)BzBlocks.REDSTONE_HONEY_WEB.get(), (Block)BzBlocks.SUPER_CANDLE_WICK.get(), (Block)BzBlocks.SUPER_CANDLE_WICK_SOUL.get(), (Block)BzBlocks.POTION_BASE_CANDLE.get(), (Block)BzBlocks.CRYSTALLINE_FLOWER.get(), (Block)BzBlocks.POROUS_HONEYCOMB.get(), (Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get(), (Block)BzBlocks.INFINITY_BARRIER.get());
        BzBlocks.CURTAINS.stream().map(RegistryEntry::get).forEach(block -> event.register(RenderType.cutout(), (Block)block));
        event.register(RenderType.translucent(), (Block)BzBlocks.HONEY_CRYSTAL.get(), (Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get(), (Block)BzBlocks.ROYAL_JELLY_BLOCK.get(), (Block)BzBlocks.ESSENCE_BLOCK_RED.get(), (Block)BzBlocks.ESSENCE_BLOCK_PURPLE.get(), (Block)BzBlocks.ESSENCE_BLOCK_BLUE.get(), (Block)BzBlocks.ESSENCE_BLOCK_GREEN.get(), (Block)BzBlocks.ESSENCE_BLOCK_YELLOW.get(), (Block)BzBlocks.ESSENCE_BLOCK_WHITE.get());
    }

    public static void registerEntityLayers(RegisterEntityLayersEvent event) {
        if (BzClientConfigs.useBackupModelForVariantBee) {
            event.register(BackupVariantBeeModel.LAYER_LOCATION, BackupVariantBeeModel::createBodyLayer);
        }
        event.register(BeehemothModel.LAYER_LOCATION, BeehemothModel::createBodyLayer);
        event.register(BeeQueenModel.LAYER_LOCATION, BeeQueenModel::createBodyLayer);
        event.register(SentryWatcherModel.LAYER_LOCATION, SentryWatcherModel::createBodyLayer);
        event.register(RootminModel.LAYER_LOCATION, RootminModel::createBodyLayer);
        event.register(StingerSpearModel.LAYER_LOCATION, StingerSpearModel::createLayer);
        event.register(BeeStingerModel.LAYER_LOCATION, BeeStingerModel::createLayer);
        event.register(HoneyCrystalShardModel.LAYER_LOCATION, HoneyCrystalShardModel::createLayer);
        event.register(BeeArmorModel.VARIANT_1_LAYER_LOCATION, BeeArmorModel::createVariant1);
        event.register(BeeArmorModel.VARIANT_2_LAYER_LOCATION, BeeArmorModel::createVariant2);
        event.register(FlowerHeadwearModel.FLOWER_HEADWEAR_LAYER_LOCATION, FlowerHeadwearModel::createBodyLayer);
        event.register(ElectricRingModel.LAYER_LOCATION, ElectricRingModel::createBodyLayer);
        event.register(PurpleSpikeModel.LAYER_LOCATION, PurpleSpikeModel::createBodyLayer);
        event.register(CosmicCrystalModel.LAYER_LOCATION, CosmicCrystalModel::createBodyLayer);
    }

    public static void registerEntityRenderers(RegisterEntityRenderersEvent event) {
        if (BzClientConfigs.useBackupModelForVariantBee) {
            event.register((EntityType)BzEntities.VARIANT_BEE.get(), BackupVariantBeeRenderer::new);
        } else {
            event.register((EntityType)BzEntities.VARIANT_BEE.get(), VariantBeeRenderer::new);
        }
        event.register((EntityType)BzEntities.HONEY_SLIME.get(), HoneySlimeRendering::new);
        event.register((EntityType)BzEntities.BEEHEMOTH.get(), BeehemothRenderer::new);
        event.register((EntityType)BzEntities.BEE_QUEEN.get(), BeeQueenRenderer::new);
        event.register((EntityType)BzEntities.ROOTMIN.get(), RootminRenderer::new);
        event.register((EntityType)BzEntities.SENTRY_WATCHER.get(), SentryWatcherRenderer::new);
        event.register((EntityType)BzEntities.POLLEN_PUFF_ENTITY.get(), ThrownItemRenderer::new);
        event.register((EntityType)BzEntities.DIRT_PELLET_ENTITY.get(), ThrownItemRenderer::new);
        event.register((EntityType)BzEntities.THROWN_STINGER_SPEAR_ENTITY.get(), StingerSpearRenderer::new);
        event.register((EntityType)BzEntities.BEE_STINGER_ENTITY.get(), BeeStingerRenderer::new);
        event.register((EntityType)BzEntities.HONEY_CRYSTAL_SHARD.get(), HoneyCrystalShardRenderer::new);
        event.register((EntityType)BzEntities.ELECTRIC_RING_ENTITY.get(), ElectricRingRenderer::new);
        event.register((EntityType)BzEntities.PURPLE_SPIKE_ENTITY.get(), PurpleSpikeRenderer::new);
        event.register((EntityType)BzEntities.COSMIC_CRYSTAL_ENTITY.get(), CosmicCrystalRenderer::new);
    }

    public static void onParticleSetup(RegisterParticleEvent event) {
        event.register((ParticleType)BzParticles.POLLEN_PARTICLE.get(), PollenPuffParticle.Factory::new);
        event.register((ParticleType)BzParticles.SPARKLE_PARTICLE.get(), SparkleParticle.Factory::new);
        event.register((ParticleType)BzParticles.HONEY_PARTICLE.get(), HoneyParticle.Factory::new);
        event.register((ParticleType)BzParticles.ROYAL_JELLY_PARTICLE.get(), RoyalJellyParticle.Factory::new);
        event.register((ParticleType)BzParticles.DUST_PARTICLE.get(), DustParticle.Factory::new);
        event.register((ParticleType)BzParticles.WIND_PARTICLE.get(), spriteSet -> new WindParticle.Factory((SpriteSet)spriteSet, false));
        event.register((ParticleType)BzParticles.MOVING_WIND_PARTICLE.get(), spriteSet -> new WindParticle.Factory((SpriteSet)spriteSet, true));
        event.register((ParticleType)BzParticles.ANGRY_PARTICLE.get(), VoiceParticle.Factory::new);
        event.register((ParticleType)BzParticles.CURIOUS_PARTICLE.get(), VoiceParticle.Factory::new);
        event.register((ParticleType)BzParticles.CURSING_PARTICLE.get(), VoiceParticle.Factory::new);
        event.register((ParticleType)BzParticles.EMBARRASSED_PARTICLE.get(), VoiceParticle.Factory::new);
        event.register((ParticleType)BzParticles.SHOCK_PARTICLE.get(), VoiceParticle.Factory::new);
    }

    public static void registerDimensionEffects(RegisterDimensionEffectsEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"dimension_special_effects"), new BzDimensionSpecialEffects());
    }

    public static void registerShaders(RegisterShaderEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"rendertype_bumblezone_essence"), EssenceBlockEntityRenderer.POSITION_COLOR_NORMAL, safeShader -> {
            EssenceBlockEntityRenderer.SAFE_SHADER_INSTANCE = safeShader;
        });
    }
}

